/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.estimation.sequential.AbstractCovarianceMatrixProvider;
import org.orekit.frames.LOFType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.CartesianDerivativesFilter;

public class UnivariateProcessNoise
extends AbstractCovarianceMatrixProvider {
    private final LOFType lofType;
    private final PositionAngle positionAngle;
    private final UnivariateFunction[] lofCartesianOrbitalParametersEvolution;
    private final UnivariateFunction[] propagationParametersEvolution;
    private final UnivariateFunction[] measurementsParametersEvolution;

    public UnivariateProcessNoise(RealMatrix initialCovarianceMatrix, LOFType lofType, PositionAngle positionAngle, UnivariateFunction[] lofCartesianOrbitalParametersEvolution, UnivariateFunction[] propagationParametersEvolution) {
        this(initialCovarianceMatrix, lofType, positionAngle, lofCartesianOrbitalParametersEvolution, propagationParametersEvolution, new UnivariateFunction[0]);
    }

    public UnivariateProcessNoise(RealMatrix initialCovarianceMatrix, LOFType lofType, PositionAngle positionAngle, UnivariateFunction[] lofCartesianOrbitalParametersEvolution, UnivariateFunction[] propagationParametersEvolution, UnivariateFunction[] measurementsParametersEvolution) {
        super(initialCovarianceMatrix);
        this.lofType = lofType;
        this.positionAngle = positionAngle;
        this.lofCartesianOrbitalParametersEvolution = (UnivariateFunction[])lofCartesianOrbitalParametersEvolution.clone();
        this.propagationParametersEvolution = (UnivariateFunction[])propagationParametersEvolution.clone();
        this.measurementsParametersEvolution = (UnivariateFunction[])measurementsParametersEvolution.clone();
    }

    public LOFType getLofType() {
        return this.lofType;
    }

    public PositionAngle getPositionAngle() {
        return this.positionAngle;
    }

    public UnivariateFunction[] getLofCartesianOrbitalParametersEvolution() {
        return (UnivariateFunction[])this.lofCartesianOrbitalParametersEvolution.clone();
    }

    public UnivariateFunction[] getPropagationParametersEvolution() {
        return (UnivariateFunction[])this.propagationParametersEvolution.clone();
    }

    public UnivariateFunction[] getMeasurementsParametersEvolution() {
        return (UnivariateFunction[])this.measurementsParametersEvolution.clone();
    }

    @Override
    public RealMatrix getProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        int nbOrb = this.lofCartesianOrbitalParametersEvolution.length;
        int nbPropag = this.propagationParametersEvolution.length;
        int nbMeas = this.measurementsParametersEvolution.length;
        RealMatrix processNoiseMatrix = MatrixUtils.createRealMatrix((int)(nbOrb + nbPropag + nbMeas), (int)(nbOrb + nbPropag + nbMeas));
        if (nbOrb != 0) {
            RealMatrix inertialOrbitalProcessNoiseMatrix = this.getInertialOrbitalProcessNoiseMatrix(previous, current);
            processNoiseMatrix.setSubMatrix(inertialOrbitalProcessNoiseMatrix.getData(), 0, 0);
        }
        if (nbPropag != 0) {
            RealMatrix propagationProcessNoiseMatrix = this.getPropagationProcessNoiseMatrix(previous, current);
            processNoiseMatrix.setSubMatrix(propagationProcessNoiseMatrix.getData(), nbOrb, nbOrb);
        }
        if (nbMeas != 0) {
            RealMatrix measurementsProcessNoiseMatrix = this.getMeasurementsProcessNoiseMatrix(previous, current);
            processNoiseMatrix.setSubMatrix(measurementsProcessNoiseMatrix.getData(), nbOrb + nbPropag, nbOrb + nbPropag);
        }
        return processNoiseMatrix;
    }

    private RealMatrix getInertialOrbitalProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        double deltaT = current.getDate().durationFrom(previous.getDate());
        int lofOrbitalprocessNoiseLength = this.lofCartesianOrbitalParametersEvolution.length;
        double[] lofOrbitalProcessNoiseValues = new double[lofOrbitalprocessNoiseLength];
        for (int i = 0; i < lofOrbitalprocessNoiseLength; ++i) {
            double functionValue = this.lofCartesianOrbitalParametersEvolution[i].value(deltaT);
            lofOrbitalProcessNoiseValues[i] = functionValue * functionValue;
        }
        RealMatrix lofCartesianProcessNoiseMatrix = MatrixUtils.createRealDiagonalMatrix((double[])lofOrbitalProcessNoiseValues);
        double[][] dLofdInertial = new double[6][6];
        this.lofType.transformFromInertial(current.getDate(), current.getPVCoordinates()).getInverse().getJacobian(CartesianDerivativesFilter.USE_PV, dLofdInertial);
        RealMatrix jacLofToInertial = MatrixUtils.createRealMatrix((double[][])dLofdInertial);
        double[][] dYdC = new double[6][6];
        current.getOrbit().getJacobianWrtCartesian(this.positionAngle, dYdC);
        RealMatrix jacOrbitWrtCartesian = MatrixUtils.createRealMatrix((double[][])dYdC);
        RealMatrix jacobian = jacOrbitWrtCartesian.multiply(jacLofToInertial);
        RealMatrix inertialOrbitalProcessNoiseMatrix = jacobian.multiply(lofCartesianProcessNoiseMatrix).multiplyTransposed(jacobian);
        return inertialOrbitalProcessNoiseMatrix;
    }

    private RealMatrix getPropagationProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        double deltaT = current.getDate().durationFrom(previous.getDate());
        int propagationProcessNoiseLength = this.propagationParametersEvolution.length;
        double[] propagationProcessNoiseValues = new double[propagationProcessNoiseLength];
        for (int i = 0; i < propagationProcessNoiseLength; ++i) {
            double functionValue = this.propagationParametersEvolution[i].value(deltaT);
            propagationProcessNoiseValues[i] = functionValue * functionValue;
        }
        return MatrixUtils.createRealDiagonalMatrix((double[])propagationProcessNoiseValues);
    }

    private RealMatrix getMeasurementsProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        double deltaT = current.getDate().durationFrom(previous.getDate());
        int measurementsProcessNoiseLength = this.measurementsParametersEvolution.length;
        double[] measurementsProcessNoiseValues = new double[measurementsProcessNoiseLength];
        for (int i = 0; i < measurementsProcessNoiseLength; ++i) {
            double functionValue = this.measurementsParametersEvolution[i].value(deltaT);
            measurementsProcessNoiseValues[i] = functionValue * functionValue;
        }
        return MatrixUtils.createRealDiagonalMatrix((double[])measurementsProcessNoiseValues);
    }
}

