/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.List;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.filtering.kalman.extended.ExtendedKalmanFilter;
import org.hipparchus.filtering.kalman.extended.NonLinearProcess;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanObserver;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.estimation.sequential.SemiAnalyticalKalmanModel;
import org.orekit.propagation.conversion.DSSTPropagatorBuilder;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class SemiAnalyticalKalmanEstimator {
    private DSSTPropagatorBuilder propagatorBuilder;
    private final SemiAnalyticalKalmanModel processModel;
    private final ExtendedKalmanFilter<MeasurementDecorator> filter;
    private KalmanObserver observer;

    public SemiAnalyticalKalmanEstimator(MatrixDecomposer decomposer, DSSTPropagatorBuilder propagatorBuilder, CovarianceMatrixProvider covarianceMatrixProvider, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        this.propagatorBuilder = propagatorBuilder;
        this.observer = null;
        this.processModel = new SemiAnalyticalKalmanModel(propagatorBuilder, covarianceMatrixProvider, estimatedMeasurementParameters, measurementProcessNoiseMatrix);
        this.filter = new ExtendedKalmanFilter(decomposer, (NonLinearProcess)this.processModel, this.processModel.getEstimate());
    }

    public void setObserver(KalmanObserver observer) {
        this.observer = observer;
    }

    public int getCurrentMeasurementNumber() {
        return this.processModel.getCurrentMeasurementNumber();
    }

    public AbsoluteDate getCurrentDate() {
        return this.processModel.getCurrentDate();
    }

    public RealVector getPhysicalEstimatedState() {
        return this.processModel.getPhysicalEstimatedState();
    }

    public RealMatrix getPhysicalEstimatedCovarianceMatrix() {
        return this.processModel.getPhysicalEstimatedCovarianceMatrix();
    }

    public ParameterDriversList getOrbitalParametersDrivers(boolean estimatedOnly) {
        ParameterDriversList estimated = new ParameterDriversList();
        for (ParameterDriver parameterDriver : this.propagatorBuilder.getOrbitalParametersDrivers().getDrivers()) {
            if (!parameterDriver.isSelected() && estimatedOnly) continue;
            parameterDriver.setName(parameterDriver.getName());
            estimated.add(parameterDriver);
        }
        return estimated;
    }

    public ParameterDriversList getPropagationParametersDrivers(boolean estimatedOnly) {
        ParameterDriversList estimated = new ParameterDriversList();
        for (ParameterDriversList.DelegatingDriver delegating : this.propagatorBuilder.getPropagationParametersDrivers().getDrivers()) {
            if (!delegating.isSelected() && estimatedOnly) continue;
            for (ParameterDriver driver : delegating.getRawDrivers()) {
                estimated.add(driver);
            }
        }
        return estimated;
    }

    public ParameterDriversList getEstimatedMeasurementsParameters() {
        return this.processModel.getEstimatedMeasurementsParameters();
    }

    public DSSTPropagator processMeasurements(List<ObservedMeasurement<?>> observedMeasurements) {
        try {
            this.processModel.setObserver(this.observer);
            return this.processModel.processMeasurements(observedMeasurements, this.filter);
        }
        catch (MathRuntimeException mrte) {
            throw new OrekitException(mrte);
        }
    }
}

