/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.gnss.Phase;
import org.orekit.estimation.measurements.modifiers.AbstractShapiroBaseModifier;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ShapiroPhaseModifier
extends AbstractShapiroBaseModifier
implements EstimationModifier<Phase> {
    public ShapiroPhaseModifier(double gm) {
        super(gm);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<Phase> estimated) {
        double wavelength = estimated.getObservedMeasurement().getWavelength();
        TimeStampedPVCoordinates[] pv = estimated.getParticipants();
        double correction = this.shapiroCorrection(pv[0], pv[1]) / wavelength;
        double[] newValue = (double[])estimated.getEstimatedValue().clone();
        newValue[0] = newValue[0] + correction;
        estimated.setEstimatedValue(newValue);
    }
}

