/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.filtering;

import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.filtering.MeasurementFilter;
import org.orekit.propagation.SpacecraftState;

public class ElevationFilter<T extends ObservedMeasurement<T>>
implements MeasurementFilter<T> {
    private final double threshold;
    private final GroundStation station;

    public ElevationFilter(GroundStation station, double threshold) {
        this.station = station;
        this.threshold = threshold;
    }

    @Override
    public void filter(ObservedMeasurement<T> measurement, SpacecraftState state) {
        double trueElevation = this.station.getBaseFrame().getElevation(state.getPVCoordinates().getPosition(), state.getFrame(), state.getDate());
        if (trueElevation < this.threshold) {
            measurement.setEnabled(false);
        }
    }
}

