/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TurnAroundRange
extends AbstractMeasurement<TurnAroundRange> {
    private final GroundStation primaryStation;
    private final GroundStation secondaryStation;

    public TurnAroundRange(GroundStation primaryStation, GroundStation secondaryStation, AbsoluteDate date, double turnAroundRange, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(date, turnAroundRange, sigma, baseWeight, Collections.singletonList(satellite));
        this.addParameterDriver(primaryStation.getClockOffsetDriver());
        this.addParameterDriver(primaryStation.getEastOffsetDriver());
        this.addParameterDriver(primaryStation.getNorthOffsetDriver());
        this.addParameterDriver(primaryStation.getZenithOffsetDriver());
        this.addParameterDriver(primaryStation.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(primaryStation.getPrimeMeridianDriftDriver());
        this.addParameterDriver(primaryStation.getPolarOffsetXDriver());
        this.addParameterDriver(primaryStation.getPolarDriftXDriver());
        this.addParameterDriver(primaryStation.getPolarOffsetYDriver());
        this.addParameterDriver(primaryStation.getPolarDriftYDriver());
        this.addParameterDriver(secondaryStation.getEastOffsetDriver());
        this.addParameterDriver(secondaryStation.getNorthOffsetDriver());
        this.addParameterDriver(secondaryStation.getZenithOffsetDriver());
        this.addParameterDriver(secondaryStation.getPrimeMeridianOffsetDriver());
        this.addParameterDriver(secondaryStation.getPrimeMeridianDriftDriver());
        this.addParameterDriver(secondaryStation.getPolarOffsetXDriver());
        this.addParameterDriver(secondaryStation.getPolarDriftXDriver());
        this.addParameterDriver(secondaryStation.getPolarOffsetYDriver());
        this.addParameterDriver(secondaryStation.getPolarDriftYDriver());
        this.primaryStation = primaryStation;
        this.secondaryStation = secondaryStation;
    }

    public GroundStation getPrimaryStation() {
        return this.primaryStation;
    }

    public GroundStation getSecondaryStation() {
        return this.secondaryStation;
    }

    @Override
    protected EstimatedMeasurement<TurnAroundRange> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected() || indices.containsKey(driver.getName())) continue;
            indices.put(driver.getName(), nbParams++);
        }
        GradientField field = GradientField.getField((int)nbParams);
        FieldVector3D zero = FieldVector3D.getZero((Field)field);
        TimeStampedFieldPVCoordinates<Gradient> pvaDS = TurnAroundRange.getCoordinates(state, 0, nbParams);
        double delta = this.getDate().durationFrom(state.getDate());
        FieldTransform<Gradient> primaryToInert = this.primaryStation.getOffsetToInertial(state.getFrame(), this.getDate(), nbParams, indices);
        FieldAbsoluteDate<Gradient> measurementDateDS = primaryToInert.getFieldDate();
        TimeStampedFieldPVCoordinates<Gradient> primaryArrival = primaryToInert.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(measurementDateDS, zero, zero, zero));
        Gradient primaryTauD = TurnAroundRange.signalTimeOfFlight(pvaDS, primaryArrival.getPosition(), measurementDateDS);
        Gradient dtLeg2 = primaryTauD.negate().add(delta);
        SpacecraftState transitStateLeg2 = state.shiftedBy(dtLeg2.getValue());
        FieldPVCoordinates transitStateLeg2PV = pvaDS.shiftedBy((CalculusFieldElement)dtLeg2);
        TimeShiftable approxReboundDate = measurementDateDS.shiftedBy(-delta);
        FieldTransform<Gradient> secondaryToInertApprox = this.secondaryStation.getOffsetToInertial(state.getFrame(), (FieldAbsoluteDate<Gradient>)approxReboundDate, nbParams, indices);
        TimeStampedFieldPVCoordinates<Gradient> QSecondaryApprox = secondaryToInertApprox.transformPVCoordinates(new TimeStampedFieldPVCoordinates(approxReboundDate, zero, zero, zero));
        Gradient secondaryTauU = TurnAroundRange.signalTimeOfFlight(QSecondaryApprox, transitStateLeg2PV.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateLeg2PV).getDate());
        Gradient tauLeg2 = primaryTauD.add(secondaryTauU);
        FieldAbsoluteDate<Gradient> reboundDateDS = measurementDateDS.shiftedBy(tauLeg2.negate());
        FieldTransform<Gradient> secondaryToInert = this.secondaryStation.getOffsetToInertial(state.getFrame(), reboundDateDS, nbParams, indices);
        TimeStampedFieldPVCoordinates<Gradient> secondaryRebound = secondaryToInert.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(reboundDateDS, FieldPVCoordinates.getZero(field)));
        Gradient secondaryTauD = TurnAroundRange.signalTimeOfFlight(transitStateLeg2PV, secondaryRebound.getPosition(), reboundDateDS);
        Gradient dtLeg1 = dtLeg2.subtract(secondaryTauU).subtract(secondaryTauD);
        FieldPVCoordinates transitStateLeg1PV = pvaDS.shiftedBy((CalculusFieldElement)dtLeg1);
        TimeShiftable approxEmissionDate = measurementDateDS.shiftedBy(-2.0 * (secondaryTauU.getValue() + primaryTauD.getValue()));
        FieldTransform<Gradient> primaryToInertApprox = this.primaryStation.getOffsetToInertial(state.getFrame(), (FieldAbsoluteDate<Gradient>)approxEmissionDate, nbParams, indices);
        TimeStampedFieldPVCoordinates<Gradient> QPrimaryApprox = primaryToInertApprox.transformPVCoordinates(new TimeStampedFieldPVCoordinates(approxEmissionDate, zero, zero, zero));
        Gradient primaryTauU = TurnAroundRange.signalTimeOfFlight(QPrimaryApprox, transitStateLeg1PV.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateLeg1PV).getDate());
        AbsoluteDate emissionDate = ((TimeStampedFieldPVCoordinates)transitStateLeg1PV).getDate().toAbsoluteDate().shiftedBy(-primaryTauU.getValue());
        TimeStampedPVCoordinates primaryDeparture = ((FieldTransform)primaryToInertApprox.shiftedBy(emissionDate.durationFrom(primaryToInertApprox.getDate()))).transformPVCoordinates(new TimeStampedPVCoordinates(emissionDate, PVCoordinates.ZERO)).toTimeStampedPVCoordinates();
        Gradient tauLeg1 = secondaryTauD.add(primaryTauU);
        EstimatedMeasurement<TurnAroundRange> estimated = new EstimatedMeasurement<TurnAroundRange>(this, iteration, evaluation, new SpacecraftState[]{transitStateLeg2.shiftedBy(-secondaryTauU.getValue())}, new TimeStampedPVCoordinates[]{primaryDeparture, ((TimeStampedFieldPVCoordinates)transitStateLeg1PV).toTimeStampedPVCoordinates(), secondaryRebound.toTimeStampedPVCoordinates(), transitStateLeg2.getPVCoordinates(), primaryArrival.toTimeStampedPVCoordinates()});
        double cOver2 = 1.49896229E8;
        Gradient turnAroundRange = tauLeg2.add(tauLeg1).multiply(1.49896229E8);
        estimated.setEstimatedValue(turnAroundRange.getValue());
        double[] derivatives = turnAroundRange.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, derivatives[index]);
        }
        return estimated;
    }
}

