/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataFilter;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIOException;
import org.orekit.errors.OrekitMessages;

public class UnixCompressFilter
implements DataFilter {
    private static final String SUFFIX = ".Z";

    @Override
    public DataSource filter(DataSource original) {
        String oName = original.getName();
        DataSource.Opener oOpener = original.getOpener();
        if (oName.endsWith(SUFFIX)) {
            String fName = oName.substring(0, oName.length() - SUFFIX.length());
            DataSource.StreamOpener fOpener = () -> new ZInputStream(oName, new Buffer(oOpener.openStreamOnce()));
            return new DataSource(fName, fOpener);
        }
        return original;
    }

    private static class Buffer {
        private static final int BUFFER_SIZE = 4096;
        private final InputStream input;
        private final byte[] data;
        private int start;
        private int end;

        Buffer(InputStream input) {
            this.input = input;
            this.data = new byte[4096];
            this.end = this.start = 0;
        }

        private int getByte() throws IOException {
            if (this.start == this.end) {
                this.start = 0;
                this.end = this.input.read(this.data);
                if (this.end == -1) {
                    return -1;
                }
            }
            return this.data[this.start++] & 0xFF;
        }
    }

    private static class UncompressedSequence {
        private final UncompressedSequence prefix;
        private final byte last;
        private final int index;

        UncompressedSequence(UncompressedSequence prefix, byte last) {
            this.prefix = prefix;
            this.last = last;
            this.index = prefix == null ? 0 : prefix.index + 1;
        }

        public int length() {
            return this.index + 1;
        }

        public byte getByte(int outputIndex) {
            return this.index == outputIndex ? this.last : this.prefix.getByte(outputIndex);
        }
    }

    private static class ZInputStream
    extends InputStream {
        private static final int MAGIC_HEADER_1 = 31;
        private static final int MAGIC_HEADER_2 = 157;
        private static final int BYTE_WIDTH = 8;
        private static final int INIT_WIDTH = 9;
        private static final int RESET_TABLE = 256;
        private static final int FIRST = 257;
        private final String name;
        private boolean endOfInput;
        private final UncompressedSequence[] table;
        private int available;
        private final boolean blockMode;
        private final int maxWidth;
        private int currentWidth;
        private int currentMaxKey;
        private int bitsRead;
        private int lookAhead;
        private int lookAheadWidth;
        private Buffer input;
        private UncompressedSequence previousSequence;
        private UncompressedSequence currentSequence;
        private int alreadyOutput;

        ZInputStream(String name, Buffer input) throws IOException {
            this.name = name;
            this.input = input;
            this.endOfInput = false;
            if (input.getByte() != 31 || input.getByte() != 157) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_UNIX_COMPRESSED_FILE, name);
            }
            int header3 = input.getByte();
            this.blockMode = (header3 & 0x80) != 0;
            this.maxWidth = header3 & 0x1F;
            this.table = new UncompressedSequence[1 << FastMath.max((int)9, (int)this.maxWidth)];
            for (int i = 0; i < 257; ++i) {
                this.table[i] = new UncompressedSequence(null, (byte)i);
            }
            this.initialize();
        }

        private void initialize() {
            this.available = 257;
            this.bitsRead = 0;
            this.lookAhead = 0;
            this.lookAheadWidth = 0;
            this.currentWidth = 9;
            this.currentMaxKey = (1 << this.currentWidth) - 1;
            this.previousSequence = null;
            this.currentSequence = null;
            this.alreadyOutput = 0;
        }

        private int nextKey() throws IOException {
            int key;
            int keyMask = (1 << this.currentWidth) - 1;
            while (true) {
                key = this.lookAhead & keyMask;
                for (int remaining = this.currentWidth - this.lookAheadWidth; remaining > 0; remaining -= 8) {
                    this.lookAhead = this.input.getByte();
                    this.lookAheadWidth += 8;
                    if (this.lookAhead < 0) {
                        if (key == 0 || key == keyMask) {
                            return -1;
                        }
                        throw new OrekitIOException(OrekitMessages.UNEXPECTED_END_OF_FILE, this.name);
                    }
                    key = (key | this.lookAhead << this.currentWidth - remaining) & keyMask;
                }
                this.lookAheadWidth -= this.currentWidth;
                this.lookAhead >>>= 8 - this.lookAheadWidth;
                this.bitsRead += this.currentWidth;
                if (!this.blockMode || key != 256) break;
                int superSize = this.currentWidth * 8;
                int padding = (superSize - 1 - (this.bitsRead + superSize - 1) % superSize) / 8;
                while (padding-- > 0) {
                    this.input.getByte();
                }
                Arrays.fill(this.table, 257, this.table.length, null);
                this.initialize();
                keyMask = (1 << this.currentWidth) - 1;
            }
            return key;
        }

        private boolean selectNext() throws IOException {
            int key = this.nextKey();
            if (key < 0) {
                return false;
            }
            if (this.previousSequence != null && this.available < this.table.length) {
                byte nextByte;
                if (key == this.available) {
                    nextByte = this.previousSequence.getByte(0);
                } else if (this.table[key] != null) {
                    nextByte = this.table[key].getByte(0);
                } else {
                    throw new OrekitIOException(OrekitMessages.CORRUPTED_FILE, this.name);
                }
                this.table[this.available++] = new UncompressedSequence(this.previousSequence, nextByte);
                if (this.available > this.currentMaxKey && this.currentWidth < this.maxWidth) {
                    this.currentMaxKey = (1 << ++this.currentWidth) - 1;
                }
            }
            this.currentSequence = this.table[key];
            if (this.currentSequence == null) {
                throw new OrekitIOException(OrekitMessages.CORRUPTED_FILE, this.name);
            }
            this.alreadyOutput = 0;
            return true;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b, 0, 1) < 0 ? -1 : b[0];
        }

        @Override
        public int read(byte[] b, int offset, int len) throws IOException {
            if (this.currentSequence == null && (this.endOfInput || !this.selectNext())) {
                this.endOfInput = true;
                return -1;
            }
            int n = FastMath.min((int)len, (int)(this.currentSequence.length() - this.alreadyOutput));
            for (int i = 0; i < n; ++i) {
                b[offset + i] = this.currentSequence.getByte(this.alreadyOutput++);
            }
            if (this.alreadyOutput >= this.currentSequence.length()) {
                this.previousSequence = this.currentSequence;
                this.currentSequence = null;
                this.alreadyOutput = 0;
            }
            return n;
        }

        @Override
        public int available() {
            return this.currentSequence == null ? 0 : this.currentSequence.length() - this.alreadyOutput;
        }
    }
}

