/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.SinCos;
import org.orekit.data.BodiesElements;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.GeneralTerm;
import org.orekit.data.LuniSolarTerm;
import org.orekit.data.NoFarPlanetsTerm;
import org.orekit.data.PlanetaryTerm;
import org.orekit.data.TideTerm;
import org.orekit.errors.OrekitInternalError;

abstract class SeriesTerm {
    private double[][] sinCoeff = new double[0][0];
    private double[][] cosCoeff = new double[0][0];

    protected SeriesTerm() {
    }

    public int getDegree(int index) {
        return this.sinCoeff[index].length - 1;
    }

    public void add(int index, int degree, double sinID, double cosID) {
        this.sinCoeff = SeriesTerm.extendArray(index, degree, this.sinCoeff);
        this.cosCoeff = SeriesTerm.extendArray(index, degree, this.cosCoeff);
        if (degree >= 0) {
            double[] dArray = this.sinCoeff[index];
            int n = degree;
            dArray[n] = dArray[n] + sinID;
            double[] dArray2 = this.cosCoeff[index];
            int n2 = degree;
            dArray2[n2] = dArray2[n2] + cosID;
        }
    }

    public double getSinCoeff(int index, int degree) {
        return this.sinCoeff[index][degree];
    }

    public double getCosCoeff(int index, int degree) {
        return this.cosCoeff[index][degree];
    }

    public double[] value(BodiesElements elements) {
        double tc = elements.getTC();
        double a = this.argument(elements);
        SinCos sc = FastMath.sinCos((double)a);
        double[] values = new double[this.sinCoeff.length];
        for (int i = 0; i < values.length; ++i) {
            double s = 0.0;
            double c = 0.0;
            for (int j = this.sinCoeff[i].length - 1; j >= 0; --j) {
                s = s * tc + this.sinCoeff[i][j];
                c = c * tc + this.cosCoeff[i][j];
            }
            values[i] = s * sc.sin() + c * sc.cos();
        }
        return values;
    }

    public double[] derivative(BodiesElements elements) {
        double tc = elements.getTC();
        double a = this.argument(elements);
        double aDot = this.argumentDerivative(elements);
        SinCos sc = FastMath.sinCos((double)a);
        double[] derivatives = new double[this.sinCoeff.length];
        for (int i = 0; i < derivatives.length; ++i) {
            double s = 0.0;
            double c = 0.0;
            double sDot = 0.0;
            double cDot = 0.0;
            if (this.sinCoeff[i].length > 0) {
                for (int j = this.sinCoeff[i].length - 1; j > 0; --j) {
                    s = s * tc + this.sinCoeff[i][j];
                    c = c * tc + this.cosCoeff[i][j];
                    sDot = sDot * tc + (double)j * this.sinCoeff[i][j];
                    cDot = cDot * tc + (double)j * this.cosCoeff[i][j];
                }
                s = s * tc + this.sinCoeff[i][0];
                c = c * tc + this.cosCoeff[i][0];
                sDot /= 3.15576E9;
                cDot /= 3.15576E9;
            }
            derivatives[i] = (sDot - c * aDot) * sc.sin() + (cDot + s * aDot) * sc.cos();
        }
        return derivatives;
    }

    protected abstract double argument(BodiesElements var1);

    protected abstract double argumentDerivative(BodiesElements var1);

    public <T extends CalculusFieldElement<T>> T[] value(FieldBodiesElements<T> elements) {
        Object tc = elements.getTC();
        T a = this.argument(elements);
        FieldSinCos sc = FastMath.sinCos(a);
        CalculusFieldElement[] values = (CalculusFieldElement[])MathArrays.buildArray((Field)tc.getField(), (int)this.sinCoeff.length);
        for (int i = 0; i < values.length; ++i) {
            CalculusFieldElement s = (CalculusFieldElement)tc.getField().getZero();
            CalculusFieldElement c = (CalculusFieldElement)tc.getField().getZero();
            for (int j = this.sinCoeff[i].length - 1; j >= 0; --j) {
                s = (CalculusFieldElement)((CalculusFieldElement)s.multiply(tc)).add(this.sinCoeff[i][j]);
                c = (CalculusFieldElement)((CalculusFieldElement)c.multiply(tc)).add(this.cosCoeff[i][j]);
            }
            values[i] = (CalculusFieldElement)((CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)sc.sin()))).add((FieldElement)((CalculusFieldElement)c.multiply((FieldElement)((CalculusFieldElement)sc.cos()))));
        }
        return values;
    }

    public <T extends CalculusFieldElement<T>> T[] derivative(FieldBodiesElements<T> elements) {
        Object tc = elements.getTC();
        T a = this.argument(elements);
        T aDot = this.argumentDerivative(elements);
        FieldSinCos sc = FastMath.sinCos(a);
        CalculusFieldElement[] derivatives = (CalculusFieldElement[])MathArrays.buildArray((Field)tc.getField(), (int)this.sinCoeff.length);
        for (int i = 0; i < derivatives.length; ++i) {
            CalculusFieldElement s = (CalculusFieldElement)tc.getField().getZero();
            CalculusFieldElement c = (CalculusFieldElement)tc.getField().getZero();
            CalculusFieldElement sDot = (CalculusFieldElement)tc.getField().getZero();
            CalculusFieldElement cDot = (CalculusFieldElement)tc.getField().getZero();
            if (this.sinCoeff[i].length > 0) {
                for (int j = this.sinCoeff[i].length - 1; j > 0; --j) {
                    s = (CalculusFieldElement)((CalculusFieldElement)s.multiply(tc)).add(this.sinCoeff[i][j]);
                    c = (CalculusFieldElement)((CalculusFieldElement)c.multiply(tc)).add(this.cosCoeff[i][j]);
                    sDot = (CalculusFieldElement)((CalculusFieldElement)sDot.multiply(tc)).add((double)j * this.sinCoeff[i][j]);
                    cDot = (CalculusFieldElement)((CalculusFieldElement)cDot.multiply(tc)).add((double)j * this.cosCoeff[i][j]);
                }
                s = (CalculusFieldElement)((CalculusFieldElement)s.multiply(tc)).add(this.sinCoeff[i][0]);
                c = (CalculusFieldElement)((CalculusFieldElement)c.multiply(tc)).add(this.cosCoeff[i][0]);
                sDot = (CalculusFieldElement)sDot.divide(3.15576E9);
                cDot = (CalculusFieldElement)cDot.divide(3.15576E9);
            }
            derivatives[i] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sDot.subtract((FieldElement)((CalculusFieldElement)c.multiply(aDot)))).multiply((FieldElement)((CalculusFieldElement)sc.sin()))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cDot.add((FieldElement)((CalculusFieldElement)s.multiply(aDot)))).multiply((FieldElement)((CalculusFieldElement)sc.cos()))));
        }
        return derivatives;
    }

    protected abstract <T extends CalculusFieldElement<T>> T argument(FieldBodiesElements<T> var1);

    protected abstract <T extends CalculusFieldElement<T>> T argumentDerivative(FieldBodiesElements<T> var1);

    public static SeriesTerm buildTerm(int cGamma, int cL, int cLPrime, int cF, int cD, int cOmega, int cMe, int cVe, int cE, int cMa, int cJu, int cSa, int cUr, int cNe, int cPa) {
        if (cGamma == 0 && cL == 0 && cLPrime == 0 && cF == 0 && cD == 0 && cOmega == 0) {
            return new PlanetaryTerm(cMe, cVe, cE, cMa, cJu, cSa, cUr, cNe, cPa);
        }
        if (cGamma == 0 && cMe == 0 && cVe == 0 && cE == 0 && cMa == 0 && cJu == 0 && cSa == 0 && cUr == 0 && cNe == 0 && cPa == 0) {
            return new LuniSolarTerm(cL, cLPrime, cF, cD, cOmega);
        }
        if (cGamma != 0 && cMe == 0 && cVe == 0 && cE == 0 && cMa == 0 && cJu == 0 && cSa == 0 && cUr == 0 && cNe == 0 && cPa == 0) {
            return new TideTerm(cGamma, cL, cLPrime, cF, cD, cOmega);
        }
        if (cGamma == 0 && cLPrime == 0 && cUr == 0 && cNe == 0 && cPa == 0) {
            return new NoFarPlanetsTerm(cL, cF, cD, cOmega, cMe, cVe, cE, cMa, cJu, cSa);
        }
        if (cGamma == 0) {
            return new GeneralTerm(cL, cLPrime, cF, cD, cOmega, cMe, cVe, cE, cMa, cJu, cSa, cUr, cNe, cPa);
        }
        throw new OrekitInternalError(null);
    }

    private static double[][] extendArray(int index, int degree, double[][] array) {
        Object extended;
        if (array.length > index) {
            extended = array;
        } else {
            int rows = index + 1;
            extended = new double[rows][];
            System.arraycopy(array, 0, extended, 0, array.length);
            Arrays.fill((Object[])extended, array.length, index + 1, new double[0]);
        }
        extended[index] = SeriesTerm.extendArray(degree, extended[index]);
        return extended;
    }

    private static double[] extendArray(int degree, double[] array) {
        if (array.length > degree) {
            return array;
        }
        double[] extended = new double[degree + 1];
        System.arraycopy(array, 0, extended, 0, array.length);
        return extended;
    }
}

