/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class DataSource {
    private final String name;
    private final Opener opener;

    public DataSource(String name, StreamOpener streamOpener) {
        this.name = name;
        this.opener = new BinaryBasedOpener(streamOpener);
    }

    public DataSource(String name, ReaderOpener readerOpener) {
        this.name = name;
        this.opener = new ReaderBasedOpener(readerOpener);
    }

    public DataSource(String fileName) {
        this(fileName, () -> Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]));
    }

    public DataSource(File file) {
        this(file.getName(), () -> new FileInputStream(file));
    }

    public DataSource(URI uri) {
        this(Paths.get(uri).toFile());
    }

    public String getName() {
        return this.name;
    }

    public Opener getOpener() {
        return this.opener;
    }

    private static class ReaderBasedOpener
    implements Opener {
        private static final int BUFFER_SIZE = 4096;
        private final ReaderOpener readerOpener;

        ReaderBasedOpener(ReaderOpener readerOpener) {
            this.readerOpener = readerOpener;
        }

        @Override
        public boolean rawDataIsBinary() {
            return false;
        }

        @Override
        public InputStream openStreamOnce() throws IOException {
            final Reader reader = this.openReaderOnce();
            if (reader == null) {
                return null;
            }
            return new InputStream(){
                private ByteBuffer buffer = null;

                @Override
                public int read() throws IOException {
                    if (this.buffer == null || !this.buffer.hasRemaining()) {
                        CharBuffer cb = CharBuffer.allocate(4096);
                        int read = reader.read(cb);
                        if (read < 0) {
                            return read;
                        }
                        int last = cb.position();
                        cb.rewind();
                        this.buffer = StandardCharsets.UTF_8.encode(cb.subSequence(0, last));
                    }
                    return this.buffer.get();
                }
            };
        }

        @Override
        public Reader openReaderOnce() throws IOException {
            return this.readerOpener.openOnce();
        }
    }

    private static class BinaryBasedOpener
    implements Opener {
        private final StreamOpener streamOpener;

        BinaryBasedOpener(StreamOpener streamOpener) {
            this.streamOpener = streamOpener;
        }

        @Override
        public boolean rawDataIsBinary() {
            return true;
        }

        @Override
        public InputStream openStreamOnce() throws IOException {
            return this.streamOpener.openOnce();
        }

        @Override
        public Reader openReaderOnce() throws IOException {
            InputStream is = this.openStreamOnce();
            return is == null ? null : new InputStreamReader(is, StandardCharsets.UTF_8);
        }
    }

    public static interface Opener {
        public boolean rawDataIsBinary();

        public InputStream openStreamOnce() throws IOException;

        public Reader openReaderOnce() throws IOException;
    }

    public static interface ReaderOpener {
        public Reader openOnce() throws IOException;
    }

    public static interface StreamOpener {
        public InputStream openOnce() throws IOException;
    }
}

