/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.optim.AbstractConvergenceChecker;
import org.hipparchus.optim.PointValuePair;
import org.hipparchus.util.FastMath;

public class SimpleValueChecker
extends AbstractConvergenceChecker<PointValuePair> {
    private static final int ITERATION_CHECK_DISABLED = -1;
    private final int maxIterationCount;

    public SimpleValueChecker(double relativeThreshold, double absoluteThreshold) {
        super(relativeThreshold, absoluteThreshold);
        this.maxIterationCount = -1;
    }

    public SimpleValueChecker(double relativeThreshold, double absoluteThreshold, int maxIter) {
        super(relativeThreshold, absoluteThreshold);
        if (maxIter <= 0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, new Object[]{maxIter, 0});
        }
        this.maxIterationCount = maxIter;
    }

    @Override
    public boolean converged(int iteration, PointValuePair previous, PointValuePair current) {
        double size;
        double c;
        if (this.maxIterationCount != -1 && iteration >= this.maxIterationCount) {
            return true;
        }
        double p = (Double)previous.getValue();
        double difference = FastMath.abs((double)(p - (c = ((Double)current.getValue()).doubleValue())));
        return difference <= (size = FastMath.max((double)FastMath.abs((double)p), (double)FastMath.abs((double)c))) * this.getRelativeThreshold() || difference <= this.getAbsoluteThreshold();
    }
}

