/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.GillFieldStateInterpolator;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldIntegrator;
import org.hipparchus.util.MathArrays;

public class GillFieldIntegrator<T extends CalculusFieldElement<T>>
extends RungeKuttaFieldIntegrator<T> {
    public GillFieldIntegrator(Field<T> field, T step) {
        super(field, "Gill", step);
    }

    @Override
    public T[] getC() {
        CalculusFieldElement[] c = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)3);
        c[0] = this.fraction(1, 2);
        c[1] = c[0];
        c[2] = (CalculusFieldElement)this.getField().getOne();
        return c;
    }

    @Override
    public T[][] getA() {
        CalculusFieldElement two = (CalculusFieldElement)((CalculusFieldElement)this.getField().getZero()).add(2.0);
        CalculusFieldElement sqrtTwo = (CalculusFieldElement)two.sqrt();
        CalculusFieldElement[][] a = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)3, (int)-1);
        for (int i = 0; i < a.length; ++i) {
            a[i] = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)(i + 1));
        }
        a[0][0] = this.fraction(1, 2);
        a[1][0] = (CalculusFieldElement)((CalculusFieldElement)sqrtTwo.subtract(1.0)).multiply(0.5);
        a[1][1] = (CalculusFieldElement)((CalculusFieldElement)sqrtTwo.subtract(2.0)).multiply(-0.5);
        a[2][0] = (CalculusFieldElement)this.getField().getZero();
        a[2][1] = (CalculusFieldElement)sqrtTwo.multiply(-0.5);
        a[2][2] = (CalculusFieldElement)((CalculusFieldElement)sqrtTwo.add(2.0)).multiply(0.5);
        return a;
    }

    @Override
    public T[] getB() {
        CalculusFieldElement two = (CalculusFieldElement)((CalculusFieldElement)this.getField().getZero()).add(2.0);
        CalculusFieldElement sqrtTwo = (CalculusFieldElement)two.sqrt();
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)4);
        b[0] = this.fraction(1, 6);
        b[1] = (CalculusFieldElement)((CalculusFieldElement)sqrtTwo.subtract(2.0)).divide(-6.0);
        b[2] = (CalculusFieldElement)((CalculusFieldElement)sqrtTwo.add(2.0)).divide(6.0);
        b[3] = b[0];
        return b;
    }

    @Override
    protected GillFieldStateInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new GillFieldStateInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

