/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldStateInterpolator;

class EulerFieldStateInterpolator<T extends CalculusFieldElement<T>>
extends RungeKuttaFieldStateInterpolator<T> {
    EulerFieldStateInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected EulerFieldStateInterpolator<T> create(Field<T> newField, boolean newForward, T[][] newYDotK, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new EulerFieldStateInterpolator(newField, newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> mapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        CalculusFieldElement[] interpolatedDerivatives;
        CalculusFieldElement[] interpolatedState;
        if (this.getGlobalPreviousState() != null && theta.getReal() <= 0.5) {
            interpolatedState = this.previousStateLinearCombination(new CalculusFieldElement[]{thetaH});
            interpolatedDerivatives = this.derivativeLinearCombination(new CalculusFieldElement[]{(CalculusFieldElement)time.getField().getOne()});
        } else {
            interpolatedState = this.currentStateLinearCombination(new CalculusFieldElement[]{(CalculusFieldElement)oneMinusThetaH.negate()});
            interpolatedDerivatives = this.derivativeLinearCombination(new CalculusFieldElement[]{(CalculusFieldElement)time.getField().getOne()});
        }
        return mapper.mapStateAndDerivative((CalculusFieldElement)time, interpolatedState, interpolatedDerivatives);
    }
}

