/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import org.hipparchus.complex.Complex;
import org.hipparchus.ode.ComplexODEState;

public class ComplexODEStateAndDerivative
extends ComplexODEState {
    private static final long serialVersionUID = 20180902L;
    private final Complex[] primaryDerivative;
    private final Complex[][] secondaryDerivative;

    public ComplexODEStateAndDerivative(double time, Complex[] primaryState, Complex[] primaryDerivative) {
        this(time, primaryState, primaryDerivative, null, null);
    }

    public ComplexODEStateAndDerivative(double time, Complex[] primaryState, Complex[] primaryDerivative, Complex[][] secondaryState, Complex[][] secondaryDerivative) {
        super(time, primaryState, secondaryState);
        this.primaryDerivative = (Complex[])primaryDerivative.clone();
        this.secondaryDerivative = this.copy(secondaryDerivative);
    }

    public Complex[] getPrimaryDerivative() {
        return (Complex[])this.primaryDerivative.clone();
    }

    public Complex[] getSecondaryDerivative(int index) {
        return index == 0 ? (Complex[])this.primaryDerivative.clone() : (Complex[])this.secondaryDerivative[index - 1].clone();
    }

    public Complex[] getCompleteDerivative() {
        Complex[] completeDerivative = new Complex[this.getCompleteStateDimension()];
        System.arraycopy(this.primaryDerivative, 0, completeDerivative, 0, this.primaryDerivative.length);
        int offset = this.primaryDerivative.length;
        if (this.secondaryDerivative != null) {
            for (int index = 0; index < this.secondaryDerivative.length; ++index) {
                System.arraycopy(this.secondaryDerivative[index], 0, completeDerivative, offset, this.secondaryDerivative[index].length);
                offset += this.secondaryDerivative[index].length;
            }
        }
        return completeDerivative;
    }
}

