/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketedUnivariateSolver;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.EventHandlerConfiguration;
import org.hipparchus.ode.events.EventState;
import org.hipparchus.ode.events.ODEEventHandler;
import org.hipparchus.ode.sampling.AbstractODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStepHandler;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Incrementor;

public abstract class AbstractIntegrator
implements ODEIntegrator {
    private static final double DEFAULT_RELATIVE_ACCURACY = 0.0;
    private static final double DEFAULT_FUNCTION_VALUE_ACCURACY = 0.0;
    private Collection<ODEStepHandler> stepHandlers;
    private ODEStateAndDerivative stepStart;
    private double stepSize;
    private boolean isLastStep;
    private boolean resetOccurred;
    private Collection<EventState> eventsStates;
    private boolean statesInitialized;
    private final String name;
    private Incrementor evaluations;
    private transient ExpandableODE equations;

    protected AbstractIntegrator(String name) {
        this.name = name;
        this.stepHandlers = new ArrayList<ODEStepHandler>();
        this.stepStart = null;
        this.stepSize = Double.NaN;
        this.eventsStates = new ArrayList<EventState>();
        this.statesInitialized = false;
        this.evaluations = new Incrementor();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addStepHandler(ODEStepHandler handler) {
        this.stepHandlers.add(handler);
    }

    @Override
    public Collection<ODEStepHandler> getStepHandlers() {
        return Collections.unmodifiableCollection(this.stepHandlers);
    }

    @Override
    public void clearStepHandlers() {
        this.stepHandlers.clear();
    }

    @Override
    public void addEventHandler(ODEEventHandler handler, double maxCheckInterval, double convergence, int maxIterationCount) {
        this.addEventHandler(handler, maxCheckInterval, convergence, maxIterationCount, (BracketedUnivariateSolver<UnivariateFunction>)new BracketingNthOrderBrentSolver(0.0, convergence, 0.0, 5));
    }

    @Override
    public void addEventHandler(ODEEventHandler handler, double maxCheckInterval, double convergence, int maxIterationCount, BracketedUnivariateSolver<UnivariateFunction> solver) {
        this.eventsStates.add(new EventState(handler, maxCheckInterval, convergence, maxIterationCount, solver));
    }

    @Override
    public Collection<ODEEventHandler> getEventHandlers() {
        ArrayList<ODEEventHandler> list = new ArrayList<ODEEventHandler>(this.eventsStates.size());
        for (EventState state : this.eventsStates) {
            list.add(state.getEventHandler());
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public Collection<EventHandlerConfiguration> getEventHandlersConfigurations() {
        return Collections.unmodifiableCollection(this.eventsStates);
    }

    @Override
    public void clearEventHandlers() {
        this.eventsStates.clear();
    }

    @Override
    public double getCurrentSignedStepsize() {
        return this.stepSize;
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.evaluations = this.evaluations.withMaximalCount(maxEvaluations < 0 ? Integer.MAX_VALUE : maxEvaluations);
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    protected ODEStateAndDerivative initIntegration(ExpandableODE eqn, ODEState s0, double t) {
        this.equations = eqn;
        this.evaluations = this.evaluations.withCount(0);
        eqn.init(s0, t);
        double t0 = s0.getTime();
        double[] y0 = s0.getCompleteState();
        double[] y0Dot = this.computeDerivatives(t0, y0);
        ODEStateAndDerivative s0WithDerivatives = eqn.getMapper().mapStateAndDerivative(t0, y0, y0Dot);
        for (EventState state : this.eventsStates) {
            state.getEventHandler().init(s0WithDerivatives, t);
        }
        for (ODEStepHandler handler : this.stepHandlers) {
            handler.init(s0WithDerivatives, t);
        }
        this.setStateInitialized(false);
        return s0WithDerivatives;
    }

    protected ExpandableODE getEquations() {
        return this.equations;
    }

    protected Incrementor getEvaluationsCounter() {
        return this.evaluations;
    }

    public double[] computeDerivatives(double t, double[] y) throws MathIllegalArgumentException, MathIllegalStateException, NullPointerException {
        this.evaluations.increment();
        return this.equations.computeDerivatives(t, y);
    }

    protected void setStateInitialized(boolean stateInitialized) {
        this.statesInitialized = stateInitialized;
    }

    protected ODEStateAndDerivative acceptStep(AbstractODEStateInterpolator interpolator, double tEnd) throws MathIllegalArgumentException, MathIllegalStateException {
        ODEStateAndDerivative previousState = interpolator.getGlobalPreviousState();
        ODEStateAndDerivative currentState = interpolator.getGlobalCurrentState();
        AbstractODEStateInterpolator restricted = interpolator;
        if (!this.statesInitialized) {
            for (EventState state : this.eventsStates) {
                state.reinitializeBegin(interpolator);
            }
            this.statesInitialized = true;
        }
        final int orderingSign = interpolator.isForward() ? 1 : -1;
        PriorityQueue<EventState> occurringEvents = new PriorityQueue<EventState>(new Comparator<EventState>(){

            @Override
            public int compare(EventState es0, EventState es1) {
                return orderingSign * Double.compare(es0.getEventTime(), es1.getEventTime());
            }
        });
        this.resetOccurred = false;
        boolean doneWithStep = false;
        block1: do {
            occurringEvents.clear();
            for (EventState state : this.eventsStates) {
                if (!state.evaluateStep(restricted)) continue;
                occurringEvents.add(state);
            }
            block3: while (true) {
                if (!occurringEvents.isEmpty()) {
                    EventState currentEvent = (EventState)occurringEvents.poll();
                    ODEStateAndDerivative eventState = restricted.getInterpolatedState(currentEvent.getEventTime());
                    restricted = restricted.restrictStep(previousState, eventState);
                    for (EventState state : this.eventsStates) {
                        if (state == currentEvent || !state.tryAdvance(eventState, interpolator)) continue;
                        occurringEvents.remove(state);
                        occurringEvents.add(state);
                        occurringEvents.add(currentEvent);
                        continue block3;
                    }
                    for (ODEStepHandler handler : this.stepHandlers) {
                        handler.handleStep(restricted);
                    }
                    EventState.EventOccurrence occurrence = currentEvent.doEvent(eventState);
                    Action action = occurrence.getAction();
                    boolean bl = this.isLastStep = action == Action.STOP;
                    if (this.isLastStep) {
                        ODEStateAndDerivative savedState = eventState;
                        eventState = interpolator.getInterpolatedState(occurrence.getStopTime());
                        restricted = interpolator.restrictStep(savedState, eventState);
                        for (ODEStepHandler handler : this.stepHandlers) {
                            handler.handleStep(restricted);
                            handler.finish(restricted.getCurrentState());
                        }
                    }
                    if (this.isLastStep) {
                        return eventState;
                    }
                    if (action == Action.RESET_DERIVATIVES || action == Action.RESET_STATE) {
                        ODEState newState = occurrence.getNewState();
                        double[] y = newState.getCompleteState();
                        double[] yDot = this.computeDerivatives(newState.getTime(), y);
                        this.resetOccurred = true;
                        return this.equations.getMapper().mapStateAndDerivative(newState.getTime(), y, yDot);
                    }
                    previousState = eventState;
                    restricted = restricted.restrictStep(eventState, currentState);
                    if (action == Action.RESET_EVENTS) continue block1;
                    if (!currentEvent.evaluateStep(restricted)) continue;
                    occurringEvents.add(currentEvent);
                    continue;
                }
                for (EventState state : this.eventsStates) {
                    if (!state.tryAdvance(currentState, interpolator)) continue;
                    occurringEvents.add(state);
                }
                if (occurringEvents.isEmpty()) break;
            }
            doneWithStep = true;
        } while (!doneWithStep);
        this.isLastStep = this.isLastStep || FastMath.abs((double)(currentState.getTime() - tEnd)) <= FastMath.ulp((double)tEnd);
        for (ODEStepHandler handler : this.stepHandlers) {
            handler.handleStep(restricted);
            if (!this.isLastStep) continue;
            handler.finish(restricted.getCurrentState());
        }
        return currentState;
    }

    protected void sanityChecks(ODEState initialState, double t) throws MathIllegalArgumentException {
        double threshold = 1000.0 * FastMath.ulp((double)FastMath.max((double)FastMath.abs((double)initialState.getTime()), (double)FastMath.abs((double)t)));
        double dt = FastMath.abs((double)(initialState.getTime() - t));
        if (dt <= threshold) {
            throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.TOO_SMALL_INTEGRATION_INTERVAL, new Object[]{dt, threshold, false});
        }
    }

    protected boolean resetOccurred() {
        return this.resetOccurred;
    }

    protected void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    protected double getStepSize() {
        return this.stepSize;
    }

    protected void setStepStart(ODEStateAndDerivative stepStart) {
        this.stepStart = stepStart;
    }

    @Override
    public ODEStateAndDerivative getStepStart() {
        return this.stepStart;
    }

    protected void setIsLastStep(boolean isLastStep) {
        this.isLastStep = isLastStep;
    }

    protected boolean isLastStep() {
        return this.isLastStep;
    }
}

