/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.solvers.BracketedRealFieldUnivariateSolver;
import org.hipparchus.analysis.solvers.FieldBracketingNthOrderBrentSolver;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEIntegrator;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.FieldEventHandlerConfiguration;
import org.hipparchus.ode.events.FieldEventState;
import org.hipparchus.ode.events.FieldODEEventHandler;
import org.hipparchus.ode.sampling.AbstractFieldODEStateInterpolator;
import org.hipparchus.ode.sampling.FieldODEStepHandler;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Incrementor;

public abstract class AbstractFieldIntegrator<T extends CalculusFieldElement<T>>
implements FieldODEIntegrator<T> {
    private static final double DEFAULT_RELATIVE_ACCURACY = 0.0;
    private static final double DEFAULT_FUNCTION_VALUE_ACCURACY = 0.0;
    private Collection<FieldODEStepHandler<T>> stepHandlers;
    private FieldODEStateAndDerivative<T> stepStart;
    private T stepSize;
    private boolean isLastStep;
    private boolean resetOccurred;
    private final Field<T> field;
    private Collection<FieldEventState<T>> eventsStates;
    private boolean statesInitialized;
    private final String name;
    private Incrementor evaluations;
    private transient FieldExpandableODE<T> equations;

    protected AbstractFieldIntegrator(Field<T> field, String name) {
        this.field = field;
        this.name = name;
        this.stepHandlers = new ArrayList<FieldODEStepHandler<T>>();
        this.stepStart = null;
        this.stepSize = null;
        this.eventsStates = new ArrayList<FieldEventState<T>>();
        this.statesInitialized = false;
        this.evaluations = new Incrementor();
    }

    public Field<T> getField() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addStepHandler(FieldODEStepHandler<T> handler) {
        this.stepHandlers.add(handler);
    }

    @Override
    public Collection<FieldODEStepHandler<T>> getStepHandlers() {
        return Collections.unmodifiableCollection(this.stepHandlers);
    }

    @Override
    public void clearStepHandlers() {
        this.stepHandlers.clear();
    }

    @Override
    public void addEventHandler(FieldODEEventHandler<T> handler, double maxCheckInterval, double convergence, int maxIterationCount) {
        this.addEventHandler(handler, maxCheckInterval, convergence, maxIterationCount, (BracketedRealFieldUnivariateSolver<T>)new FieldBracketingNthOrderBrentSolver((CalculusFieldElement)((CalculusFieldElement)this.field.getZero()).add(0.0), (CalculusFieldElement)((CalculusFieldElement)this.field.getZero()).add(convergence), (CalculusFieldElement)((CalculusFieldElement)this.field.getZero()).add(0.0), 5));
    }

    @Override
    public void addEventHandler(FieldODEEventHandler<T> handler, double maxCheckInterval, double convergence, int maxIterationCount, BracketedRealFieldUnivariateSolver<T> solver) {
        this.eventsStates.add(new FieldEventState<CalculusFieldElement>(handler, maxCheckInterval, (CalculusFieldElement)((CalculusFieldElement)this.field.getZero()).newInstance(convergence), maxIterationCount, solver));
    }

    @Override
    public Collection<FieldODEEventHandler<T>> getEventHandlers() {
        ArrayList<FieldODEEventHandler<T>> list = new ArrayList<FieldODEEventHandler<T>>(this.eventsStates.size());
        for (FieldEventState<T> state : this.eventsStates) {
            list.add(state.getEventHandler());
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public Collection<FieldEventHandlerConfiguration<T>> getEventHandlersConfigurations() {
        return Collections.unmodifiableCollection(this.eventsStates);
    }

    @Override
    public void clearEventHandlers() {
        this.eventsStates.clear();
    }

    @Override
    public T getCurrentSignedStepsize() {
        return this.stepSize;
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.evaluations = this.evaluations.withMaximalCount(maxEvaluations < 0 ? Integer.MAX_VALUE : maxEvaluations);
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    protected FieldODEStateAndDerivative<T> initIntegration(FieldExpandableODE<T> eqn, FieldODEState<T> s0, T t) {
        this.equations = eqn;
        this.evaluations = this.evaluations.withCount(0);
        eqn.init(s0, t);
        T t0 = s0.getTime();
        CalculusFieldElement[] y0 = s0.getCompleteState();
        CalculusFieldElement[] y0Dot = this.computeDerivatives((CalculusFieldElement)t0, y0);
        FieldODEStateAndDerivative s0WithDerivatives = eqn.getMapper().mapStateAndDerivative((CalculusFieldElement)t0, y0, y0Dot);
        for (FieldEventState<T> fieldEventState : this.eventsStates) {
            fieldEventState.getEventHandler().init(s0WithDerivatives, t);
        }
        for (FieldODEStepHandler fieldODEStepHandler : this.stepHandlers) {
            fieldODEStepHandler.init(s0WithDerivatives, t);
        }
        this.setStateInitialized(false);
        return s0WithDerivatives;
    }

    protected FieldExpandableODE<T> getEquations() {
        return this.equations;
    }

    protected Incrementor getEvaluationsCounter() {
        return this.evaluations;
    }

    public T[] computeDerivatives(T t, T[] y) throws MathIllegalArgumentException, MathIllegalStateException, NullPointerException {
        this.evaluations.increment();
        return this.equations.computeDerivatives((CalculusFieldElement)t, (CalculusFieldElement[])y);
    }

    protected void setStateInitialized(boolean stateInitialized) {
        this.statesInitialized = stateInitialized;
    }

    /*
     * WARNING - void declaration
     */
    protected FieldODEStateAndDerivative<T> acceptStep(AbstractFieldODEStateInterpolator<T> interpolator, T tEnd) throws MathIllegalArgumentException, MathIllegalStateException {
        FieldODEStateAndDerivative<T> previousState = interpolator.getGlobalPreviousState();
        FieldODEStateAndDerivative<T> currentState = interpolator.getGlobalCurrentState();
        AbstractFieldODEStateInterpolator<T> restricted = interpolator;
        if (!this.statesInitialized) {
            for (FieldEventState<T> state : this.eventsStates) {
                state.reinitializeBegin(interpolator);
            }
            this.statesInitialized = true;
        }
        final int orderingSign = interpolator.isForward() ? 1 : -1;
        PriorityQueue<FieldEventState<T>> occurringEvents = new PriorityQueue<FieldEventState<T>>(new Comparator<FieldEventState<T>>(){

            @Override
            public int compare(FieldEventState<T> es0, FieldEventState<T> es1) {
                return orderingSign * Double.compare(es0.getEventTime().getReal(), es1.getEventTime().getReal());
            }
        });
        this.resetOccurred = false;
        boolean doneWithStep = false;
        block1: do {
            occurringEvents.clear();
            for (FieldEventState<T> fieldEventState : this.eventsStates) {
                if (!fieldEventState.evaluateStep(restricted)) continue;
                occurringEvents.add(fieldEventState);
            }
            block3: while (true) {
                if (!occurringEvents.isEmpty()) {
                    void var10_15;
                    FieldEventState currentEvent = (FieldEventState)occurringEvents.poll();
                    FieldODEStateAndDerivative<T> fieldODEStateAndDerivative = restricted.getInterpolatedState(currentEvent.getEventTime());
                    restricted = restricted.restrictStep(previousState, fieldODEStateAndDerivative);
                    for (FieldEventState<T> fieldEventState : this.eventsStates) {
                        if (fieldEventState == currentEvent || !fieldEventState.tryAdvance(fieldODEStateAndDerivative, interpolator)) continue;
                        occurringEvents.remove(fieldEventState);
                        occurringEvents.add(fieldEventState);
                        occurringEvents.add(currentEvent);
                        continue block3;
                    }
                    for (FieldODEStepHandler fieldODEStepHandler : this.stepHandlers) {
                        fieldODEStepHandler.handleStep(restricted);
                    }
                    FieldEventState.EventOccurrence<T> occurrence = currentEvent.doEvent(fieldODEStateAndDerivative);
                    Action action = occurrence.getAction();
                    boolean bl = this.isLastStep = action == Action.STOP;
                    if (this.isLastStep) {
                        FieldODEStateAndDerivative<T> savedState = fieldODEStateAndDerivative;
                        FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2 = interpolator.getInterpolatedState(occurrence.getStopTime());
                        restricted = interpolator.restrictStep(savedState, fieldODEStateAndDerivative2);
                        for (FieldODEStepHandler<T> handler : this.stepHandlers) {
                            handler.handleStep(restricted);
                            handler.finish(restricted.getCurrentState());
                        }
                    }
                    if (this.isLastStep) {
                        return var10_15;
                    }
                    if (action == Action.RESET_DERIVATIVES || action == Action.RESET_STATE) {
                        FieldODEState<T> newState = occurrence.getNewState();
                        CalculusFieldElement[] y = newState.getCompleteState();
                        CalculusFieldElement[] yDot = this.computeDerivatives((CalculusFieldElement)newState.getTime(), y);
                        this.resetOccurred = true;
                        return this.equations.getMapper().mapStateAndDerivative((CalculusFieldElement)newState.getTime(), y, yDot);
                    }
                    previousState = var10_15;
                    restricted = restricted.restrictStep((FieldODEStateAndDerivative<T>)var10_15, currentState);
                    if (action == Action.RESET_EVENTS) continue block1;
                    if (!currentEvent.evaluateStep(restricted)) continue;
                    occurringEvents.add(currentEvent);
                    continue;
                }
                for (FieldEventState<T> fieldEventState : this.eventsStates) {
                    if (!fieldEventState.tryAdvance(currentState, interpolator)) continue;
                    occurringEvents.add(fieldEventState);
                }
                if (occurringEvents.isEmpty()) break;
            }
            doneWithStep = true;
        } while (!doneWithStep);
        this.isLastStep = this.isLastStep || ((CalculusFieldElement)currentState.getTime().subtract(tEnd)).norm() <= FastMath.ulp((double)tEnd.getReal());
        for (FieldODEStepHandler fieldODEStepHandler : this.stepHandlers) {
            fieldODEStepHandler.handleStep(restricted);
            if (!this.isLastStep) continue;
            fieldODEStepHandler.finish(restricted.getCurrentState());
        }
        return currentState;
    }

    protected void sanityChecks(FieldODEState<T> initialState, T t) throws MathIllegalArgumentException {
        double threshold = 1000.0 * FastMath.ulp((double)FastMath.max((double)FastMath.abs((double)initialState.getTime().getReal()), (double)FastMath.abs((double)t.getReal())));
        double dt = ((CalculusFieldElement)initialState.getTime().subtract(t)).norm();
        if (dt <= threshold) {
            throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.TOO_SMALL_INTEGRATION_INTERVAL, new Object[]{dt, threshold, false});
        }
    }

    protected boolean resetOccurred() {
        return this.resetOccurred;
    }

    protected void setStepSize(T stepSize) {
        this.stepSize = stepSize;
    }

    protected T getStepSize() {
        return this.stepSize;
    }

    protected void setStepStart(FieldODEStateAndDerivative<T> stepStart) {
        this.stepStart = stepStart;
    }

    @Override
    public FieldODEStateAndDerivative<T> getStepStart() {
        return this.stepStart;
    }

    protected void setIsLastStep(boolean isLastStep) {
        this.isLastStep = isLastStep;
    }

    protected boolean isLastStep() {
        return this.isLastStep;
    }
}

