/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.distribution.continuous.ChiSquaredDistribution;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.LocalizedStatFormats;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class ChiSquareTest {
    public double chiSquare(double[] expected, long[] observed) throws MathIllegalArgumentException {
        if (expected.length < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{expected.length, 2});
        }
        MathUtils.checkDimension((int)expected.length, (int)observed.length);
        MathArrays.checkPositive((double[])expected);
        MathArrays.checkNonNegative((long[])observed);
        double sumExpected = 0.0;
        double sumObserved = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            sumExpected += expected[i];
            sumObserved += (double)observed[i];
        }
        double ratio = 1.0;
        boolean rescale = false;
        if (FastMath.abs((double)(sumExpected - sumObserved)) > 1.0E-5) {
            ratio = sumObserved / sumExpected;
            rescale = true;
        }
        double sumSq = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            double dev;
            if (rescale) {
                dev = (double)observed[i] - ratio * expected[i];
                sumSq += dev * dev / (ratio * expected[i]);
                continue;
            }
            dev = (double)observed[i] - expected[i];
            sumSq += dev * dev / expected[i];
        }
        return sumSq;
    }

    public double chiSquareTest(double[] expected, long[] observed) throws MathIllegalArgumentException, MathIllegalStateException {
        ChiSquaredDistribution distribution = new ChiSquaredDistribution((double)expected.length - 1.0);
        return 1.0 - distribution.cumulativeProbability(this.chiSquare(expected, observed));
    }

    public boolean chiSquareTest(double[] expected, long[] observed, double alpha) throws MathIllegalArgumentException, MathIllegalStateException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new MathIllegalArgumentException((Localizable)LocalizedStatFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, new Object[]{alpha, 0, 0.5});
        }
        return this.chiSquareTest(expected, observed) < alpha;
    }

    public double chiSquare(long[][] counts) throws MathIllegalArgumentException, NullArgumentException {
        this.checkArray(counts);
        int nRows = counts.length;
        int nCols = counts[0].length;
        double[] rowSum = new double[nRows];
        double[] colSum = new double[nCols];
        double total = 0.0;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                int n = row;
                rowSum[n] = rowSum[n] + (double)counts[row][col];
                int n2 = col;
                colSum[n2] = colSum[n2] + (double)counts[row][col];
                total += (double)counts[row][col];
            }
        }
        double sumSq = 0.0;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                double expected = rowSum[row] * colSum[col] / total;
                sumSq += ((double)counts[row][col] - expected) * ((double)counts[row][col] - expected) / expected;
            }
        }
        return sumSq;
    }

    public double chiSquareTest(long[][] counts) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        this.checkArray(counts);
        double df = ((double)counts.length - 1.0) * ((double)counts[0].length - 1.0);
        ChiSquaredDistribution distribution = new ChiSquaredDistribution(df);
        return 1.0 - distribution.cumulativeProbability(this.chiSquare(counts));
    }

    public boolean chiSquareTest(long[][] counts, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new MathIllegalArgumentException((Localizable)LocalizedStatFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, new Object[]{alpha, 0, 0.5});
        }
        return this.chiSquareTest(counts) < alpha;
    }

    public double chiSquareDataSetsComparison(long[] observed1, long[] observed2) throws MathIllegalArgumentException {
        boolean unequalCounts;
        if (observed1.length < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{observed1.length, 2});
        }
        MathUtils.checkDimension((int)observed1.length, (int)observed2.length);
        MathArrays.checkNonNegative((long[])observed1);
        MathArrays.checkNonNegative((long[])observed2);
        long countSum1 = 0L;
        long countSum2 = 0L;
        for (int i = 0; i < observed1.length; ++i) {
            countSum1 += observed1[i];
            countSum2 += observed2[i];
        }
        if (countSum1 == 0L || countSum2 == 0L) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.ZERO_NOT_ALLOWED, new Object[0]);
        }
        double weight = 0.0;
        boolean bl = unequalCounts = countSum1 != countSum2;
        if (unequalCounts) {
            weight = FastMath.sqrt((double)((double)countSum1 / (double)countSum2));
        }
        double sumSq = 0.0;
        for (int i = 0; i < observed1.length; ++i) {
            if (observed1[i] == 0L && observed2[i] == 0L) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.OBSERVED_COUNTS_BOTTH_ZERO_FOR_ENTRY, new Object[]{i});
            }
            double obs1 = observed1[i];
            double obs2 = observed2[i];
            double dev = unequalCounts ? obs1 / weight - obs2 * weight : obs1 - obs2;
            sumSq += dev * dev / (obs1 + obs2);
        }
        return sumSq;
    }

    public double chiSquareTestDataSetsComparison(long[] observed1, long[] observed2) throws MathIllegalArgumentException, MathIllegalStateException {
        ChiSquaredDistribution distribution = new ChiSquaredDistribution((double)observed1.length - 1.0);
        return 1.0 - distribution.cumulativeProbability(this.chiSquareDataSetsComparison(observed1, observed2));
    }

    public boolean chiSquareTestDataSetsComparison(long[] observed1, long[] observed2, double alpha) throws MathIllegalArgumentException, MathIllegalStateException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new MathIllegalArgumentException((Localizable)LocalizedStatFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, new Object[]{alpha, 0, 0.5});
        }
        return this.chiSquareTestDataSetsComparison(observed1, observed2) < alpha;
    }

    private void checkArray(long[][] in) throws MathIllegalArgumentException, NullArgumentException {
        if (in.length < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{in.length, 2});
        }
        if (in[0].length < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{in[0].length, 2});
        }
        MathArrays.checkRectangular((long[][])in);
        MathArrays.checkNonNegative((long[][])in);
    }
}

