/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.complex.Complex;
import org.hipparchus.special.elliptic.jacobi.CopolarN;
import org.hipparchus.special.elliptic.jacobi.JacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.JacobiTheta;
import org.hipparchus.special.elliptic.jacobi.Theta;
import org.hipparchus.special.elliptic.legendre.LegendreEllipticIntegral;

class BoundedParameter
extends JacobiElliptic {
    private final JacobiTheta jacobiTheta;
    private final Theta t0;
    private final double scaling;

    BoundedParameter(double m) {
        super(m);
        double q = LegendreEllipticIntegral.nome(m);
        this.jacobiTheta = new JacobiTheta(q);
        this.t0 = this.jacobiTheta.values(Complex.ZERO);
        this.scaling = 1.5707963267948966 / LegendreEllipticIntegral.bigK(m);
    }

    @Override
    public CopolarN valuesN(double u) {
        Theta tZ = this.jacobiTheta.values(new Complex(u * this.scaling));
        double sn = this.t0.theta3().multiply(tZ.theta1()).divide(this.t0.theta2().multiply(tZ.theta4())).getRealPart();
        double cn = this.t0.theta4().multiply(tZ.theta2()).divide(this.t0.theta2().multiply(tZ.theta4())).getRealPart();
        double dn = this.t0.theta4().multiply(tZ.theta3()).divide(this.t0.theta3().multiply(tZ.theta4())).getRealPart();
        return new CopolarN(sn, cn, dn);
    }
}

