/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.util.function.Predicate;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.ArrayFieldVector;
import org.hipparchus.linear.FieldDecompositionSolver;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class FieldLUDecomposition<T extends FieldElement<T>> {
    private final Field<T> field;
    private T[][] lu;
    private int[] pivot;
    private boolean even;
    private boolean singular;
    private FieldMatrix<T> cachedL;
    private FieldMatrix<T> cachedU;
    private FieldMatrix<T> cachedP;

    public FieldLUDecomposition(FieldMatrix<T> matrix) {
        this(matrix, e -> e.isZero());
    }

    public FieldLUDecomposition(FieldMatrix<T> matrix, Predicate<T> zeroChecker) {
        this(matrix, zeroChecker, true);
    }

    public FieldLUDecomposition(FieldMatrix<T> matrix, Predicate<T> zeroChecker, boolean numericPermutationChoice) {
        if (!matrix.isSquare()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_MATRIX, matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m = matrix.getColumnDimension();
        this.field = matrix.getField();
        this.lu = matrix.getData();
        this.pivot = new int[m];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        for (int row = 0; row < m; ++row) {
            this.pivot[row] = row;
        }
        this.even = true;
        this.singular = false;
        for (int col = 0; col < m; ++col) {
            for (int row = 0; row < col; ++row) {
                T[] luRow = this.lu[row];
                T sum = luRow[col];
                for (int i = 0; i < row; ++i) {
                    sum = sum.subtract(luRow[i].multiply(this.lu[i][col]));
                }
                luRow[col] = sum;
            }
            int max = col;
            if (numericPermutationChoice) {
                double largest = Double.NEGATIVE_INFINITY;
                for (int row = col; row < m; ++row) {
                    T[] luRow = this.lu[row];
                    T sum = luRow[col];
                    for (int i = 0; i < col; ++i) {
                        sum = sum.subtract(luRow[i].multiply(this.lu[i][col]));
                    }
                    luRow[col] = sum;
                    double absSum = FastMath.abs(sum.getReal());
                    if (!(absSum > largest)) continue;
                    largest = absSum;
                    max = row;
                }
            } else {
                int nonZero = col;
                for (int row = col; row < m; ++row) {
                    T[] luRow = this.lu[row];
                    T sum = luRow[col];
                    for (int i = 0; i < col; ++i) {
                        sum = sum.subtract(luRow[i].multiply(this.lu[i][col]));
                    }
                    luRow[col] = sum;
                    if (!zeroChecker.test(this.lu[nonZero][col])) continue;
                    ++nonZero;
                }
                max = FastMath.min(m - 1, nonZero);
            }
            if (zeroChecker.test(this.lu[max][col])) {
                this.singular = true;
                return;
            }
            if (max != col) {
                T[] luMax = this.lu[max];
                T[] luCol = this.lu[col];
                for (int i = 0; i < m; ++i) {
                    T tmp = luMax[i];
                    luMax[i] = luCol[i];
                    luCol[i] = tmp;
                }
                int temp = this.pivot[max];
                this.pivot[max] = this.pivot[col];
                this.pivot[col] = temp;
                this.even = !this.even;
            }
            T luDiag = this.lu[col][col];
            for (int row = col + 1; row < m; ++row) {
                this.lu[row][col] = this.lu[row][col].divide(luDiag);
            }
        }
    }

    public FieldMatrix<T> getL() {
        if (this.cachedL == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedL = new Array2DRowFieldMatrix<T>(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                T[] luI = this.lu[i];
                for (int j = 0; j < i; ++j) {
                    this.cachedL.setEntry(i, j, luI[j]);
                }
                this.cachedL.setEntry(i, i, this.field.getOne());
            }
        }
        return this.cachedL;
    }

    public FieldMatrix<T> getU() {
        if (this.cachedU == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedU = new Array2DRowFieldMatrix<T>(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                T[] luI = this.lu[i];
                for (int j = i; j < m; ++j) {
                    this.cachedU.setEntry(i, j, luI[j]);
                }
            }
        }
        return this.cachedU;
    }

    public FieldMatrix<T> getP() {
        if (this.cachedP == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedP = new Array2DRowFieldMatrix<T>(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                this.cachedP.setEntry(i, this.pivot[i], this.field.getOne());
            }
        }
        return this.cachedP;
    }

    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    public T getDeterminant() {
        if (this.singular) {
            return this.field.getZero();
        }
        int m = this.pivot.length;
        T determinant = this.even ? this.field.getOne() : this.field.getZero().subtract(this.field.getOne());
        for (int i = 0; i < m; ++i) {
            determinant = determinant.multiply(this.lu[i][i]);
        }
        return determinant;
    }

    public FieldDecompositionSolver<T> getSolver() {
        return new Solver();
    }

    private class Solver
    implements FieldDecompositionSolver<T> {
        private Solver() {
        }

        @Override
        public boolean isNonSingular() {
            return !FieldLUDecomposition.this.singular;
        }

        @Override
        public FieldVector<T> solve(FieldVector<T> b) {
            int i;
            FieldElement bpCol;
            int col;
            if (b instanceof ArrayFieldVector) {
                return this.solve((ArrayFieldVector)b);
            }
            int m = FieldLUDecomposition.this.pivot.length;
            if (b.getDimension() != m) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, b.getDimension(), m);
            }
            if (FieldLUDecomposition.this.singular) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
            }
            FieldElement[] bp = MathArrays.buildArray((Field)FieldLUDecomposition.this.field, (int)m);
            for (int row = 0; row < m; ++row) {
                bp[row] = b.getEntry(FieldLUDecomposition.this.pivot[row]);
            }
            for (col = 0; col < m; ++col) {
                bpCol = bp[col];
                for (i = col + 1; i < m; ++i) {
                    bp[i] = bp[i].subtract(bpCol.multiply(FieldLUDecomposition.this.lu[i][col]));
                }
            }
            for (col = m - 1; col >= 0; --col) {
                bp[col] = bp[col].divide(FieldLUDecomposition.this.lu[col][col]);
                bpCol = bp[col];
                for (i = 0; i < col; ++i) {
                    bp[i] = bp[i].subtract(bpCol.multiply(FieldLUDecomposition.this.lu[i][col]));
                }
            }
            return new ArrayFieldVector(FieldLUDecomposition.this.field, bp, false);
        }

        @Override
        public ArrayFieldVector<T> solve(ArrayFieldVector<T> b) {
            int i;
            FieldElement bpCol;
            int col;
            int m = FieldLUDecomposition.this.pivot.length;
            int length = b.getDimension();
            if (length != m) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, length, m);
            }
            if (FieldLUDecomposition.this.singular) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
            }
            FieldElement[] bp = MathArrays.buildArray((Field)FieldLUDecomposition.this.field, (int)m);
            for (int row = 0; row < m; ++row) {
                bp[row] = b.getEntry(FieldLUDecomposition.this.pivot[row]);
            }
            for (col = 0; col < m; ++col) {
                bpCol = bp[col];
                for (i = col + 1; i < m; ++i) {
                    bp[i] = bp[i].subtract(bpCol.multiply(FieldLUDecomposition.this.lu[i][col]));
                }
            }
            for (col = m - 1; col >= 0; --col) {
                bp[col] = bp[col].divide(FieldLUDecomposition.this.lu[col][col]);
                bpCol = bp[col];
                for (i = 0; i < col; ++i) {
                    bp[i] = bp[i].subtract(bpCol.multiply(FieldLUDecomposition.this.lu[i][col]));
                }
            }
            return new ArrayFieldVector(bp, false);
        }

        @Override
        public FieldMatrix<T> solve(FieldMatrix<T> b) {
            FieldElement[] bpCol;
            int col;
            int m = FieldLUDecomposition.this.pivot.length;
            if (b.getRowDimension() != m) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, b.getRowDimension(), m);
            }
            if (FieldLUDecomposition.this.singular) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
            }
            int nColB = b.getColumnDimension();
            FieldElement[][] bp = MathArrays.buildArray((Field)FieldLUDecomposition.this.field, (int)m, (int)nColB);
            for (int row = 0; row < m; ++row) {
                FieldElement[] bpRow = bp[row];
                int pRow = FieldLUDecomposition.this.pivot[row];
                for (int col2 = 0; col2 < nColB; ++col2) {
                    bpRow[col2] = b.getEntry(pRow, col2);
                }
            }
            for (col = 0; col < m; ++col) {
                bpCol = bp[col];
                for (int i = col + 1; i < m; ++i) {
                    FieldElement[] bpI = bp[i];
                    FieldElement luICol = FieldLUDecomposition.this.lu[i][col];
                    for (int j = 0; j < nColB; ++j) {
                        bpI[j] = bpI[j].subtract(bpCol[j].multiply(luICol));
                    }
                }
            }
            for (col = m - 1; col >= 0; --col) {
                bpCol = bp[col];
                FieldElement luDiag = FieldLUDecomposition.this.lu[col][col];
                for (int j = 0; j < nColB; ++j) {
                    bpCol[j] = bpCol[j].divide(luDiag);
                }
                for (int i = 0; i < col; ++i) {
                    FieldElement[] bpI = bp[i];
                    FieldElement luICol = FieldLUDecomposition.this.lu[i][col];
                    for (int j = 0; j < nColB; ++j) {
                        bpI[j] = bpI[j].subtract(bpCol[j].multiply(luICol));
                    }
                }
            }
            return new Array2DRowFieldMatrix(FieldLUDecomposition.this.field, bp, false);
        }

        @Override
        public FieldMatrix<T> getInverse() {
            return this.solve(MatrixUtils.createFieldIdentityMatrix(FieldLUDecomposition.this.field, FieldLUDecomposition.this.pivot.length));
        }

        @Override
        public int getRowDimension() {
            return FieldLUDecomposition.this.lu.length;
        }

        @Override
        public int getColumnDimension() {
            return FieldLUDecomposition.this.lu[0].length;
        }
    }
}

