/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hipparchus.analysis.ParametricUnivariateFunction;
import org.hipparchus.fitting.AbstractCurveFitter;
import org.hipparchus.fitting.PolynomialCurveFitter;
import org.hipparchus.fitting.WeightedObservedPoint;
import org.hipparchus.linear.DiagonalMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresBuilder;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.time.AbsoluteDate;

public class SecularAndHarmonic {
    private final int secularDegree;
    private final double[] pulsations;
    private AbsoluteDate reference;
    private double[] fitted;
    private List<WeightedObservedPoint> observedPoints;
    private double convergenceRMS;
    private int maxIter;

    public SecularAndHarmonic(int secularDegree, double ... pulsations) {
        this.secularDegree = secularDegree;
        this.pulsations = (double[])pulsations.clone();
        this.observedPoints = new ArrayList<WeightedObservedPoint>();
        this.convergenceRMS = 0.0;
        this.maxIter = Integer.MAX_VALUE;
    }

    public void resetFitting(AbsoluteDate date, double ... initialGuess) {
        this.reference = date;
        this.fitted = (double[])initialGuess.clone();
        this.observedPoints.clear();
    }

    public void setConvergenceRMS(double convergenceRMS) {
        this.convergenceRMS = convergenceRMS;
    }

    public void setMaxIter(int maxIter) {
        this.maxIter = maxIter;
    }

    public void addPoint(AbsoluteDate date, double osculatingValue) {
        this.observedPoints.add(new WeightedObservedPoint(1.0, date.durationFrom(this.reference), osculatingValue));
    }

    public AbsoluteDate getReferenceDate() {
        return this.reference;
    }

    public double getHarmonicAmplitude() {
        double amplitude = 0.0;
        for (int i = 0; i < this.pulsations.length; ++i) {
            amplitude += FastMath.hypot((double)this.fitted[this.secularDegree + 2 * i + 1], (double)this.fitted[this.secularDegree + 2 * i + 2]);
        }
        return amplitude;
    }

    public void fit() {
        AbstractCurveFitter fitter = new AbstractCurveFitter(){

            protected LeastSquaresProblem getProblem(Collection<WeightedObservedPoint> observations) {
                int len = observations.size();
                double[] target = new double[len];
                double[] weights = new double[len];
                int i = 0;
                for (WeightedObservedPoint obs : observations) {
                    target[i] = obs.getY();
                    weights[i] = obs.getWeight();
                    ++i;
                }
                AbstractCurveFitter.TheoreticalValuesFunction model = new AbstractCurveFitter.TheoreticalValuesFunction((ParametricUnivariateFunction)new LocalParametricFunction(), observations);
                return new LeastSquaresBuilder().maxEvaluations(Integer.MAX_VALUE).maxIterations(SecularAndHarmonic.this.maxIter).checker((iteration, previous, current) -> current.getRMS() <= SecularAndHarmonic.this.convergenceRMS).start(SecularAndHarmonic.this.fitted).target(target).weight((RealMatrix)new DiagonalMatrix(weights)).model(model.getModelFunction(), model.getModelFunctionJacobian()).build();
            }
        };
        this.fitted = fitter.fit(this.observedPoints);
    }

    public double[] getFittedParameters() {
        return (double[])this.fitted.clone();
    }

    public double osculatingValue(AbsoluteDate date) {
        return this.truncatedValue(this.secularDegree, this.pulsations.length, date.durationFrom(this.reference), this.fitted);
    }

    public double osculatingDerivative(AbsoluteDate date) {
        return this.truncatedDerivative(this.secularDegree, this.pulsations.length, date.durationFrom(this.reference), this.fitted);
    }

    public double osculatingSecondDerivative(AbsoluteDate date) {
        return this.truncatedSecondDerivative(this.secularDegree, this.pulsations.length, date.durationFrom(this.reference), this.fitted);
    }

    public double meanValue(AbsoluteDate date, int degree, int harmonics) {
        return this.truncatedValue(degree, harmonics, date.durationFrom(this.reference), this.fitted);
    }

    public double meanDerivative(AbsoluteDate date, int degree, int harmonics) {
        return this.truncatedDerivative(degree, harmonics, date.durationFrom(this.reference), this.fitted);
    }

    public double[] approximateAsPolynomialOnly(int combinedDegree, AbsoluteDate combinedReference, int meanDegree, int meanHarmonics, AbsoluteDate start, AbsoluteDate end, double step) {
        ArrayList<WeightedObservedPoint> points = new ArrayList<WeightedObservedPoint>();
        AbsoluteDate date = start;
        while (date.compareTo(end) < 0) {
            points.add(new WeightedObservedPoint(1.0, date.durationFrom(combinedReference), this.meanValue(date, meanDegree, meanHarmonics)));
            date = date.shiftedBy(step);
        }
        return PolynomialCurveFitter.create((int)combinedDegree).fit(points);
    }

    public double meanSecondDerivative(AbsoluteDate date, int degree, int harmonics) {
        return this.truncatedSecondDerivative(degree, harmonics, date.durationFrom(this.reference), this.fitted);
    }

    private double truncatedValue(int degree, int harmonics, double time, double ... parameters) {
        int i;
        double value = 0.0;
        double tN = 1.0;
        for (i = 0; i <= degree; ++i) {
            value += parameters[i] * tN;
            tN *= time;
        }
        for (i = 0; i < harmonics; ++i) {
            SinCos sc = FastMath.sinCos((double)(this.pulsations[i] * time));
            value += parameters[this.secularDegree + 2 * i + 1] * sc.cos() + parameters[this.secularDegree + 2 * i + 2] * sc.sin();
        }
        return value;
    }

    private double truncatedDerivative(int degree, int harmonics, double time, double ... parameters) {
        int i;
        double derivative = 0.0;
        double tN = 1.0;
        for (i = 1; i <= degree; ++i) {
            derivative += (double)i * parameters[i] * tN;
            tN *= time;
        }
        for (i = 0; i < harmonics; ++i) {
            SinCos sc = FastMath.sinCos((double)(this.pulsations[i] * time));
            derivative += this.pulsations[i] * (-parameters[this.secularDegree + 2 * i + 1] * sc.sin() + parameters[this.secularDegree + 2 * i + 2] * sc.cos());
        }
        return derivative;
    }

    private double truncatedSecondDerivative(int degree, int harmonics, double time, double ... parameters) {
        int i;
        double d2 = 0.0;
        double tN = 1.0;
        for (i = 2; i <= degree; ++i) {
            d2 += (double)((i - 1) * i) * parameters[i] * tN;
            tN *= time;
        }
        for (i = 0; i < harmonics; ++i) {
            SinCos sc = FastMath.sinCos((double)(this.pulsations[i] * time));
            d2 += -this.pulsations[i] * this.pulsations[i] * (parameters[this.secularDegree + 2 * i + 1] * sc.cos() + parameters[this.secularDegree + 2 * i + 2] * sc.sin());
        }
        return d2;
    }

    private class LocalParametricFunction
    implements ParametricUnivariateFunction {
        private LocalParametricFunction() {
        }

        public double value(double x, double ... parameters) {
            return SecularAndHarmonic.this.truncatedValue(SecularAndHarmonic.this.secularDegree, SecularAndHarmonic.this.pulsations.length, x, parameters);
        }

        public double[] gradient(double x, double ... parameters) {
            int i;
            double[] gradient = new double[SecularAndHarmonic.this.secularDegree + 1 + 2 * SecularAndHarmonic.this.pulsations.length];
            double xN = 1.0;
            for (i = 0; i <= SecularAndHarmonic.this.secularDegree; ++i) {
                gradient[i] = xN;
                xN *= x;
            }
            for (i = 0; i < SecularAndHarmonic.this.pulsations.length; ++i) {
                SinCos sc = FastMath.sinCos((double)(SecularAndHarmonic.this.pulsations[i] * x));
                gradient[((SecularAndHarmonic)SecularAndHarmonic.this).secularDegree + 2 * i + 1] = sc.cos();
                gradient[((SecularAndHarmonic)SecularAndHarmonic.this).secularDegree + 2 * i + 2] = sc.sin();
            }
            return gradient;
        }
    }
}

