/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.util.FastMath;
import org.orekit.propagation.semianalytical.dsst.forces.ForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;

public class AbstractGaussianContributionContext
extends ForceModelContext {
    protected double ton2a;
    protected double ooA;
    protected double ooAB;
    protected double co2AB;
    protected double ooBpo;
    protected double ooMu;
    private final double A;
    private final double n;
    private double mu;

    AbstractGaussianContributionContext(AuxiliaryElements auxiliaryElements, double[] parameters) {
        super(auxiliaryElements);
        this.mu = parameters[parameters.length - 1];
        double absA = FastMath.abs((double)auxiliaryElements.getSma());
        this.n = FastMath.sqrt((double)(this.mu / absA)) / absA;
        this.A = FastMath.sqrt((double)(this.mu * auxiliaryElements.getSma()));
        this.ooA = 1.0 / this.A;
        this.ooAB = this.ooA / auxiliaryElements.getB();
        this.co2AB = auxiliaryElements.getC() * this.ooAB / 2.0;
        this.ooBpo = 1.0 / (1.0 + auxiliaryElements.getB());
        this.ton2a = 2.0 / (this.n * this.n * auxiliaryElements.getSma());
        this.ooMu = 1.0 / this.mu;
    }

    public double getMu() {
        return this.mu;
    }

    public double getOOA() {
        return this.ooA;
    }

    public double getOOAB() {
        return this.ooAB;
    }

    public double getCo2AB() {
        return this.co2AB;
    }

    public double getOoBpo() {
        return this.ooBpo;
    }

    public double getTon2a() {
        return this.ton2a;
    }

    public double getOoMU() {
        return this.ooMu;
    }

    public double getMeanMotion() {
        return this.n;
    }
}

