/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnDecreasing;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.DateDriver;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;

public class ParameterDrivenDateIntervalDetector
extends AbstractDetector<ParameterDrivenDateIntervalDetector> {
    public static final String START_SUFFIX = "_START";
    public static final String STOP_SUFFIX = "_STOP";
    public static final String MEDIAN_SUFFIX = "_MEDIAN";
    public static final String DURATION_SUFFIX = "_DURATION";
    private DateDriver start;
    private DateDriver stop;
    private DateDriver median;
    private ParameterDriver duration;

    public ParameterDrivenDateIntervalDetector(String prefix, AbsoluteDate refMedian, double refDuration) {
        this(prefix, refMedian.shiftedBy(-0.5 * refDuration), refMedian.shiftedBy(0.5 * refDuration));
    }

    public ParameterDrivenDateIntervalDetector(String prefix, AbsoluteDate refStart, AbsoluteDate refStop) {
        this(0.5 * refStop.durationFrom(refStart), 1.0E-10, 100, new StopOnDecreasing(), new DateDriver(refStart, prefix + START_SUFFIX, true), new DateDriver(refStop, prefix + STOP_SUFFIX, false), new DateDriver(refStart.shiftedBy(0.5 * refStop.durationFrom(refStart)), prefix + MEDIAN_SUFFIX, true), new ParameterDriver(prefix + DURATION_SUFFIX, refStop.durationFrom(refStart), 1.0, 0.0, Double.POSITIVE_INFINITY));
    }

    private ParameterDrivenDateIntervalDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super ParameterDrivenDateIntervalDetector> handler, DateDriver start, DateDriver stop, DateDriver median, ParameterDriver duration) {
        super(maxCheck, threshold, maxIter, handler);
        this.start = start;
        this.stop = stop;
        this.median = median;
        this.duration = duration;
        this.replaceBindingObserver(start, new StartObserver());
        this.replaceBindingObserver(stop, new StopObserver());
        this.replaceBindingObserver(median, new MedianObserver());
        this.replaceBindingObserver(duration, new DurationObserver());
    }

    private void replaceBindingObserver(ParameterDriver driver, BindingObserver bindingObserver) {
        List<ParameterObserver> original = driver.getObservers().stream().filter(observer -> observer instanceof BindingObserver).collect(Collectors.toList());
        original.forEach(observer -> driver.removeObserver((ParameterObserver)observer));
        driver.addObserver(bindingObserver);
    }

    @Override
    protected ParameterDrivenDateIntervalDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super ParameterDrivenDateIntervalDetector> newHandler) {
        return new ParameterDrivenDateIntervalDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.start, this.stop, this.median, this.duration);
    }

    public DateDriver getStartDriver() {
        return this.start;
    }

    public DateDriver getStopDriver() {
        return this.stop;
    }

    public DateDriver getMedianDriver() {
        return this.median;
    }

    public ParameterDriver getDurationDriver() {
        return this.duration;
    }

    @Override
    public double g(SpacecraftState s) {
        return FastMath.min((double)s.getDate().durationFrom(this.start.getDate()), (double)this.stop.getDate().durationFrom(s.getDate()));
    }

    private class DurationObserver
    extends BindingObserver {
        private DurationObserver() {
        }

        @Override
        protected void setDelta(double delta) {
            ParameterDrivenDateIntervalDetector.this.start.setValue(ParameterDrivenDateIntervalDetector.this.start.getValue() - 0.5 * delta);
            ParameterDrivenDateIntervalDetector.this.stop.setValue(ParameterDrivenDateIntervalDetector.this.stop.getValue() + 0.5 * delta);
        }
    }

    private class MedianObserver
    extends BindingObserver {
        private MedianObserver() {
        }

        @Override
        protected void setDelta(double delta) {
            ParameterDrivenDateIntervalDetector.this.start.setValue(ParameterDrivenDateIntervalDetector.this.start.getValue() + delta);
            ParameterDrivenDateIntervalDetector.this.stop.setValue(ParameterDrivenDateIntervalDetector.this.stop.getValue() + delta);
        }
    }

    private class StopObserver
    extends BindingObserver {
        private StopObserver() {
        }

        @Override
        protected void setDelta(double delta) {
            ParameterDrivenDateIntervalDetector.this.median.setValue(ParameterDrivenDateIntervalDetector.this.median.getValue() + 0.5 * delta);
            ParameterDrivenDateIntervalDetector.this.duration.setValue(ParameterDrivenDateIntervalDetector.this.duration.getValue() + delta);
        }
    }

    private class StartObserver
    extends BindingObserver {
        private StartObserver() {
        }

        @Override
        protected void setDelta(double delta) {
            ParameterDrivenDateIntervalDetector.this.median.setValue(ParameterDrivenDateIntervalDetector.this.median.getValue() + 0.5 * delta);
            ParameterDrivenDateIntervalDetector.this.duration.setValue(ParameterDrivenDateIntervalDetector.this.duration.getValue() - delta);
        }
    }

    private abstract class BindingObserver
    implements ParameterObserver {
        private BindingObserver() {
        }

        @Override
        public void valueChanged(double previousValue, ParameterDriver driver) {
            if (driver.isSelected()) {
                this.setDelta(driver.getValue() - previousValue);
            }
        }

        @Override
        public void selectionChanged(boolean previousSelection, ParameterDriver driver) {
            if ((ParameterDrivenDateIntervalDetector.this.start.isSelected() || ParameterDrivenDateIntervalDetector.this.stop.isSelected()) && (ParameterDrivenDateIntervalDetector.this.median.isSelected() || ParameterDrivenDateIntervalDetector.this.duration.isSelected())) {
                throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_SELECTION, ParameterDrivenDateIntervalDetector.this.start.getName(), ParameterDrivenDateIntervalDetector.this.stop.getName(), ParameterDrivenDateIntervalDetector.this.median.getName(), ParameterDrivenDateIntervalDetector.this.duration.getName());
            }
        }

        protected abstract void setDelta(double var1);
    }
}

