/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss.data;

import org.hipparchus.util.FastMath;
import org.orekit.propagation.analytical.gnss.data.AbstractAlmanac;
import org.orekit.propagation.analytical.gnss.data.GNSSOrbitalElements;

public class GalileoAlmanac
extends AbstractAlmanac
implements GNSSOrbitalElements {
    private static final double I0 = FastMath.toRadians((double)56.0);
    private static final double A0 = 2.96E7;
    private int healthE5a;
    private int healthE5b;
    private int healthE1;
    private int iod;

    public GalileoAlmanac() {
        super(3.986004418E14, 7.2921151467E-5, 4096);
    }

    public void setDeltaSqrtA(double dsqa) {
        double sqrtA = dsqa + FastMath.sqrt((double)2.96E7);
        super.setSma(sqrtA * sqrtA);
    }

    public void setDeltaInc(double dinc) {
        super.setI0(I0 + dinc);
    }

    public int getIOD() {
        return this.iod;
    }

    public void setIOD(int iodValue) {
        this.iod = iodValue;
    }

    public int getHealthE1() {
        return this.healthE1;
    }

    public void setHealthE1(int healthE1) {
        this.healthE1 = healthE1;
    }

    public int getHealthE5a() {
        return this.healthE5a;
    }

    public void setHealthE5a(int healthE5a) {
        this.healthE5a = healthE5a;
    }

    public int getHealthE5b() {
        return this.healthE5b;
    }

    public void setHealthE5b(int healthE5b) {
        this.healthE5b = healthE5b;
    }
}

