/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.gnss.data.SBASOrbitalElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class SBASPropagator
extends AbstractAnalyticalPropagator {
    private final SBASOrbitalElements sbasOrbit;
    private final double mass;
    private final double mu;
    private final Frame eci;
    private final Frame ecef;

    SBASPropagator(SBASOrbitalElements sbasOrbit, Frame eci, Frame ecef, AttitudeProvider provider, double mass, double mu) {
        super(provider);
        this.sbasOrbit = sbasOrbit;
        this.setStartDate(sbasOrbit.getDate());
        this.mu = mu;
        this.mass = mass;
        this.eci = eci;
        this.ecef = ecef;
    }

    public PVCoordinates propagateInEcef(AbsoluteDate date) {
        UnivariateDerivative2 dt = new UnivariateDerivative2(this.getDT(date), 1.0, 0.0);
        UnivariateDerivative2 x = dt.multiply(dt.multiply(0.5 * this.sbasOrbit.getXDotDot()).add(this.sbasOrbit.getXDot())).add(this.sbasOrbit.getX());
        UnivariateDerivative2 y = dt.multiply(dt.multiply(0.5 * this.sbasOrbit.getYDotDot()).add(this.sbasOrbit.getYDot())).add(this.sbasOrbit.getY());
        UnivariateDerivative2 z = dt.multiply(dt.multiply(0.5 * this.sbasOrbit.getZDotDot()).add(this.sbasOrbit.getZDot())).add(this.sbasOrbit.getZ());
        FieldVector3D positionwithDerivatives = new FieldVector3D((CalculusFieldElement)x, (CalculusFieldElement)y, (CalculusFieldElement)z);
        return new PVCoordinates(new Vector3D(((UnivariateDerivative2)positionwithDerivatives.getX()).getValue(), ((UnivariateDerivative2)positionwithDerivatives.getY()).getValue(), ((UnivariateDerivative2)positionwithDerivatives.getZ()).getValue()), new Vector3D(((UnivariateDerivative2)positionwithDerivatives.getX()).getFirstDerivative(), ((UnivariateDerivative2)positionwithDerivatives.getY()).getFirstDerivative(), ((UnivariateDerivative2)positionwithDerivatives.getZ()).getFirstDerivative()), new Vector3D(((UnivariateDerivative2)positionwithDerivatives.getX()).getSecondDerivative(), ((UnivariateDerivative2)positionwithDerivatives.getY()).getSecondDerivative(), ((UnivariateDerivative2)positionwithDerivatives.getZ()).getSecondDerivative()));
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        PVCoordinates pvaInECEF = this.propagateInEcef(date);
        PVCoordinates pvaInECI = this.ecef.getTransformTo(this.eci, date).transformPVCoordinates(pvaInECEF);
        return new CartesianOrbit(pvaInECI, this.eci, date, this.mu);
    }

    public double getMU() {
        return this.mu;
    }

    public Frame getECI() {
        return this.eci;
    }

    public Frame getECEF() {
        return this.ecef;
    }

    public SBASOrbitalElements getSBASOrbitalElements() {
        return this.sbasOrbit;
    }

    @Override
    public Frame getFrame() {
        return this.eci;
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.mass;
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    private double getDT(AbsoluteDate date) {
        return date.durationFrom(this.sbasOrbit.getDate());
    }
}

