/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.hipparchus.util.SinCos;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.AbstractMatricesHarvester;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.BrouwerLyddaneHarvester;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public class BrouwerLyddanePropagator
extends AbstractAnalyticalPropagator {
    public static final String M2_NAME = "M2";
    public static final double M2 = 0.0;
    private static final double SCALE = FastMath.scalb((double)1.0, (int)-32);
    private static final double BETA = FastMath.scalb((float)100.0f, (int)-11);
    private BLModel initialModel;
    private transient TimeSpanMap<BLModel> models;
    private double referenceRadius;
    private double mu;
    private double[] ck0;
    private final ParameterDriver M2Driver;

    public BrouwerLyddanePropagator(Orbit initialOrbit, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), 1000.0, provider, provider.onDate(initialOrbit.getDate()), M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitude, double mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, double M2) {
        this(initialOrbit, attitude, mass, provider.getAe(), provider.getMu(), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double M2) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), 1000.0, referenceRadius, mu, c20, c30, c40, c50, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, double mass, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), mass, provider, provider.onDate(initialOrbit.getDate()), M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, double mass, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double M2) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), mass, referenceRadius, mu, c20, c30, c40, c50, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, attitudeProv, 1000.0, provider, provider.onDate(initialOrbit.getDate()), M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double M2) {
        this(initialOrbit, attitudeProv, 1000.0, referenceRadius, mu, c20, c30, c40, c50, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate()), M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double M2) {
        this(initialOrbit, attitudeProv, mass, referenceRadius, mu, c20, c30, c40, c50, PropagationType.OSCULATING, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, UnnormalizedSphericalHarmonicsProvider provider, PropagationType initialType, double M2) {
        this(initialOrbit, InertialProvider.of(initialOrbit.getFrame()), 1000.0, provider, provider.onDate(initialOrbit.getDate()), initialType, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, UnnormalizedSphericalHarmonicsProvider provider, PropagationType initialType, double M2) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate()), initialType, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitude, double mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, PropagationType initialType, double M2) {
        this(initialOrbit, attitude, mass, provider.getAe(), provider.getMu(), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), initialType, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, double referenceRadius, double mu, double c20, double c30, double c40, double c50, PropagationType initialType, double M2) {
        super(attitudeProv);
        this.referenceRadius = referenceRadius;
        this.mu = mu;
        this.ck0 = new double[]{0.0, 0.0, c20, c30, c40, c50};
        this.M2Driver = new ParameterDriver(M2_NAME, M2, SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.resetInitialState(new SpacecraftState(initialOrbit, attitudeProv.getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass), initialType);
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        this.resetInitialState(state, PropagationType.OSCULATING);
    }

    public void resetInitialState(SpacecraftState state, PropagationType stateType) {
        super.resetInitialState(state);
        KeplerianOrbit keplerian = (KeplerianOrbit)OrbitType.KEPLERIAN.convertType(state.getOrbit());
        this.initialModel = stateType == PropagationType.MEAN ? new BLModel(keplerian, state.getMass(), this.referenceRadius, this.mu, this.ck0) : this.computeMeanParameters(keplerian, state.getMass());
        this.models = new TimeSpanMap<BLModel>(this.initialModel);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        BLModel newModel = this.computeMeanParameters((KeplerianOrbit)OrbitType.KEPLERIAN.convertType(state.getOrbit()), state.getMass());
        if (forward) {
            this.models.addValidAfter(newModel, state.getDate(), false);
        } else {
            this.models.addValidBefore(newModel, state.getDate(), false);
        }
        this.stateChanged(state);
    }

    private BLModel computeMeanParameters(KeplerianOrbit osculating, double mass) {
        if (osculating.getA() < this.referenceRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, osculating.getA());
        }
        BLModel current = new BLModel(osculating, mass, this.referenceRadius, this.mu, this.ck0);
        double epsilon = 1.0E-13;
        double thresholdA = 1.0E-13 * (1.0 + FastMath.abs((double)current.mean.getA()));
        double thresholdE = 1.0E-13 * (1.0 + current.mean.getE());
        double thresholdAngles = 3.141592653589793E-13;
        int i = 0;
        while (i++ < 200) {
            UnivariateDerivative2[] parameters = current.propagateParameters(current.mean.getDate());
            double deltaA = osculating.getA() - parameters[0].getValue();
            double deltaE = osculating.getE() - parameters[1].getValue();
            double deltaI = osculating.getI() - parameters[2].getValue();
            double deltaOmega = MathUtils.normalizeAngle((double)(osculating.getPerigeeArgument() - parameters[3].getValue()), (double)0.0);
            double deltaRAAN = MathUtils.normalizeAngle((double)(osculating.getRightAscensionOfAscendingNode() - parameters[4].getValue()), (double)0.0);
            double deltaAnom = MathUtils.normalizeAngle((double)(osculating.getMeanAnomaly() - parameters[5].getValue()), (double)0.0);
            current = new BLModel(new KeplerianOrbit(current.mean.getA() + deltaA, current.mean.getE() + deltaE, current.mean.getI() + deltaI, current.mean.getPerigeeArgument() + deltaOmega, current.mean.getRightAscensionOfAscendingNode() + deltaRAAN, current.mean.getMeanAnomaly() + deltaAnom, PositionAngle.MEAN, current.mean.getFrame(), current.mean.getDate(), this.mu), mass, this.referenceRadius, this.mu, this.ck0);
            if (!(FastMath.abs((double)deltaA) < thresholdA) || !(FastMath.abs((double)deltaE) < thresholdE) || !(FastMath.abs((double)deltaI) < 3.141592653589793E-13) || !(FastMath.abs((double)deltaOmega) < 3.141592653589793E-13) || !(FastMath.abs((double)deltaRAAN) < 3.141592653589793E-13) || !(FastMath.abs((double)deltaAnom) < 3.141592653589793E-13)) continue;
            return current;
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_BROUWER_LYDDANE_MEAN_PARAMETERS, i);
    }

    @Override
    public KeplerianOrbit propagateOrbit(AbsoluteDate date) {
        BLModel current = this.models.get(date);
        UnivariateDerivative2[] propOrb_parameters = current.propagateParameters(date);
        return new KeplerianOrbit(propOrb_parameters[0].getValue(), propOrb_parameters[1].getValue(), propOrb_parameters[2].getValue(), propOrb_parameters[3].getValue(), propOrb_parameters[4].getValue(), propOrb_parameters[5].getValue(), PositionAngle.MEAN, current.mean.getFrame(), date, this.mu);
    }

    public double getM2() {
        return this.M2Driver.getValue();
    }

    public double getMu() {
        return this.mu;
    }

    public double[] getCk0() {
        return (double[])this.ck0.clone();
    }

    public double getReferenceRadius() {
        return this.referenceRadius;
    }

    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.M2Driver);
    }

    @Override
    protected AbstractMatricesHarvester createHarvester(String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        return new BrouwerLyddaneHarvester(this, stmName, initialStm, initialJacobianColumns);
    }

    @Override
    protected List<String> getJacobiansColumnsNames() {
        ArrayList<String> columnsNames = new ArrayList<String>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected() || columnsNames.contains(driver.getName())) continue;
            columnsNames.add(driver.getName());
        }
        Collections.sort(columnsNames);
        return columnsNames;
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.models.get(date).mass;
    }

    private class BLModel {
        private final KeplerianOrbit mean;
        private final double mass;
        private final double xnotDot;
        private final double n;
        private final double lt;
        private final double gt;
        private final double ht;
        private final double dei3sg;
        private final double de2sg;
        private final double deisg;
        private final double de;
        private final double dlgs2g;
        private final double dlgc3g;
        private final double dlgcg;
        private final double dh2sgcg;
        private final double dhsgcg;
        private final double dhcg;
        private final double aC;
        private final double aCbis;
        private final double ac2g2f;
        private final double eC;
        private final double ecf;
        private final double e2cf;
        private final double e3cf;
        private final double ec2f2g;
        private final double ecfc2f2g;
        private final double e2cfc2f2g;
        private final double e3cfc2f2g;
        private final double ec2gf;
        private final double ec2g3f;
        private final double ide;
        private final double isfs2f2g;
        private final double icfc2f2g;
        private final double ic2f2g;
        private final double glf;
        private final double gll;
        private final double glsf;
        private final double glosf;
        private final double gls2f2g;
        private final double gls2gf;
        private final double glos2gf;
        private final double gls2g3f;
        private final double glos2g3f;
        private final double hf;
        private final double hl;
        private final double hsf;
        private final double hcfs2g2f;
        private final double hs2g2f;
        private final double hsfc2g2f;
        private final double edls2g;
        private final double edlcg;
        private final double edlc3g;
        private final double edlsf;
        private final double edls2gf;
        private final double edls2g3f;
        private final double aRate;
        private final double eRate;

        BLModel(KeplerianOrbit mean, double mass, double referenceRadius, double mu, double[] ck0) {
            this.mean = mean;
            this.mass = mass;
            double app = mean.getA();
            this.xnotDot = FastMath.sqrt((double)(mu / app)) / app;
            double q = referenceRadius / app;
            double ql = q * q;
            double y2 = -0.5 * ck0[2] * ql;
            this.n = FastMath.sqrt((double)(1.0 - mean.getE() * mean.getE()));
            double n2 = this.n * this.n;
            double n3 = n2 * this.n;
            double n4 = n2 * n2;
            double n6 = n4 * n2;
            double n8 = n4 * n4;
            double n10 = n8 * n2;
            double yp2 = y2 / n4;
            double yp3 = ck0[3] * (ql *= q) / n6;
            double yp4 = 0.375 * ck0[4] * (ql *= q) / n8;
            double yp5 = ck0[5] * (ql *= q) / n10;
            SinCos sc = FastMath.sinCos((double)mean.getI());
            double sinI1 = sc.sin();
            double sinI2 = sinI1 * sinI1;
            double cosI1 = sc.cos();
            double cosI2 = cosI1 * cosI1;
            double cosI3 = cosI2 * cosI1;
            double cosI4 = cosI2 * cosI2;
            double cosI6 = cosI4 * cosI2;
            double C5c2 = 1.0 / this.T2(cosI1);
            double C3c2 = 3.0 * cosI2 - 1.0;
            double epp = mean.getE();
            double epp2 = epp * epp;
            double epp3 = epp2 * epp;
            double epp4 = epp2 * epp2;
            if (epp >= 1.0) {
                throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ECCENTRICITY_FOR_PROPAGATION_MODEL, mean.getE());
            }
            this.lt = 1.0 + 1.5 * yp2 * this.n * C3c2 + 0.09375 * yp2 * yp2 * this.n * (-15.0 + 16.0 * this.n + 25.0 * n2 + (30.0 - 96.0 * this.n - 90.0 * n2) * cosI2 + (105.0 + 144.0 * this.n + 25.0 * n2) * cosI4) + 0.9375 * yp4 * this.n * epp2 * (3.0 - 30.0 * cosI2 + 35.0 * cosI4);
            this.gt = -1.5 * yp2 * C5c2 + 0.09375 * yp2 * yp2 * (-35.0 + 24.0 * this.n + 25.0 * n2 + (90.0 - 192.0 * this.n - 126.0 * n2) * cosI2 + (385.0 + 360.0 * this.n + 45.0 * n2) * cosI4) + 0.3125 * yp4 * (21.0 - 9.0 * n2 + (-270.0 + 126.0 * n2) * cosI2 + (385.0 - 189.0 * n2) * cosI4);
            this.ht = -3.0 * yp2 * cosI1 + 0.375 * yp2 * yp2 * ((-5.0 + 12.0 * this.n + 9.0 * n2) * cosI1 + (-35.0 - 36.0 * this.n - 5.0 * n2) * cosI3) + 1.25 * yp4 * (5.0 - 3.0 * n2) * cosI1 * (3.0 - 7.0 * cosI2);
            double cA = 1.0 - 11.0 * cosI2 - 40.0 * cosI4 / C5c2;
            double cB = 1.0 - 3.0 * cosI2 - 8.0 * cosI4 / C5c2;
            double cC = 1.0 - 9.0 * cosI2 - 24.0 * cosI4 / C5c2;
            double cD = 1.0 - 5.0 * cosI2 - 16.0 * cosI4 / C5c2;
            double qyp2_4 = 3.0 * yp2 * yp2 * cA - 10.0 * yp4 * cB;
            double qyp52 = epp3 * cosI1 * (0.5 * cD / sinI1 + sinI1 * (5.0 + 32.0 * cosI2 / C5c2 + 80.0 * cosI4 / C5c2 / C5c2));
            double qyp22 = 2.0 + epp2 - 11.0 * (2.0 + 3.0 * epp2) * cosI2 - 40.0 * (2.0 + 5.0 * epp2) * cosI4 / C5c2 - 400.0 * epp2 * cosI6 / C5c2 / C5c2;
            double qyp42 = (qyp22 + 4.0 * (2.0 + epp2 - (2.0 + 3.0 * epp2) * cosI2)) / 5.0;
            double qyp52bis = epp * cosI1 * sinI1 * (4.0 + 3.0 * epp2) * (3.0 + 16.0 * cosI2 / C5c2 + 40.0 * cosI4 / C5c2 / C5c2);
            this.dei3sg = 0.3645833333333333 * yp5 / yp2 * epp2 * n2 * cD * sinI1;
            this.de2sg = -0.08333333333333333 * epp * n2 / yp2 * qyp2_4;
            this.deisg = (-0.2734375 * yp5 / yp2 * epp2 * n2 * cD + 0.25 * n2 / yp2 * (yp3 + 0.3125 * yp5 * (4.0 + 3.0 * epp2) * cC)) * sinI1;
            this.de = epp2 * n2 / 24.0 / yp2 * qyp2_4;
            double qyp52quotient = epp * (-32.0 + 81.0 * epp4) / (4.0 + 3.0 * epp2 + this.n * (4.0 + 9.0 * epp2));
            this.dlgs2g = 0.020833333333333332 / yp2 * (-3.0 * yp2 * yp2 * qyp22 + 10.0 * yp4 * qyp42) + n3 / yp2 * qyp2_4 / 24.0;
            this.dlgc3g = 0.09114583333333333 * yp5 / yp2 * n3 * epp * cD * sinI1 + 0.030381944444444444 * yp5 / yp2 * (2.0 * qyp52 * cosI1 - epp * cD * sinI1 * (3.0 + 2.0 * epp2));
            this.dlgcg = -yp3 * epp * cosI2 / (4.0 * yp2 * sinI1) + 0.078125 * yp5 / yp2 * (-epp * cosI2 / sinI1 * (4.0 + 3.0 * epp2) + epp2 * sinI1 * (26.0 + 9.0 * epp2)) * cC - 0.46875 * yp5 / yp2 * qyp52bis * cosI1 + 0.25 * yp3 / yp2 * sinI1 * epp / (1.0 + n3) * (3.0 - epp2 * (3.0 - epp2)) + 0.078125 * yp5 / yp2 * n2 * cC * qyp52quotient * sinI1;
            double qyp24 = 3.0 * yp2 * yp2 * (11.0 + 80.0 * cosI2 / sinI1 + 200.0 * cosI4 / sinI2) - 10.0 * yp4 * (3.0 + 16.0 * cosI2 / sinI1 + 40.0 * cosI4 / sinI2);
            this.dh2sgcg = 0.24305555555555555 * yp5 / yp2 * qyp52;
            this.dhsgcg = -epp2 * cosI1 / (12.0 * yp2) * qyp24;
            this.dhcg = -0.06076388888888889 * yp5 / yp2 * qyp52 + epp * cosI1 / (4.0 * yp2 * sinI1) * (yp3 + 0.3125 * yp5 * (4.0 + 3.0 * epp2) * cC) + 1.875 / (4.0 * yp2) * yp5 * qyp52bis;
            this.aC = -yp2 * C3c2 * app / n3;
            this.aCbis = y2 * app * C3c2;
            this.ac2g2f = y2 * app * 3.0 * sinI2;
            double qe = 0.5 * n2 * y2 * C3c2 / n6;
            this.eC = qe * epp / (1.0 + n3) * (3.0 - epp2 * (3.0 - epp2));
            this.ecf = 3.0 * qe;
            this.e2cf = 3.0 * epp * qe;
            this.e3cf = epp2 * qe;
            qe = 0.5 * n2 * y2 * 3.0 * (1.0 - cosI2) / n6;
            this.ec2f2g = qe * epp;
            this.ecfc2f2g = 3.0 * qe;
            this.e2cfc2f2g = 3.0 * epp * qe;
            this.e3cfc2f2g = epp2 * qe;
            qe = -0.5 * yp2 * n2 * (1.0 - cosI2);
            this.ec2gf = 3.0 * qe;
            this.ec2g3f = qe;
            double qi = epp * yp2 * cosI1 * sinI1;
            this.ide = -epp * cosI1 / (n2 * sinI1);
            this.isfs2f2g = qi;
            this.icfc2f2g = 2.0 * qi;
            qi = yp2 * cosI1 * sinI1;
            this.ic2f2g = 1.5 * qi;
            double qgl1 = 0.25 * yp2;
            double qgl2 = 0.25 * yp2 * epp * n2 / (1.0 + this.n);
            this.glf = qgl1 * -6.0 * C5c2;
            this.gll = qgl1 * 6.0 * C5c2;
            this.glsf = qgl1 * -6.0 * C5c2 * epp + qgl2 * 2.0 * C3c2;
            this.glosf = qgl2 * 2.0 * C3c2;
            qgl2 = qgl2 * 3.0 * (1.0 - cosI2);
            this.gls2f2g = 3.0 * (qgl1 *= 3.0 - 5.0 * cosI2);
            this.gls2gf = 3.0 * epp * qgl1 + qgl2;
            this.glos2gf = -1.0 * qgl2;
            this.gls2g3f = qgl1 * epp + 0.3333333333333333 * qgl2;
            this.glos2g3f = qgl2;
            double qh = 3.0 * yp2 * cosI1;
            this.hf = -qh;
            this.hl = qh;
            this.hsf = -epp * qh;
            this.hcfs2g2f = 2.0 * epp * yp2 * cosI1;
            this.hs2g2f = 1.5 * yp2 * cosI1;
            this.hsfc2g2f = -epp * yp2 * cosI1;
            double qedl = -0.25 * yp2 * n3;
            this.edls2g = 0.041666666666666664 * epp * n3 / yp2 * qyp2_4;
            this.edlcg = -0.25 * yp3 / yp2 * n3 * sinI1 - 0.078125 * yp5 / yp2 * n3 * sinI1 * (4.0 + 9.0 * epp2) * cC;
            this.edlc3g = 0.09114583333333333 * yp5 / yp2 * n3 * epp2 * cD * sinI1;
            this.edlsf = 2.0 * qedl * C3c2;
            this.edls2gf = 3.0 * qedl * (1.0 - cosI2);
            this.edls2g3f = 0.3333333333333333 * qedl;
            this.aRate = -4.0 * app / (3.0 * this.xnotDot);
            this.eRate = -4.0 * epp * this.n * this.n / (3.0 * this.xnotDot);
        }

        private UnivariateDerivative2 eMeSinE(UnivariateDerivative2 E) {
            UnivariateDerivative2 x = E.sin().multiply(1.0 - this.mean.getE());
            UnivariateDerivative2 mE2 = E.negate().multiply(E);
            UnivariateDerivative2 term = E;
            UnivariateDerivative2 d = E.getField().getZero();
            UnivariateDerivative2 x0 = d.add(Double.NaN);
            while (!Double.valueOf(x.getValue()).equals(x0.getValue())) {
                d = d.add(2.0);
                term = term.multiply(mE2.divide(d.multiply(d.add(1.0))));
                x0 = x;
                x = x.subtract(term);
            }
            return x;
        }

        private UnivariateDerivative2 getEccentricAnomaly(UnivariateDerivative2 mk) {
            UnivariateDerivative2 ek;
            double k1 = 11.42477796076938;
            double k2 = 2.141592653589793;
            double k3 = 17.84955592153876;
            double A = 1.2043347651023166;
            double B = 4.64788969626918;
            UnivariateDerivative2 reducedM = new UnivariateDerivative2(MathUtils.normalizeAngle((double)mk.getValue(), (double)0.0), mk.getFirstDerivative(), mk.getSecondDerivative());
            if (FastMath.abs((double)reducedM.getValue()) < 0.16666666666666666) {
                ek = FastMath.abs((double)reducedM.getValue()) < Precision.SAFE_MIN ? reducedM : reducedM.add(reducedM.multiply(6).cbrt().subtract(reducedM).multiply(this.mean.getE()));
            } else if (reducedM.getValue() < 0.0) {
                UnivariateDerivative2 w = reducedM.add(Math.PI);
                ek = reducedM.add(w.multiply(-1.2043347651023166).divide(w.subtract(4.64788969626918)).subtract(Math.PI).subtract(reducedM).multiply(this.mean.getE()));
            } else {
                UnivariateDerivative2 minusW = reducedM.subtract(Math.PI);
                ek = reducedM.add(minusW.multiply(1.2043347651023166).divide(minusW.add(4.64788969626918)).add(Math.PI).subtract(reducedM).multiply(this.mean.getE()));
            }
            double e1 = 1.0 - this.mean.getE();
            boolean noCancellationRisk = e1 + ek.getValue() * ek.getValue() / 6.0 >= 0.1;
            for (int j = 0; j < 2; ++j) {
                UnivariateDerivative2 fd;
                UnivariateDerivative2 f;
                UnivariateDerivative2 fdd = ek.sin().multiply(this.mean.getE());
                UnivariateDerivative2 fddd = ek.cos().multiply(this.mean.getE());
                if (noCancellationRisk) {
                    f = ek.subtract(fdd).subtract(reducedM);
                    fd = fddd.subtract(1.0).negate();
                } else {
                    f = this.eMeSinE(ek).subtract(reducedM);
                    UnivariateDerivative2 s = ek.multiply(0.5).sin();
                    fd = s.multiply(s).multiply(2.0 * this.mean.getE()).add(e1);
                }
                UnivariateDerivative2 dee = f.multiply(fd).divide(f.multiply(0.5).multiply(fdd).subtract(fd.multiply(fd)));
                UnivariateDerivative2 w = fd.add(dee.multiply(0.5).multiply(fdd.add(dee.multiply(fdd).divide(3.0))));
                fd = fd.add(dee.multiply(fdd.add(dee.multiply(0.5).multiply(fdd))));
                ek = ek.subtract(f.subtract(dee.multiply(fd.subtract(w))).divide(fd));
            }
            ek = ek.add(mk.getValue() - reducedM.getValue());
            return ek;
        }

        private double T2(double cosInc) {
            double x = 1.0 - 5.0 * cosInc * cosInc;
            double x2 = x * x;
            double sum = 0.0;
            for (int i = 0; i <= 12; ++i) {
                double sign = i % 2 == 0 ? 1.0 : -1.0;
                sum += sign * FastMath.pow((double)BETA, (int)i) * FastMath.pow((double)x2, (int)i) / CombinatoricsUtils.factorialDouble((int)(i + 1));
            }
            double product = 1.0;
            for (int i = 0; i <= 10; ++i) {
                product *= 1.0 + FastMath.exp((double)(FastMath.scalb((double)-1.0, (int)i) * BETA * x2));
            }
            return BETA * x * sum * product;
        }

        public UnivariateDerivative2[] propagateParameters(AbsoluteDate date) {
            double m2 = BrouwerLyddanePropagator.this.M2Driver.getValue();
            UnivariateDerivative2 dt = new UnivariateDerivative2(date.durationFrom(this.mean.getDate()), 1.0, 0.0);
            UnivariateDerivative2 xnot = dt.multiply(this.xnotDot);
            UnivariateDerivative2 dtM2 = dt.multiply(m2);
            UnivariateDerivative2 dt2M2 = dt.multiply(dtM2);
            UnivariateDerivative2 lpp = new UnivariateDerivative2(MathUtils.normalizeAngle((double)(this.mean.getMeanAnomaly() + this.lt * xnot.getValue() + dt2M2.getValue()), (double)Math.PI), this.lt * this.xnotDot + 2.0 * dtM2.getValue(), 2.0 * m2);
            UnivariateDerivative2 gpp = new UnivariateDerivative2(MathUtils.normalizeAngle((double)(this.mean.getPerigeeArgument() + this.gt * xnot.getValue()), (double)Math.PI), this.gt * this.xnotDot, 0.0);
            UnivariateDerivative2 hpp = new UnivariateDerivative2(MathUtils.normalizeAngle((double)(this.mean.getRightAscensionOfAscendingNode() + this.ht * xnot.getValue()), (double)Math.PI), this.ht * this.xnotDot, 0.0);
            UnivariateDerivative2 appDrag = dt.multiply(this.aRate * m2);
            UnivariateDerivative2 eppDrag = dt.multiply(this.eRate * m2);
            UnivariateDerivative2 cg1 = gpp.cos();
            UnivariateDerivative2 sg1 = gpp.sin();
            UnivariateDerivative2 c2g = cg1.multiply(cg1).subtract(sg1.multiply(sg1));
            UnivariateDerivative2 s2g = cg1.multiply(sg1).add(sg1.multiply(cg1));
            UnivariateDerivative2 c3g = c2g.multiply(cg1).subtract(s2g.multiply(sg1));
            UnivariateDerivative2 sg2 = sg1.multiply(sg1);
            UnivariateDerivative2 sg3 = sg1.multiply(sg2);
            UnivariateDerivative2 d1e = sg3.multiply(this.dei3sg).add(sg1.multiply(this.deisg)).add(sg2.multiply(this.de2sg)).add(this.de);
            UnivariateDerivative2 lp_p_gp = s2g.multiply(this.dlgs2g).add(c3g.multiply(this.dlgc3g)).add(cg1.multiply(this.dlgcg)).add(lpp).add(gpp);
            UnivariateDerivative2 hp = sg2.multiply(cg1).multiply(this.dh2sgcg).add(sg1.multiply(cg1).multiply(this.dhsgcg)).add(cg1.multiply(this.dhcg)).add(hpp);
            UnivariateDerivative2 Ep = this.getEccentricAnomaly(lpp);
            UnivariateDerivative2 cf1 = Ep.cos().subtract(this.mean.getE()).divide(Ep.cos().multiply(-this.mean.getE()).add(1.0));
            UnivariateDerivative2 sf1 = Ep.sin().multiply(this.n).divide(Ep.cos().multiply(-this.mean.getE()).add(1.0));
            UnivariateDerivative2 f = (UnivariateDerivative2)FastMath.atan2((CalculusFieldElement)sf1, (CalculusFieldElement)cf1);
            UnivariateDerivative2 c2f = cf1.multiply(cf1).subtract(sf1.multiply(sf1));
            UnivariateDerivative2 s2f = cf1.multiply(sf1).add(sf1.multiply(cf1));
            UnivariateDerivative2 c3f = c2f.multiply(cf1).subtract(s2f.multiply(sf1));
            UnivariateDerivative2 s3f = c2f.multiply(sf1).add(s2f.multiply(cf1));
            UnivariateDerivative2 cf2 = cf1.multiply(cf1);
            UnivariateDerivative2 cf3 = cf1.multiply(cf2);
            UnivariateDerivative2 c2g1f = cf1.multiply(c2g).subtract(sf1.multiply(s2g));
            UnivariateDerivative2 c2g2f = c2f.multiply(c2g).subtract(s2f.multiply(s2g));
            UnivariateDerivative2 c2g3f = c3f.multiply(c2g).subtract(s3f.multiply(s2g));
            UnivariateDerivative2 s2g1f = cf1.multiply(s2g).add(c2g.multiply(sf1));
            UnivariateDerivative2 s2g2f = c2f.multiply(s2g).add(c2g.multiply(s2f));
            UnivariateDerivative2 s2g3f = c3f.multiply(s2g).add(c2g.multiply(s3f));
            UnivariateDerivative2 eE = Ep.cos().multiply(-this.mean.getE()).add(1.0).reciprocal();
            UnivariateDerivative2 eE3 = eE.multiply(eE).multiply(eE);
            UnivariateDerivative2 sigma = eE.multiply(this.n * this.n).multiply(eE).add(eE);
            UnivariateDerivative2 a = eE3.multiply(this.aCbis).add(appDrag.add(this.mean.getA())).add(this.aC).add(eE3.multiply(c2g2f).multiply(this.ac2g2f));
            UnivariateDerivative2 e = d1e.add(eppDrag.add(this.mean.getE())).add(this.eC).add(cf1.multiply(this.ecf)).add(cf2.multiply(this.e2cf)).add(cf3.multiply(this.e3cf)).add(c2g2f.multiply(this.ec2f2g)).add(c2g2f.multiply(cf1).multiply(this.ecfc2f2g)).add(c2g2f.multiply(cf2).multiply(this.e2cfc2f2g)).add(c2g2f.multiply(cf3).multiply(this.e3cfc2f2g)).add(c2g1f.multiply(this.ec2gf)).add(c2g3f.multiply(this.ec2g3f));
            UnivariateDerivative2 i = d1e.multiply(this.ide).add(this.mean.getI()).add(sf1.multiply(s2g2f.multiply(this.isfs2f2g))).add(cf1.multiply(c2g2f.multiply(this.icfc2f2g))).add(c2g2f.multiply(this.ic2f2g));
            UnivariateDerivative2 g_p_l = lp_p_gp.add(f.multiply(this.glf)).add(lpp.multiply(this.gll)).add(sf1.multiply(this.glsf)).add(sigma.multiply(sf1).multiply(this.glosf)).add(s2g2f.multiply(this.gls2f2g)).add(s2g1f.multiply(this.gls2gf)).add(sigma.multiply(s2g1f).multiply(this.glos2gf)).add(s2g3f.multiply(this.gls2g3f)).add(sigma.multiply(s2g3f).multiply(this.glos2g3f));
            UnivariateDerivative2 h = hp.add(f.multiply(this.hf)).add(lpp.multiply(this.hl)).add(sf1.multiply(this.hsf)).add(cf1.multiply(s2g2f).multiply(this.hcfs2g2f)).add(s2g2f.multiply(this.hs2g2f)).add(c2g2f.multiply(sf1).multiply(this.hsfc2g2f));
            UnivariateDerivative2 edl = s2g.multiply(this.edls2g).add(cg1.multiply(this.edlcg)).add(c3g.multiply(this.edlc3g)).add(sf1.multiply(this.edlsf)).add(s2g1f.multiply(this.edls2gf)).add(s2g3f.multiply(this.edls2g3f)).add(sf1.multiply(sigma).multiply(this.edlsf)).add(s2g1f.multiply(sigma).multiply(-this.edls2gf)).add(s2g3f.multiply(sigma).multiply(3.0 * this.edls2g3f));
            UnivariateDerivative2 A = e.multiply(lpp.cos()).subtract(edl.multiply(lpp.sin()));
            UnivariateDerivative2 B = e.multiply(lpp.sin()).add(edl.multiply(lpp.cos()));
            UnivariateDerivative2 l = (UnivariateDerivative2)FastMath.atan2((CalculusFieldElement)B, (CalculusFieldElement)A);
            UnivariateDerivative2 g = g_p_l.subtract(l);
            return new UnivariateDerivative2[]{a, e, i, g, h, l};
        }
    }
}

