/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.orbits.FieldOrbit;
import org.orekit.propagation.AbstractMatricesHarvester;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalGradientConverter;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public abstract class AbstractAnalyticalMatricesHarvester
extends AbstractMatricesHarvester {
    private List<String> columnsNames;
    private AbsoluteDate epoch;
    private final double[][] analyticalDerivativesStm;
    private final DoubleArrayDictionary analyticalDerivativesJacobianColumns;
    private final AbstractAnalyticalPropagator propagator;

    protected AbstractAnalyticalMatricesHarvester(AbstractAnalyticalPropagator propagator, String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        super(stmName, initialStm, initialJacobianColumns);
        this.propagator = propagator;
        this.epoch = propagator.getInitialState().getDate();
        this.columnsNames = null;
        this.analyticalDerivativesStm = this.getInitialStateTransitionMatrix().getData();
        this.analyticalDerivativesJacobianColumns = new DoubleArrayDictionary();
    }

    @Override
    public List<String> getJacobiansColumnsNames() {
        return this.columnsNames == null ? this.propagator.getJacobiansColumnsNames() : this.columnsNames;
    }

    @Override
    public void freezeColumnsNames() {
        this.columnsNames = this.getJacobiansColumnsNames();
    }

    @Override
    public RealMatrix getStateTransitionMatrix(SpacecraftState state) {
        this.updateDerivativesIfNeeded(state);
        return MatrixUtils.createRealMatrix((double[][])this.analyticalDerivativesStm);
    }

    @Override
    public RealMatrix getParametersJacobian(SpacecraftState state) {
        this.updateDerivativesIfNeeded(state);
        List<String> names = this.getJacobiansColumnsNames();
        if (names == null || names.isEmpty()) {
            return null;
        }
        RealMatrix dYdP = MatrixUtils.createRealMatrix((int)6, (int)names.size());
        for (int j = 0; j < names.size(); ++j) {
            double[] column = this.analyticalDerivativesJacobianColumns.get(names.get(j));
            if (column == null) continue;
            for (int i = 0; i < 6; ++i) {
                dYdP.addToEntry(i, j, column[i]);
            }
        }
        return dYdP;
    }

    @Override
    public void setReferenceState(SpacecraftState reference) {
        for (double[] row : this.analyticalDerivativesStm) {
            Arrays.fill(row, 0.0);
        }
        this.analyticalDerivativesJacobianColumns.clear();
        AbstractAnalyticalGradientConverter converter = this.getGradientConverter();
        FieldSpacecraftState<Gradient> gState = converter.getState();
        Gradient[] gParameters = converter.getParameters(gState);
        FieldAbstractAnalyticalPropagator<Gradient> gPropagator = converter.getPropagator(gState, gParameters);
        AbsoluteDate target = reference.getDate();
        FieldAbsoluteDate start = gPropagator.getInitialState().getDate();
        double dt = target.durationFrom(start.toAbsoluteDate());
        FieldOrbit gOrbit = gPropagator.propagateOrbit((FieldAbsoluteDate)start.shiftedBy(dt), (CalculusFieldElement[])gParameters);
        TimeStampedFieldPVCoordinates gPv = gOrbit.getPVCoordinates();
        double[] derivativesX = ((Gradient)gPv.getPosition().getX()).getGradient();
        double[] derivativesY = ((Gradient)gPv.getPosition().getY()).getGradient();
        double[] derivativesZ = ((Gradient)gPv.getPosition().getZ()).getGradient();
        double[] derivativesVx = ((Gradient)gPv.getVelocity().getX()).getGradient();
        double[] derivativesVy = ((Gradient)gPv.getVelocity().getY()).getGradient();
        double[] derivativesVz = ((Gradient)gPv.getVelocity().getZ()).getGradient();
        this.addToRow(derivativesX, 0);
        this.addToRow(derivativesY, 1);
        this.addToRow(derivativesZ, 2);
        this.addToRow(derivativesVx, 3);
        this.addToRow(derivativesVy, 4);
        this.addToRow(derivativesVz, 5);
        int paramsIndex = converter.getFreeStateParameters();
        for (ParameterDriver driver : converter.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            DoubleArrayDictionary.Entry entry = this.analyticalDerivativesJacobianColumns.getEntry(driver.getName());
            if (entry == null) {
                this.analyticalDerivativesJacobianColumns.put(driver.getName(), new double[6]);
                entry = this.analyticalDerivativesJacobianColumns.getEntry(driver.getName());
            }
            entry.increment(new double[]{derivativesX[paramsIndex], derivativesY[paramsIndex], derivativesZ[paramsIndex], derivativesVx[paramsIndex], derivativesVy[paramsIndex], derivativesVz[paramsIndex]});
            ++paramsIndex;
        }
        this.epoch = target;
    }

    private void updateDerivativesIfNeeded(SpacecraftState state) {
        if (!state.getDate().isEqualTo(this.epoch)) {
            this.setReferenceState(state);
        }
    }

    private void addToRow(double[] derivatives, int index) {
        for (int i = 0; i < 6; ++i) {
            double[] dArray = this.analyticalDerivativesStm[index];
            int n = i;
            dArray[n] = dArray[n] + derivatives[i];
        }
    }

    public abstract AbstractAnalyticalGradientConverter getGradientConverter();
}

