/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.tessellation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.hipparchus.util.SinCos;
import org.orekit.bodies.Ellipse;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.tessellation.Direction;
import org.orekit.models.earth.tessellation.TileAiming;

class Mesh {
    private final OneAxisEllipsoid ellipsoid;
    private final SphericalPolygonsSet zone;
    private SphericalPolygonsSet coverage;
    private final TileAiming aiming;
    private final double alongGap;
    private final double acrossGap;
    private final Map<Long, Node> nodes;
    private int minAlongIndex;
    private int maxAlongIndex;
    private int minAcrossIndex;
    private int maxAcrossIndex;

    Mesh(OneAxisEllipsoid ellipsoid, SphericalPolygonsSet zone, TileAiming aiming, double alongGap, double acrossGap, S2Point start) {
        this.ellipsoid = ellipsoid;
        this.zone = zone;
        this.coverage = null;
        this.aiming = aiming;
        this.alongGap = alongGap;
        this.acrossGap = acrossGap;
        this.nodes = new HashMap<Long, Node>();
        this.minAlongIndex = 0;
        this.maxAlongIndex = 0;
        this.minAcrossIndex = 0;
        this.maxAcrossIndex = 0;
        for (GeodeticPoint singular : aiming.getSingularPoints()) {
            S2Point s2p = new S2Point(singular.getLongitude(), 1.5707963267948966 - singular.getLatitude());
            if (zone.checkPoint((Point)s2p) == Region.Location.OUTSIDE) continue;
            throw new OrekitException((Localizable)OrekitMessages.CANNOT_COMPUTE_AIMING_AT_SINGULAR_POINT, FastMath.toDegrees((double)singular.getLatitude()), FastMath.toDegrees((double)singular.getLongitude()));
        }
        Node origin = new Node(start, 0, 0);
        origin.setEnabled();
        origin.forceInside();
        this.store(origin);
    }

    public int getMinAlongIndex() {
        return this.minAlongIndex;
    }

    public int getMaxAlongIndex() {
        return this.maxAlongIndex;
    }

    public int getMinAlongIndex(int acrossIndex) {
        for (int alongIndex = this.minAlongIndex; alongIndex <= this.maxAlongIndex; ++alongIndex) {
            Node node = this.getNode(alongIndex, acrossIndex);
            if (node == null || !node.isEnabled()) continue;
            return alongIndex;
        }
        return this.maxAlongIndex + 1;
    }

    public int getMaxAlongIndex(int acrossIndex) {
        for (int alongIndex = this.maxAlongIndex; alongIndex >= this.minAlongIndex; --alongIndex) {
            Node node = this.getNode(alongIndex, acrossIndex);
            if (node == null || !node.isEnabled()) continue;
            return alongIndex;
        }
        return this.minAlongIndex - 1;
    }

    public int getMinAcrossIndex() {
        return this.minAcrossIndex;
    }

    public int getMaxAcrossIndex() {
        return this.maxAcrossIndex;
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public double getAlongGap() {
        return this.alongGap;
    }

    public double getAcrossGap() {
        return this.acrossGap;
    }

    public Node getNode(int alongIndex, int acrossIndex) {
        return this.nodes.get(this.key(alongIndex, acrossIndex));
    }

    public Node addNode(int alongIndex, int acrossIndex) {
        Node node = this.getExistingAncestor(alongIndex, acrossIndex);
        while (node.getAlongIndex() != alongIndex || node.getAcrossIndex() != acrossIndex) {
            Direction direction = node.getAlongIndex() < alongIndex ? Direction.PLUS_ALONG : (node.getAlongIndex() > alongIndex ? Direction.MINUS_ALONG : (node.getAcrossIndex() < acrossIndex ? Direction.PLUS_ACROSS : Direction.MINUS_ACROSS));
            S2Point s2p = node.move(direction.motion(node, this.alongGap, this.acrossGap));
            node = new Node(s2p, direction.neighborAlongIndex(node), direction.neighborAcrossIndex(node));
            this.store(node);
        }
        return node;
    }

    private Node getExistingAncestor(int alongIndex, int acrossIndex) {
        int l = alongIndex;
        int c = acrossIndex;
        Node node = this.getNode(l, c);
        while (node == null) {
            if (c != 0) {
                c += c > 0 ? -1 : 1;
            } else {
                l += l > 0 ? -1 : 1;
            }
            node = this.getNode(l, c);
        }
        return node;
    }

    public List<Node> getInsideNodes() {
        ArrayList<Node> insideNodes = new ArrayList<Node>();
        for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
            if (!entry.getValue().isInside()) continue;
            insideNodes.add(entry.getValue());
        }
        return insideNodes;
    }

    public Node getClosestExistingNode(int alongIndex, int acrossIndex) {
        int maxD = FastMath.max((int)FastMath.abs((int)alongIndex), (int)FastMath.abs((int)acrossIndex));
        for (int d = 0; d < maxD; ++d) {
            for (int deltaAcross = 0; deltaAcross <= d; ++deltaAcross) {
                int deltaAlong = d - deltaAcross;
                Node node = this.getNode(alongIndex - deltaAlong, acrossIndex - deltaAcross);
                if (node != null) {
                    return node;
                }
                if (deltaAcross != 0 && (node = this.getNode(alongIndex - deltaAlong, acrossIndex + deltaAcross)) != null) {
                    return node;
                }
                if (deltaAlong == 0) continue;
                node = this.getNode(alongIndex + deltaAlong, acrossIndex - deltaAcross);
                if (node != null) {
                    return node;
                }
                if (deltaAcross == 0 || (node = this.getNode(alongIndex + deltaAlong, acrossIndex + deltaAcross)) == null) continue;
                return node;
            }
        }
        return this.getNode(0, 0);
    }

    public Node getClosestExistingNode(Vector3D location) {
        Node selected = null;
        double min = Double.POSITIVE_INFINITY;
        for (Map.Entry<Long, Node> entry : this.nodes.entrySet()) {
            double distance = Vector3D.distance((Vector3D)location, (Vector3D)entry.getValue().getV());
            if (!(distance < min)) continue;
            selected = entry.getValue();
            min = distance;
        }
        return selected;
    }

    public List<Node> getTaxicabBoundary(boolean simplified) {
        ArrayList<Node> boundary = new ArrayList<Node>();
        if (this.nodes.size() < 2) {
            boundary.add(this.getNode(0, 0));
        } else {
            Node neighbor;
            Node lowerLeft = null;
            for (int i = this.minAlongIndex; lowerLeft == null && i <= this.maxAlongIndex; ++i) {
                for (int j = this.minAcrossIndex; lowerLeft == null && j <= this.maxAcrossIndex; ++j) {
                    lowerLeft = this.getNode(i, j);
                    if (lowerLeft == null || lowerLeft.isEnabled()) continue;
                    lowerLeft = null;
                }
            }
            Direction direction = Direction.MINUS_ACROSS;
            Node node = lowerLeft;
            do {
                boundary.add(node);
                neighbor = null;
                while ((neighbor = this.getNode((direction = direction.next()).neighborAlongIndex(node), direction.neighborAcrossIndex(node))) == null || !neighbor.isEnabled()) {
                }
                direction = direction.next().next();
            } while ((node = neighbor) != lowerLeft);
        }
        boolean changed = true;
        block4: while (changed && boundary.size() > 1) {
            changed = false;
            int n = boundary.size();
            for (int i = 0; i < n; ++i) {
                int previousIndex = (i + n - 1) % n;
                int nextIndex = (i + 1) % n;
                if (boundary.get(previousIndex) != boundary.get(nextIndex)) continue;
                boundary.remove(FastMath.max((int)i, (int)nextIndex));
                boundary.remove(FastMath.min((int)i, (int)nextIndex));
                changed = true;
                continue block4;
            }
        }
        if (simplified) {
            for (int i = 0; i < boundary.size(); ++i) {
                int n = boundary.size();
                Node previous = (Node)boundary.get((i + n - 1) % n);
                int pl = previous.getAlongIndex();
                int pc = previous.getAcrossIndex();
                Node current = (Node)boundary.get(i);
                int cl = current.getAlongIndex();
                int cc = current.getAcrossIndex();
                Node next = (Node)boundary.get((i + 1) % n);
                int nl = next.getAlongIndex();
                int nc = next.getAcrossIndex();
                if ((pl != cl || cl != nl) && (pc != cc || cc != nc)) continue;
                boundary.remove(i--);
            }
        }
        return boundary;
    }

    public SphericalPolygonsSet getCoverage() {
        if (this.coverage == null) {
            List<Node> boundary = this.getTaxicabBoundary(true);
            S2Point[] vertices = new S2Point[boundary.size()];
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = boundary.get(i).getS2P();
            }
            this.coverage = new SphericalPolygonsSet(this.zone.getTolerance(), vertices);
        }
        return (SphericalPolygonsSet)this.coverage.copySelf();
    }

    private void store(Node node) {
        this.coverage = null;
        this.nodes.put(this.key(node.alongIndex, node.acrossIndex), node);
    }

    private long key(int alongIndex, int acrossIndex) {
        return (long)alongIndex << 32 | (long)acrossIndex & 0xFFFFL;
    }

    public class Node {
        private final S2Point s2p;
        private final Vector3D v;
        private final Vector3D along;
        private final Vector3D across;
        private boolean insideZone;
        private final int alongIndex;
        private final int acrossIndex;
        private boolean enabled;

        private Node(S2Point s2p, int alongIndex, int acrossIndex) {
            GeodeticPoint gp = new GeodeticPoint(1.5707963267948966 - s2p.getPhi(), s2p.getTheta(), 0.0);
            this.v = Mesh.this.ellipsoid.transform(gp);
            this.s2p = s2p;
            this.along = Mesh.this.aiming.alongTileDirection(this.v, gp);
            this.across = Vector3D.crossProduct((Vector3D)this.v, (Vector3D)this.along).normalize();
            this.insideZone = Mesh.this.zone.checkPoint((Point)s2p) != Region.Location.OUTSIDE;
            this.alongIndex = alongIndex;
            this.acrossIndex = acrossIndex;
            this.enabled = false;
        }

        public void setEnabled() {
            this.enabled = true;
            Mesh.this.minAlongIndex = FastMath.min((int)Mesh.this.minAlongIndex, (int)this.alongIndex);
            Mesh.this.maxAlongIndex = FastMath.max((int)Mesh.this.maxAlongIndex, (int)this.alongIndex);
            Mesh.this.minAcrossIndex = FastMath.min((int)Mesh.this.minAcrossIndex, (int)this.acrossIndex);
            Mesh.this.maxAcrossIndex = FastMath.max((int)Mesh.this.maxAcrossIndex, (int)this.acrossIndex);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public S2Point getS2P() {
            return this.s2p;
        }

        public Vector3D getV() {
            return this.v;
        }

        public Vector3D getAlong() {
            return this.along;
        }

        public Vector3D getAcross() {
            return this.across;
        }

        private void forceInside() {
            this.insideZone = true;
        }

        public boolean isInside() {
            return this.insideZone;
        }

        public int getAlongIndex() {
            return this.alongIndex;
        }

        public int getAcrossIndex() {
            return this.acrossIndex;
        }

        public S2Point move(Vector3D motion) {
            if (motion.getNorm() < Precision.EPSILON * this.v.getNorm()) {
                return this.s2p;
            }
            Vector3D normal = Vector3D.crossProduct((Vector3D)this.v, (Vector3D)motion);
            Ellipse planeSection = Mesh.this.ellipsoid.getPlaneSection(this.v, normal);
            Vector2D omega2D = planeSection.getCenterOfCurvature(planeSection.toPlane(this.v));
            Vector3D omega3D = planeSection.toSpace(omega2D);
            Vector3D delta = this.v.subtract((Vector)omega3D);
            double theta = motion.getNorm() / delta.getNorm();
            SinCos sc = FastMath.sinCos((double)theta);
            Vector3D approximated = new Vector3D(1.0, omega3D, sc.cos(), delta, sc.sin() / theta, motion);
            GeodeticPoint approximatedGP = Mesh.this.ellipsoid.transform(approximated, Mesh.this.ellipsoid.getBodyFrame(), null);
            return new S2Point(approximatedGP.getLongitude(), 1.5707963267948966 - approximatedGP.getLatitude());
        }
    }
}

