/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import java.util.Collection;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.GeoMagneticField;
import org.orekit.models.earth.GeoMagneticFieldFactory;
import org.orekit.models.earth.GeoMagneticFields;
import org.orekit.models.earth.GeoMagneticModelLoader;

public class LazyLoadedGeoMagneticFields
implements GeoMagneticFields {
    private NavigableMap<Integer, GeoMagneticField> igrfModels = null;
    private NavigableMap<Integer, GeoMagneticField> wmmModels = null;
    private final DataProvidersManager dataProvidersManager;

    public LazyLoadedGeoMagneticFields(DataProvidersManager dataProvidersManager) {
        this.dataProvidersManager = dataProvidersManager;
    }

    @Override
    public GeoMagneticField getField(GeoMagneticFieldFactory.FieldModel type, double year) {
        switch (type) {
            case WMM: {
                return this.getWMM(year);
            }
            case IGRF: {
                return this.getIGRF(year);
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.NON_EXISTENT_GEOMAGNETIC_MODEL, type.name(), year);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeoMagneticField getIGRF(double year) {
        LazyLoadedGeoMagneticFields lazyLoadedGeoMagneticFields = this;
        synchronized (lazyLoadedGeoMagneticFields) {
            if (this.igrfModels == null) {
                this.igrfModels = this.loadModels("^IGRF\\.COF$");
            }
            return LazyLoadedGeoMagneticFields.getModel(GeoMagneticFieldFactory.FieldModel.IGRF, this.igrfModels, year);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeoMagneticField getWMM(double year) {
        LazyLoadedGeoMagneticFields lazyLoadedGeoMagneticFields = this;
        synchronized (lazyLoadedGeoMagneticFields) {
            if (this.wmmModels == null) {
                this.wmmModels = this.loadModels("^WMM\\.COF$");
            }
            return LazyLoadedGeoMagneticFields.getModel(GeoMagneticFieldFactory.FieldModel.WMM, this.wmmModels, year);
        }
    }

    private NavigableMap<Integer, GeoMagneticField> loadModels(String supportedNames) {
        Collection<GeoMagneticField> models;
        TreeMap<Integer, GeoMagneticField> loadedModels = null;
        GeoMagneticModelLoader loader = new GeoMagneticModelLoader();
        this.dataProvidersManager.feed(supportedNames, loader);
        if (!loader.stillAcceptsData() && (models = loader.getModels()) != null) {
            loadedModels = new TreeMap<Integer, GeoMagneticField>();
            for (GeoMagneticField model : models) {
                int epoch = (int)FastMath.round((double)(model.getEpoch() * 100.0));
                loadedModels.put(epoch, model);
            }
        }
        if (loadedModels == null || loadedModels.size() == 0) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_RESOURCE, supportedNames);
        }
        return loadedModels;
    }

    private static GeoMagneticField getModel(GeoMagneticFieldFactory.FieldModel type, NavigableMap<Integer, GeoMagneticField> models, double year) {
        int epochKey = (int)(year * 100.0);
        NavigableMap<Integer, GeoMagneticField> head = models.headMap(epochKey, true);
        if (head.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NON_EXISTENT_GEOMAGNETIC_MODEL, type.name(), year);
        }
        GeoMagneticField model = (GeoMagneticField)models.get(head.lastKey());
        if (model.getEpoch() < year) {
            if (model.supportsTimeTransform()) {
                model = model.transformModel(year);
            } else {
                NavigableMap<Integer, GeoMagneticField> tail = models.tailMap(epochKey, false);
                if (tail.isEmpty()) {
                    throw new OrekitException((Localizable)OrekitMessages.NON_EXISTENT_GEOMAGNETIC_MODEL, type.name(), year);
                }
                GeoMagneticField secondModel = (GeoMagneticField)models.get(tail.firstKey());
                if (secondModel != model) {
                    model = model.transformModel(secondModel, year);
                }
            }
        }
        return model;
    }
}

