/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.parser;

import java.util.Locale;
import org.orekit.gnss.metric.parser.DataField;
import org.orekit.gnss.metric.parser.DataType;
import org.orekit.gnss.metric.parser.EncodedMessage;
import org.orekit.gnss.metric.parser.Units;
import org.orekit.utils.units.Unit;

public enum IgsSsrDataField implements DataField
{
    IDF001{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_3.decode(message).intValue();
        }
    }
    ,
    IDF002{

        @Override
        public String stringValue(EncodedMessage message, int n) {
            return String.format(Locale.US, "%3s", DataType.U_INT_8.decode(message).intValue()).trim();
        }
    }
    ,
    IDF003{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_20.decode(message).intValue();
        }
    }
    ,
    IDF004{

        @Override
        public int intValue(EncodedMessage message) {
            switch (DataType.BIT_4.decode(message).byteValue()) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 5;
                }
                case 3: {
                    return 10;
                }
                case 4: {
                    return 15;
                }
                case 5: {
                    return 30;
                }
                case 6: {
                    return 60;
                }
                case 7: {
                    return 120;
                }
                case 8: {
                    return 240;
                }
                case 9: {
                    return 300;
                }
                case 10: {
                    return 600;
                }
                case 11: {
                    return 900;
                }
                case 12: {
                    return 1800;
                }
                case 13: {
                    return 3600;
                }
                case 14: {
                    return 7200;
                }
            }
            return 10800;
        }
    }
    ,
    IDF005{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    }
    ,
    IDF006{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    }
    ,
    IDF007{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_4.decode(message).intValue();
        }
    }
    ,
    IDF008{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_16.decode(message).intValue();
        }
    }
    ,
    IDF009{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_4.decode(message).intValue();
        }
    }
    ,
    IDF010{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_6.decode(message).intValue();
        }
    }
    ,
    IDF011{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_6.decode(message).intValue();
        }
    }
    ,
    IDF012{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_8.decode(message).intValue();
        }
    }
    ,
    IDF013{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.MM.toSI((double)DataType.INT_22.decode(message).intValue() * 0.1);
        }
    }
    ,
    IDF014{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.MM.toSI((double)DataType.INT_20.decode(message).intValue() * 0.4);
        }
    }
    ,
    IDF015{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.MM.toSI((double)DataType.INT_20.decode(message).intValue() * 0.4);
        }
    }
    ,
    IDF016{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.MM_PER_S.toSI((double)DataType.INT_21.decode(message).intValue() * 0.001);
        }
    }
    ,
    IDF017{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.MM_PER_S.toSI((double)DataType.INT_19.decode(message).intValue() * 0.004);
        }
    }
    ,
    IDF018{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.MM_PER_S.toSI((double)DataType.INT_19.decode(message).intValue() * 0.004);
        }
    }
    ,
    IDF019{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.MM.toSI((double)DataType.INT_22.decode(message).intValue() * 0.1);
        }
    }
    ,
    IDF020{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.MM_PER_S.toSI((double)DataType.INT_21.decode(message).intValue() * 0.001);
        }
    }
    ,
    IDF021{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.MM_PER_S2.toSI((double)DataType.INT_27.decode(message).intValue() * 2.0E-5);
        }
    }
    ,
    IDF022{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.MM.toSI((double)DataType.INT_22.decode(message).intValue() * 0.1);
        }
    }
    ,
    IDF023{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_5.decode(message).intValue();
        }
    }
    ,
    IDF024{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_5.decode(message).intValue();
        }
    }
    ,
    IDF025{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.INT_14.decode(message).intValue() * 0.01;
        }
    }
    ,
    IDF026{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI((double)DataType.U_INT_9.decode(message).intValue() / 256.0);
        }
    }
    ,
    IDF027{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI((double)DataType.INT_8.decode(message).intValue() / 8192.0);
        }
    }
    ,
    IDF028{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.INT_20.decode(message).intValue() * 1.0E-4;
        }
    }
    ,
    IDF029{

        @Override
        public boolean booleanValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message) > 0L;
        }
    }
    ,
    IDF030{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_2.decode(message).intValue();
        }
    }
    ,
    IDF031{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_4.decode(message).intValue();
        }
    }
    ,
    IDF032{

        @Override
        public boolean booleanValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message) > 0L;
        }
    }
    ,
    IDF033{

        @Override
        public boolean booleanValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message) > 0L;
        }
    }
    ,
    IDF034{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_6.decode(message).intValue();
        }
    }
    ,
    IDF035{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_2.decode(message).intValue() + 1;
        }
    }
    ,
    IDF036{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Unit.KILOMETRE.toSI((double)DataType.U_INT_8.decode(message).intValue() * 10.0);
        }
    }
    ,
    IDF037{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_4.decode(message).intValue() + 1;
        }
    }
    ,
    IDF038{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_4.decode(message).intValue() + 1;
        }
    }
    ,
    IDF039{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.INT_16.decode(message).intValue() * 0.005;
        }
    }
    ,
    IDF040{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.INT_16.decode(message).intValue() * 0.005;
        }
    }
    ,
    IDF041{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.U_INT_9.decode(message).intValue() * 0.05;
        }
    };

}

