/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.AbstractEopLoader;
import org.orekit.frames.AbstractEopParser;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EOPHistoryLoader;
import org.orekit.frames.EopParserLoader;
import org.orekit.frames.ITRFVersionLoader;
import org.orekit.frames.ItrfVersionProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.units.Unit;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class RapidDataAndPredictionXMLLoader
extends AbstractEopLoader
implements EOPHistoryLoader {
    private static final Unit MILLI_SECOND = Unit.parse("ms");
    private static final Unit MILLI_ARC_SECOND = Unit.parse("mas");

    RapidDataAndPredictionXMLLoader(String supportedNames, DataProvidersManager manager, Supplier<TimeScale> utcSupplier) {
        super(supportedNames, manager, utcSupplier);
    }

    @Override
    public void fillHistory(IERSConventions.NutationCorrectionConverter converter, SortedSet<EOPEntry> history) {
        ITRFVersionLoader itrfVersionProvider = new ITRFVersionLoader("itrf-versions.conf", this.getDataProvidersManager());
        Parser parser = new Parser(converter, itrfVersionProvider, this.getUtc());
        EopParserLoader loader = new EopParserLoader(parser);
        this.feed(loader);
        history.addAll(loader.getEop());
    }

    private static enum DataFileContent {
        UNKNOWN,
        DAILY,
        FINAL;

    }

    static class Parser
    extends AbstractEopParser {
        private List<EOPEntry> history;

        Parser(IERSConventions.NutationCorrectionConverter converter, ItrfVersionProvider itrfVersionProvider, TimeScale utc) {
            super(converter, itrfVersionProvider, utc);
        }

        @Override
        public Collection<EOPEntry> parse(InputStream input, String name) throws IOException, OrekitException {
            try {
                this.history = new ArrayList<EOPEntry>();
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(new InputSource(new InputStreamReader(input, StandardCharsets.UTF_8)), (DefaultHandler)new EOPContentHandler(name));
                return this.history;
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getMessage());
            }
        }

        private class EOPContentHandler
        extends DefaultHandler {
            private static final String MJD_ELT = "MJD";
            private static final String LOD_ELT = "LOD";
            private static final String X_ELT = "X";
            private static final String Y_ELT = "Y";
            private static final String DPSI_ELT = "dPsi";
            private static final String DEPSILON_ELT = "dEpsilon";
            private static final String DX_ELT = "dX";
            private static final String DY_ELT = "dY";
            private static final String DATA_EOP_ELT = "dataEOP";
            private static final String TIME_SERIES_ELT = "timeSeries";
            private static final String DATE_YEAR_ELT = "dateYear";
            private static final String DATE_MONTH_ELT = "dateMonth";
            private static final String DATE_DAY_ELT = "dateDay";
            private static final String POLE_ELT = "pole";
            private static final String UT_ELT = "UT";
            private static final String UT1_U_UTC_ELT = "UT1_UTC";
            private static final String NUTATION_ELT = "nutation";
            private static final String SOURCE_ATTR = "source";
            private static final String BULLETIN_A_SOURCE = "BulletinA";
            private static final String FINALS_ELT = "Finals";
            private static final String DATE_ELT = "date";
            private static final String EOP_SET_ELT = "EOPSet";
            private static final String BULLETIN_A_ELT = "bulletinA";
            private static final String UT1_M_UTC_ELT = "UT1-UTC";
            private boolean inBulletinA;
            private int year;
            private int month;
            private int day;
            private int mjd;
            private AbsoluteDate mjdDate;
            private double dtu1;
            private double lod;
            private double x;
            private double y;
            private double dpsi;
            private double deps;
            private double dx;
            private double dy;
            private final String name;
            private final StringBuilder buffer;
            private DataFileContent content;
            private ITRFVersionLoader.ITRFVersionConfiguration configuration;

            EOPContentHandler(String name) {
                this.name = name;
                this.buffer = new StringBuilder();
            }

            @Override
            public void startDocument() {
                this.content = DataFileContent.UNKNOWN;
                this.configuration = null;
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                this.buffer.append(ch, start, length);
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes atts) {
                this.buffer.delete(0, this.buffer.length());
                if (this.content == DataFileContent.UNKNOWN) {
                    if (qName.equals(TIME_SERIES_ELT)) {
                        this.content = DataFileContent.DAILY;
                    } else if (qName.equals(FINALS_ELT)) {
                        this.content = DataFileContent.FINAL;
                    }
                }
                if (this.content == DataFileContent.DAILY) {
                    this.startDailyElement(qName, atts);
                } else if (this.content == DataFileContent.FINAL) {
                    this.startFinalElement(qName);
                }
            }

            private void startDailyElement(String qName, Attributes atts) {
                String source;
                if (qName.equals(TIME_SERIES_ELT)) {
                    this.resetEOPData();
                } else if ((qName.equals(POLE_ELT) || qName.equals(UT_ELT) || qName.equals(NUTATION_ELT)) && (source = atts.getValue(SOURCE_ATTR)) != null) {
                    this.inBulletinA = source.equals(BULLETIN_A_SOURCE);
                }
            }

            private void startFinalElement(String qName) {
                if (qName.equals(EOP_SET_ELT)) {
                    this.resetEOPData();
                } else if (qName.equals(BULLETIN_A_ELT)) {
                    this.inBulletinA = true;
                }
            }

            private void resetEOPData() {
                this.inBulletinA = false;
                this.year = -1;
                this.month = -1;
                this.day = -1;
                this.mjd = -1;
                this.mjdDate = null;
                this.dtu1 = Double.NaN;
                this.lod = Double.NaN;
                this.x = Double.NaN;
                this.y = Double.NaN;
                this.dpsi = Double.NaN;
                this.deps = Double.NaN;
                this.dx = Double.NaN;
                this.dy = Double.NaN;
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                if (this.content == DataFileContent.DAILY) {
                    this.endDailyElement(qName);
                } else if (this.content == DataFileContent.FINAL) {
                    this.endFinalElement(qName);
                }
            }

            private void endDailyElement(String qName) {
                if (qName.equals(DATE_YEAR_ELT) && this.buffer.length() > 0) {
                    this.year = Integer.parseInt(this.buffer.toString());
                } else if (qName.equals(DATE_MONTH_ELT) && this.buffer.length() > 0) {
                    this.month = Integer.parseInt(this.buffer.toString());
                } else if (qName.equals(DATE_DAY_ELT) && this.buffer.length() > 0) {
                    this.day = Integer.parseInt(this.buffer.toString());
                } else if (qName.equals(MJD_ELT) && this.buffer.length() > 0) {
                    this.mjd = Integer.parseInt(this.buffer.toString());
                    this.mjdDate = new AbsoluteDate(new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, this.mjd), Parser.this.getUtc());
                } else if (qName.equals(UT1_M_UTC_ELT)) {
                    this.dtu1 = this.overwrite(this.dtu1, Unit.SECOND);
                } else if (qName.equals(LOD_ELT)) {
                    this.lod = this.overwrite(this.lod, MILLI_SECOND);
                } else if (qName.equals(X_ELT)) {
                    this.x = this.overwrite(this.x, Unit.ARC_SECOND);
                } else if (qName.equals(Y_ELT)) {
                    this.y = this.overwrite(this.y, Unit.ARC_SECOND);
                } else if (qName.equals(DPSI_ELT)) {
                    this.dpsi = this.overwrite(this.dpsi, MILLI_ARC_SECOND);
                } else if (qName.equals(DEPSILON_ELT)) {
                    this.deps = this.overwrite(this.deps, MILLI_ARC_SECOND);
                } else if (qName.equals(DX_ELT)) {
                    this.dx = this.overwrite(this.dx, MILLI_ARC_SECOND);
                } else if (qName.equals(DY_ELT)) {
                    this.dy = this.overwrite(this.dy, MILLI_ARC_SECOND);
                } else if (qName.equals(POLE_ELT) || qName.equals(UT_ELT) || qName.equals(NUTATION_ELT)) {
                    this.inBulletinA = false;
                } else if (qName.equals(DATA_EOP_ELT)) {
                    this.checkDates();
                    if (!(Double.isNaN(this.dtu1) || Double.isNaN(this.lod) || Double.isNaN(this.x) || Double.isNaN(this.y))) {
                        double[] equinox;
                        double[] nro;
                        if (Double.isNaN(this.dpsi)) {
                            nro = new double[]{this.dx, this.dy};
                            equinox = Parser.this.getConverter().toEquinox(this.mjdDate, nro[0], nro[1]);
                        } else {
                            equinox = new double[]{this.dpsi, this.deps};
                            nro = Parser.this.getConverter().toNonRotating(this.mjdDate, equinox[0], equinox[1]);
                        }
                        if (this.configuration == null || !this.configuration.isValid(this.mjd)) {
                            this.configuration = Parser.this.getItrfVersionProvider().getConfiguration(this.name, this.mjd);
                        }
                        Parser.this.history.add(new EOPEntry(this.mjd, this.dtu1, this.lod, this.x, this.y, equinox[0], equinox[1], nro[0], nro[1], this.configuration.getVersion(), this.mjdDate));
                    }
                }
            }

            private void endFinalElement(String qName) {
                if (qName.equals(DATE_ELT) && this.buffer.length() > 0) {
                    String[] fields = this.buffer.toString().split("-");
                    if (fields.length == 3) {
                        this.year = Integer.parseInt(fields[0]);
                        this.month = Integer.parseInt(fields[1]);
                        this.day = Integer.parseInt(fields[2]);
                    }
                } else if (qName.equals(MJD_ELT) && this.buffer.length() > 0) {
                    this.mjd = Integer.parseInt(this.buffer.toString());
                    this.mjdDate = new AbsoluteDate(new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, this.mjd), Parser.this.getUtc());
                } else if (qName.equals(UT1_U_UTC_ELT)) {
                    this.dtu1 = this.overwrite(this.dtu1, Unit.SECOND);
                } else if (qName.equals(LOD_ELT)) {
                    this.lod = this.overwrite(this.lod, MILLI_SECOND);
                } else if (qName.equals(X_ELT)) {
                    this.x = this.overwrite(this.x, Unit.ARC_SECOND);
                } else if (qName.equals(Y_ELT)) {
                    this.y = this.overwrite(this.y, Unit.ARC_SECOND);
                } else if (qName.equals(DPSI_ELT)) {
                    this.dpsi = this.overwrite(this.dpsi, MILLI_ARC_SECOND);
                } else if (qName.equals(DEPSILON_ELT)) {
                    this.deps = this.overwrite(this.deps, MILLI_ARC_SECOND);
                } else if (qName.equals(DX_ELT)) {
                    this.dx = this.overwrite(this.dx, MILLI_ARC_SECOND);
                } else if (qName.equals(DY_ELT)) {
                    this.dy = this.overwrite(this.dy, MILLI_ARC_SECOND);
                } else if (qName.equals(BULLETIN_A_ELT)) {
                    this.inBulletinA = false;
                } else if (qName.equals(EOP_SET_ELT)) {
                    this.checkDates();
                    if (!(Double.isNaN(this.dtu1) || Double.isNaN(this.lod) || Double.isNaN(this.x) || Double.isNaN(this.y))) {
                        double[] equinox;
                        double[] nro;
                        if (Double.isNaN(this.dpsi)) {
                            nro = new double[]{this.dx, this.dy};
                            equinox = Parser.this.getConverter().toEquinox(this.mjdDate, nro[0], nro[1]);
                        } else {
                            equinox = new double[]{this.dpsi, this.deps};
                            nro = Parser.this.getConverter().toNonRotating(this.mjdDate, equinox[0], equinox[1]);
                        }
                        if (this.configuration == null || !this.configuration.isValid(this.mjd)) {
                            this.configuration = Parser.this.getItrfVersionProvider().getConfiguration(this.name, this.mjd);
                        }
                        Parser.this.history.add(new EOPEntry(this.mjd, this.dtu1, this.lod, this.x, this.y, equinox[0], equinox[1], nro[0], nro[1], this.configuration.getVersion(), this.mjdDate));
                    }
                }
            }

            private double overwrite(double oldValue, Unit units) {
                if (this.buffer.length() == 0) {
                    return oldValue;
                }
                if (this.inBulletinA && !Double.isNaN(oldValue)) {
                    return oldValue;
                }
                return units.toSI(Double.parseDouble(this.buffer.toString()));
            }

            private void checkDates() {
                if (new DateComponents(this.year, this.month, this.day).getMJD() != this.mjd) {
                    throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_DATES_IN_IERS_FILE, this.name, this.year, this.month, this.day, this.mjd);
                }
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource();
            }
        }
    }
}

