/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.EOPBasedTransformProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeVectorFunction;

class CIRFProvider
implements EOPBasedTransformProvider {
    private static final long serialVersionUID = 20130806L;
    private final transient TimeVectorFunction xysPxy2Function;
    private final EOPHistory eopHistory;

    CIRFProvider(EOPHistory eopHistory) {
        this.xysPxy2Function = eopHistory.getConventions().getXYSpXY2Function(eopHistory.getTimeScales());
        this.eopHistory = eopHistory;
    }

    @Override
    public EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public CIRFProvider getNonInterpolatingProvider() {
        return new CIRFProvider(this.eopHistory.getNonInterpolatingEOPHistory());
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        double[] xys = this.xysPxy2Function.value(date);
        double[] dxdy = this.eopHistory.getNonRotatinOriginNutationCorrection(date);
        double xCurrent = xys[0] + dxdy[0];
        double yCurrent = xys[1] + dxdy[1];
        double sCurrent = xys[2] - xCurrent * yCurrent / 2.0;
        double x2Py2 = xCurrent * xCurrent + yCurrent * yCurrent;
        double zP1 = 1.0 + FastMath.sqrt((double)(1.0 - x2Py2));
        double r = FastMath.sqrt((double)x2Py2);
        double sPe2 = 0.5 * (sCurrent + FastMath.atan2((double)yCurrent, (double)xCurrent));
        SinCos sc = FastMath.sinCos((double)sPe2);
        double xPr = xCurrent + r;
        double xPrCos = xPr * sc.cos();
        double xPrSin = xPr * sc.sin();
        double yCos = yCurrent * sc.cos();
        double ySin = yCurrent * sc.sin();
        Rotation bpn = new Rotation(zP1 * (xPrCos + ySin), -r * (yCos + xPrSin), r * (xPrCos - ySin), zP1 * (yCos - xPrSin), true);
        return new Transform(date, bpn, Vector3D.ZERO);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        CalculusFieldElement[] xys = this.xysPxy2Function.value(date);
        CalculusFieldElement[] dxdy = this.eopHistory.getNonRotatinOriginNutationCorrection(date);
        CalculusFieldElement xCurrent = (CalculusFieldElement)xys[0].add((FieldElement)dxdy[0]);
        CalculusFieldElement yCurrent = (CalculusFieldElement)xys[1].add((FieldElement)dxdy[1]);
        CalculusFieldElement sCurrent = (CalculusFieldElement)xys[2].subtract(((CalculusFieldElement)xCurrent.multiply((FieldElement)yCurrent)).multiply(0.5));
        CalculusFieldElement x2Py2 = (CalculusFieldElement)((CalculusFieldElement)xCurrent.multiply((FieldElement)xCurrent)).add(yCurrent.multiply((FieldElement)yCurrent));
        CalculusFieldElement zP1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x2Py2.subtract(1.0)).negate()).sqrt()).add(1.0);
        CalculusFieldElement r = (CalculusFieldElement)x2Py2.sqrt();
        CalculusFieldElement sPe2 = (CalculusFieldElement)((CalculusFieldElement)sCurrent.add(yCurrent.atan2((FieldElement)xCurrent))).multiply(0.5);
        FieldSinCos sc = FastMath.sinCos((CalculusFieldElement)sPe2);
        CalculusFieldElement xPr = (CalculusFieldElement)xCurrent.add((FieldElement)r);
        CalculusFieldElement xPrCos = (CalculusFieldElement)xPr.multiply((FieldElement)sc.cos());
        CalculusFieldElement xPrSin = (CalculusFieldElement)xPr.multiply((FieldElement)sc.sin());
        CalculusFieldElement yCos = (CalculusFieldElement)yCurrent.multiply((FieldElement)sc.cos());
        CalculusFieldElement ySin = (CalculusFieldElement)yCurrent.multiply((FieldElement)sc.sin());
        FieldRotation bpn = new FieldRotation((CalculusFieldElement)zP1.multiply(xPrCos.add((FieldElement)ySin)), (CalculusFieldElement)((CalculusFieldElement)r.multiply(yCos.add((FieldElement)xPrSin))).negate(), (CalculusFieldElement)r.multiply(xPrCos.subtract((FieldElement)ySin)), (CalculusFieldElement)zP1.multiply(yCos.subtract((FieldElement)xPrSin)), true);
        return new FieldTransform<T>(date, bpn, FieldVector3D.getZero(date.getField()));
    }

    private Object writeReplace() {
        return new DataTransferObject(this.eopHistory);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final EOPHistory eopHistory;

        DataTransferObject(EOPHistory eopHistory) {
            this.eopHistory = eopHistory;
        }

        private Object readResolve() {
            try {
                return new CIRFProvider(this.eopHistory);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

