/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Precision;
import org.orekit.forces.radiation.AbstractRadiationForceModel;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class SolarRadiationPressure
extends AbstractRadiationForceModel {
    private static final double D_REF = 1.4959787E11;
    private static final double P_REF = 4.56E-6;
    private static final double ANGULAR_MARGIN = 1.0E-10;
    private final double kRef;
    private final ExtendedPVCoordinatesProvider sun;
    private final RadiationSensitive spacecraft;

    public SolarRadiationPressure(ExtendedPVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft) {
        this(1.4959787E11, 4.56E-6, sun, equatorialRadius, spacecraft);
    }

    public SolarRadiationPressure(double dRef, double pRef, ExtendedPVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft) {
        super(sun, equatorialRadius);
        this.kRef = pRef * dRef * dRef;
        this.sun = sun;
        this.spacecraft = spacecraft;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        AbsoluteDate date = s.getDate();
        Frame frame = s.getFrame();
        Vector3D position = s.getPVCoordinates().getPosition();
        Vector3D sunSatVector = position.subtract((Vector)this.sun.getPVCoordinates(date, frame).getPosition());
        double r2 = sunSatVector.getNormSq();
        double ratio = this.getTotalLightingRatio(position, frame, date);
        double rawP = ratio * this.kRef / r2;
        Vector3D flux = new Vector3D(rawP / FastMath.sqrt((double)r2), sunSatVector);
        return this.spacecraft.radiationPressureAcceleration(date, frame, position, s.getAttitude().getRotation(), s.getMass(), flux, parameters);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        FieldAbsoluteDate<T> date = s.getDate();
        Frame frame = s.getFrame();
        FieldVector3D position = s.getPVCoordinates().getPosition();
        FieldVector3D sunSatVector = position.subtract(this.sun.getPVCoordinates(date, frame).getPosition());
        CalculusFieldElement r2 = sunSatVector.getNormSq();
        Object ratio = this.getTotalLightingRatio(position, frame, date);
        CalculusFieldElement rawP = (CalculusFieldElement)((CalculusFieldElement)ratio.multiply(this.kRef)).divide((FieldElement)r2);
        FieldVector3D flux = new FieldVector3D((CalculusFieldElement)rawP.divide(r2.sqrt()), sunSatVector);
        return this.spacecraft.radiationPressureAcceleration(date, frame, position, (FieldRotation)s.getAttitude().getRotation(), (CalculusFieldElement)s.getMass(), flux, (CalculusFieldElement[])parameters);
    }

    public double getLightingRatio(Vector3D position, Frame frame, AbsoluteDate date) {
        Vector3D sunPosition = this.sun.getPVCoordinates(date, frame).getPosition();
        if (sunPosition.getNorm() < 1.391E9) {
            return 1.0;
        }
        double[] angle = this.getEclipseAngles(sunPosition, position);
        double sunSatCentralBodyAngle = angle[0];
        double alphaCentral = angle[1];
        double alphaSun = angle[2];
        double result = 1.0;
        if (sunSatCentralBodyAngle - alphaCentral + alphaSun <= 1.0E-10) {
            result = 0.0;
        } else if (sunSatCentralBodyAngle - alphaCentral - alphaSun < -1.0E-10) {
            double sEA2 = sunSatCentralBodyAngle * sunSatCentralBodyAngle;
            double oo2sEA = 1.0 / (2.0 * sunSatCentralBodyAngle);
            double aS2 = alphaSun * alphaSun;
            double aE2 = alphaCentral * alphaCentral;
            double aE2maS2 = aE2 - aS2;
            double alpha1 = (sEA2 - aE2maS2) * oo2sEA;
            double alpha2 = (sEA2 + aE2maS2) * oo2sEA;
            double almost0 = Precision.SAFE_MIN;
            double almost1 = FastMath.nextDown((double)1.0);
            double a1oaS = FastMath.min((double)almost1, (double)FastMath.max((double)(-almost1), (double)(alpha1 / alphaSun)));
            double aS2ma12 = FastMath.max((double)almost0, (double)(aS2 - alpha1 * alpha1));
            double a2oaE = FastMath.min((double)almost1, (double)FastMath.max((double)(-almost1), (double)(alpha2 / alphaCentral)));
            double aE2ma22 = FastMath.max((double)almost0, (double)(aE2 - alpha2 * alpha2));
            double P1 = aS2 * FastMath.acos((double)a1oaS) - alpha1 * FastMath.sqrt((double)aS2ma12);
            double P2 = aE2 * FastMath.acos((double)a2oaE) - alpha2 * FastMath.sqrt((double)aE2ma22);
            result = 1.0 - (P1 + P2) / (Math.PI * aS2);
        }
        return result;
    }

    public double getGeneralEclipseRatio(Vector3D position, Vector3D occultingPosition, double occultingRadius, Vector3D occultedPosition, double occultedRadius) {
        double[] angle = this.getGeneralEclipseAngles(position, occultingPosition, occultingRadius, occultedPosition, occultedRadius);
        double occultedSatOcculting = angle[0];
        double alphaOcculting = angle[1];
        double alphaOcculted = angle[2];
        double result = 1.0;
        if (occultedSatOcculting - alphaOcculting + alphaOcculted <= 1.0E-10) {
            result = 0.0;
        } else if (occultedSatOcculting - alphaOcculting - alphaOcculted < -1.0E-10) {
            double sEA2 = occultedSatOcculting * occultedSatOcculting;
            double oo2sEA = 1.0 / (2.0 * occultedSatOcculting);
            double aS2 = alphaOcculted * alphaOcculted;
            double aE2 = alphaOcculting * alphaOcculting;
            double aE2maS2 = aE2 - aS2;
            double alpha1 = (sEA2 - aE2maS2) * oo2sEA;
            double alpha2 = (sEA2 + aE2maS2) * oo2sEA;
            double almost0 = Precision.SAFE_MIN;
            double almost1 = FastMath.nextDown((double)1.0);
            double a1oaS = FastMath.min((double)almost1, (double)FastMath.max((double)(-almost1), (double)(alpha1 / alphaOcculted)));
            double aS2ma12 = FastMath.max((double)almost0, (double)(aS2 - alpha1 * alpha1));
            double a2oaE = FastMath.min((double)almost1, (double)FastMath.max((double)(-almost1), (double)(alpha2 / alphaOcculting)));
            double aE2ma22 = FastMath.max((double)almost0, (double)(aE2 - alpha2 * alpha2));
            double P1 = aS2 * FastMath.acos((double)a1oaS) - alpha1 * FastMath.sqrt((double)aS2ma12);
            double P2 = aE2 * FastMath.acos((double)a2oaE) - alpha2 * FastMath.sqrt((double)aE2ma22);
            result = 1.0 - (P1 + P2) / (Math.PI * aS2);
        }
        return result;
    }

    public double getTotalLightingRatio(Vector3D position, Frame frame, AbsoluteDate date) {
        double result = 0.0;
        Map<ExtendedPVCoordinatesProvider, Double> otherOccultingBodies = this.getOtherOccultingBodies();
        Vector3D sunPosition = this.sun.getPVCoordinates(date, frame).getPosition();
        int n = otherOccultingBodies.size() + 1;
        if (n > 1) {
            Vector3D[] occultingBodyPositions = new Vector3D[n];
            double[] occultingBodyRadiuses = new double[n];
            occultingBodyPositions[0] = new Vector3D(0.0, 0.0, 0.0);
            occultingBodyRadiuses[0] = this.getEquatorialRadius();
            int k = 1;
            for (Map.Entry<ExtendedPVCoordinatesProvider, Double> entry : otherOccultingBodies.entrySet()) {
                occultingBodyPositions[k] = entry.getKey().getPVCoordinates(date, frame).getPosition();
                occultingBodyRadiuses[k] = entry.getValue();
                ++k;
            }
            for (int i = 0; i < n; ++i) {
                double eclipseRatioI = this.getGeneralEclipseRatio(position, occultingBodyPositions[i], occultingBodyRadiuses[i], sunPosition, 6.955E8);
                if (eclipseRatioI == 0.0) {
                    return 0.0;
                }
                result += eclipseRatioI;
                for (int j = i + 1; j < n; ++j) {
                    double eclipseRatioJ = this.getGeneralEclipseRatio(position, occultingBodyPositions[j], occultingBodyRadiuses[j], sunPosition, 6.955E8);
                    double eclipseRatioIJ = this.getGeneralEclipseRatio(position, occultingBodyPositions[i], occultingBodyRadiuses[i], occultingBodyPositions[j], occultingBodyRadiuses[j]);
                    double alphaJ = this.getGeneralEclipseAngles(position, occultingBodyPositions[i], occultingBodyRadiuses[i], occultingBodyPositions[j], occultingBodyRadiuses[j])[2];
                    double alphaSun = this.getEclipseAngles(sunPosition, position)[2];
                    double alphaJSq = alphaJ * alphaJ;
                    double alphaSunSq = alphaSun * alphaSun;
                    double mutualEclipseCorrection = (1.0 - eclipseRatioIJ) * alphaJSq / alphaSunSq;
                    if (eclipseRatioJ == 0.0) {
                        return 0.0;
                    }
                    if (eclipseRatioJ == 1.0) continue;
                    result -= mutualEclipseCorrection;
                }
            }
            result -= (double)(n - 1);
        } else {
            result = this.getLightingRatio(position, frame, date);
        }
        return result;
    }

    public <T extends CalculusFieldElement<T>> T getLightingRatio(FieldVector3D<T> position, Frame frame, FieldAbsoluteDate<T> date) {
        CalculusFieldElement one = (CalculusFieldElement)date.getField().getOne();
        FieldVector3D sunPosition = this.sun.getPVCoordinates(date, frame).getPosition();
        if (sunPosition.getNorm().getReal() < 1.391E9) {
            return (T)one;
        }
        CalculusFieldElement[] angle = this.getEclipseAngles(sunPosition, position);
        CalculusFieldElement sunsatCentralBodyAngle = angle[0];
        CalculusFieldElement alphaCentral = angle[1];
        CalculusFieldElement alphaSun = angle[2];
        CalculusFieldElement result = one;
        if (sunsatCentralBodyAngle.getReal() - alphaCentral.getReal() + alphaSun.getReal() <= 1.0E-10) {
            result = (CalculusFieldElement)date.getField().getZero();
        } else if (sunsatCentralBodyAngle.getReal() - alphaCentral.getReal() - alphaSun.getReal() < -1.0E-10) {
            CalculusFieldElement sEA2 = (CalculusFieldElement)sunsatCentralBodyAngle.multiply((FieldElement)sunsatCentralBodyAngle);
            CalculusFieldElement oo2sEA = (CalculusFieldElement)((CalculusFieldElement)sunsatCentralBodyAngle.multiply(2)).reciprocal();
            CalculusFieldElement aS2 = (CalculusFieldElement)alphaSun.multiply((FieldElement)alphaSun);
            CalculusFieldElement aE2 = (CalculusFieldElement)alphaCentral.multiply((FieldElement)alphaCentral);
            CalculusFieldElement aE2maS2 = (CalculusFieldElement)aE2.subtract((FieldElement)aS2);
            CalculusFieldElement alpha1 = (CalculusFieldElement)((CalculusFieldElement)sEA2.subtract((FieldElement)aE2maS2)).multiply((FieldElement)oo2sEA);
            CalculusFieldElement alpha2 = (CalculusFieldElement)((CalculusFieldElement)sEA2.add((FieldElement)aE2maS2)).multiply((FieldElement)oo2sEA);
            double almost0 = Precision.SAFE_MIN;
            double almost1 = FastMath.nextDown((double)1.0);
            CalculusFieldElement a1oaS = this.min(almost1, this.max(-almost1, (CalculusFieldElement)alpha1.divide((FieldElement)alphaSun)));
            CalculusFieldElement aS2ma12 = this.max(almost0, (CalculusFieldElement)aS2.subtract(alpha1.multiply((FieldElement)alpha1)));
            CalculusFieldElement a2oaE = this.min(almost1, this.max(-almost1, (CalculusFieldElement)alpha2.divide((FieldElement)alphaCentral)));
            CalculusFieldElement aE2ma22 = this.max(almost0, (CalculusFieldElement)aE2.subtract(alpha2.multiply((FieldElement)alpha2)));
            CalculusFieldElement P1 = (CalculusFieldElement)((CalculusFieldElement)aS2.multiply(a1oaS.acos())).subtract(alpha1.multiply(aS2ma12.sqrt()));
            CalculusFieldElement P2 = (CalculusFieldElement)((CalculusFieldElement)aE2.multiply(a2oaE.acos())).subtract(alpha2.multiply(aE2ma22.sqrt()));
            result = (CalculusFieldElement)one.subtract(((CalculusFieldElement)P1.add((FieldElement)P2)).divide(aS2.multiply(one.getPi())));
        }
        return (T)result;
    }

    public <T extends CalculusFieldElement<T>> T getGeneralEclipseRatio(FieldVector3D<T> position, FieldVector3D<T> occultingPosition, T occultingRadius, FieldVector3D<T> occultedPosition, T occultedRadius) {
        CalculusFieldElement one = (CalculusFieldElement)occultingRadius.getField().getOne();
        CalculusFieldElement[] angle = this.getGeneralEclipseAngles(position, occultingPosition, occultingRadius, occultedPosition, occultedRadius);
        CalculusFieldElement occultedSatOcculting = angle[0];
        CalculusFieldElement alphaOcculting = angle[1];
        CalculusFieldElement alphaOcculted = angle[2];
        CalculusFieldElement result = one;
        if (occultedSatOcculting.getReal() - alphaOcculting.getReal() + alphaOcculted.getReal() <= 1.0E-10) {
            result = (CalculusFieldElement)occultingRadius.getField().getZero();
        } else if (occultedSatOcculting.getReal() - alphaOcculting.getReal() - alphaOcculted.getReal() < -1.0E-10) {
            CalculusFieldElement sEA2 = (CalculusFieldElement)occultedSatOcculting.multiply((FieldElement)occultedSatOcculting);
            CalculusFieldElement oo2sEA = (CalculusFieldElement)((CalculusFieldElement)occultedSatOcculting.multiply(2)).reciprocal();
            CalculusFieldElement aS2 = (CalculusFieldElement)alphaOcculted.multiply((FieldElement)alphaOcculted);
            CalculusFieldElement aE2 = (CalculusFieldElement)alphaOcculting.multiply((FieldElement)alphaOcculting);
            CalculusFieldElement aE2maS2 = (CalculusFieldElement)aE2.subtract((FieldElement)aS2);
            CalculusFieldElement alpha1 = (CalculusFieldElement)((CalculusFieldElement)sEA2.subtract((FieldElement)aE2maS2)).multiply((FieldElement)oo2sEA);
            CalculusFieldElement alpha2 = (CalculusFieldElement)((CalculusFieldElement)sEA2.add((FieldElement)aE2maS2)).multiply((FieldElement)oo2sEA);
            double almost0 = Precision.SAFE_MIN;
            double almost1 = FastMath.nextDown((double)1.0);
            CalculusFieldElement a1oaS = this.min(almost1, this.max(-almost1, (CalculusFieldElement)alpha1.divide((FieldElement)alphaOcculted)));
            CalculusFieldElement aS2ma12 = this.max(almost0, (CalculusFieldElement)aS2.subtract(alpha1.multiply((FieldElement)alpha1)));
            CalculusFieldElement a2oaE = this.min(almost1, this.max(-almost1, (CalculusFieldElement)alpha2.divide((FieldElement)alphaOcculting)));
            CalculusFieldElement aE2ma22 = this.max(almost0, (CalculusFieldElement)aE2.subtract(alpha2.multiply((FieldElement)alpha2)));
            CalculusFieldElement P1 = (CalculusFieldElement)((CalculusFieldElement)aS2.multiply(a1oaS.acos())).subtract(alpha1.multiply(aS2ma12.sqrt()));
            CalculusFieldElement P2 = (CalculusFieldElement)((CalculusFieldElement)aE2.multiply(a2oaE.acos())).subtract(alpha2.multiply(aE2ma22.sqrt()));
            result = (CalculusFieldElement)one.subtract(((CalculusFieldElement)P1.add((FieldElement)P2)).divide(aS2.multiply(one.getPi())));
        }
        return (T)result;
    }

    public <T extends CalculusFieldElement<T>> T getTotalLightingRatio(FieldVector3D<T> position, Frame frame, FieldAbsoluteDate<T> date) {
        CalculusFieldElement zero;
        Object result = zero = (CalculusFieldElement)position.getAlpha().getField().getZero();
        Map<ExtendedPVCoordinatesProvider, Double> otherOccultingBodies = this.getOtherOccultingBodies();
        FieldVector3D sunPosition = this.sun.getPVCoordinates(date, frame).getPosition();
        int n = otherOccultingBodies.size() + 1;
        if (n > 1) {
            ArrayList<Object> occultingBodyPositions = new ArrayList<Object>(n);
            CalculusFieldElement[] occultingBodyRadiuses = (CalculusFieldElement[])MathArrays.buildArray((Field)zero.getField(), (int)n);
            occultingBodyPositions.add(0, new FieldVector3D(zero, zero, zero));
            occultingBodyRadiuses[0] = (CalculusFieldElement)zero.add(this.getEquatorialRadius());
            int k = 1;
            for (Map.Entry<ExtendedPVCoordinatesProvider, Double> entry : otherOccultingBodies.entrySet()) {
                occultingBodyPositions.add(k, entry.getKey().getPVCoordinates(date, frame).getPosition());
                occultingBodyRadiuses[k] = (CalculusFieldElement)zero.newInstance(entry.getValue().doubleValue());
                ++k;
            }
            for (int i = 0; i < n; ++i) {
                CalculusFieldElement eclipseRatioI = this.getGeneralEclipseRatio(position, (FieldVector3D)occultingBodyPositions.get(i), occultingBodyRadiuses[i], sunPosition, (CalculusFieldElement)zero.add(6.955E8));
                if (eclipseRatioI.getReal() == 0.0) {
                    return (T)zero;
                }
                result = (CalculusFieldElement)result.add((FieldElement)eclipseRatioI);
                for (int j = i + 1; j < n; ++j) {
                    CalculusFieldElement eclipseRatioJ = this.getGeneralEclipseRatio(position, (FieldVector3D)occultingBodyPositions.get(i), occultingBodyRadiuses[j], sunPosition, (CalculusFieldElement)zero.add(6.955E8));
                    CalculusFieldElement eclipseRatioIJ = this.getGeneralEclipseRatio(position, (FieldVector3D)occultingBodyPositions.get(i), occultingBodyRadiuses[i], (FieldVector3D)occultingBodyPositions.get(j), occultingBodyRadiuses[j]);
                    CalculusFieldElement alphaJ = this.getGeneralEclipseAngles(position, (FieldVector3D)occultingBodyPositions.get(i), occultingBodyRadiuses[i], (FieldVector3D)occultingBodyPositions.get(j), occultingBodyRadiuses[j])[2];
                    CalculusFieldElement alphaSun = this.getEclipseAngles(sunPosition, position)[2];
                    CalculusFieldElement alphaJSq = (CalculusFieldElement)alphaJ.multiply((FieldElement)alphaJ);
                    CalculusFieldElement alphaSunSq = (CalculusFieldElement)alphaSun.multiply((FieldElement)alphaSun);
                    CalculusFieldElement mutualEclipseCorrection = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eclipseRatioIJ.negate()).add(1.0)).multiply((FieldElement)alphaJSq)).divide((FieldElement)alphaSunSq);
                    if (eclipseRatioJ.getReal() == 0.0) {
                        return (T)zero;
                    }
                    if (eclipseRatioJ.getReal() == 1.0) continue;
                    result = (CalculusFieldElement)result.subtract((FieldElement)mutualEclipseCorrection);
                }
            }
            result = (CalculusFieldElement)result.subtract((double)(n - 1));
        } else {
            result = this.getLightingRatio(position, frame, date);
        }
        return (T)result;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.spacecraft.getRadiationParametersDrivers();
    }

    private <T extends CalculusFieldElement<T>> T min(double d, T f) {
        return (T)(f.getReal() > d ? (CalculusFieldElement)((CalculusFieldElement)f.getField().getZero()).newInstance(d) : f);
    }

    private <T extends CalculusFieldElement<T>> T max(double d, T f) {
        return (T)(f.getReal() <= d ? (CalculusFieldElement)((CalculusFieldElement)f.getField().getZero()).newInstance(d) : f);
    }
}

