/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.Flattener;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;

public class EGMFormatReader
extends PotentialCoefficientsReader {
    private static final Pattern SEPARATOR = Pattern.compile("\\s+");
    private static final int START_DEGREE_ORDER = 120;
    private final boolean useWgs84Coefficients;

    public EGMFormatReader(String supportedNames, boolean missingCoefficientsAllowed) {
        this(supportedNames, missingCoefficientsAllowed, false);
    }

    public EGMFormatReader(String supportedNames, boolean missingCoefficientsAllowed, boolean useWgs84Coefficients) {
        super(supportedNames, missingCoefficientsAllowed, null);
        this.useWgs84Coefficients = useWgs84Coefficients;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.setReadComplete(false);
        if (this.useWgs84Coefficients) {
            this.setAe(6378137.0);
            this.setMu(3.986004418E14);
        } else {
            this.setAe(6378136.3);
            this.setMu(3.986004415E14);
        }
        String lowerCaseName = name.toLowerCase(Locale.US);
        if (lowerCaseName.contains("2008") || lowerCaseName.contains("zerotide")) {
            this.setTideSystem(TideSystem.ZERO_TIDE);
        } else {
            this.setTideSystem(TideSystem.TIDE_FREE);
        }
        Container container = new Container(120, 120, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
        boolean okFields = true;
        int maxDegree = -1;
        int maxOrder = -1;
        int lineNumber = 0;
        String line = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            line = r.readLine();
            while (okFields && line != null) {
                ++lineNumber;
                if (line.length() >= 15) {
                    String[] tab = SEPARATOR.split(line.trim());
                    if (tab.length != 6) {
                        okFields = false;
                    }
                    int i = Integer.parseInt(tab[0]);
                    int j = Integer.parseInt(tab[1]);
                    if (i < 0 || j < 0) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                    }
                    if (i <= this.getMaxParseDegree() && j <= this.getMaxParseOrder()) {
                        while (!container.flattener.withinRange(i, j)) {
                            container = container.resize(container.flattener.getDegree() * 2, container.flattener.getOrder() * 2);
                        }
                        this.parseCoefficient(tab[2], container.flattener, container.c, i, j, "C", name);
                        this.parseCoefficient(tab[3], container.flattener, container.s, i, j, "S", name);
                        maxDegree = FastMath.max((int)maxDegree, (int)i);
                        maxOrder = FastMath.max((int)maxOrder, (int)j);
                    }
                }
                line = r.readLine();
            }
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
        if (this.missingCoefficientsAllowed() && this.getMaxParseDegree() > 0 && this.getMaxParseOrder() > 0 && Precision.equals((double)container.c[container.flattener.index(0, 0)], (double)0.0, (int)0)) {
            ((Container)container).c[((Container)container).flattener.index((int)0, (int)0)] = 1.0;
        }
        if (!okFields || maxDegree < 0) {
            String loaderName = this.getClass().getName();
            loaderName = loaderName.substring(loaderName.lastIndexOf(46) + 1);
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_FILE_FORMAT_ERROR_FOR_LOADER, name, loaderName);
        }
        container = container.resize(maxDegree, maxOrder);
        this.setRawCoefficients(true, container.flattener, container.c, container.s, name);
        this.setReadComplete(true);
    }

    @Override
    public RawSphericalHarmonicsProvider getProvider(boolean wantNormalized, int degree, int order) {
        return this.getBaseProvider(wantNormalized, degree, order);
    }

    private static class Container {
        private final Flattener flattener;
        private final double[] c;
        private final double[] s;
        private final double initialValue;

        Container(int degree, int order, double initialValue) {
            this.flattener = new Flattener(degree, order);
            this.c = new double[this.flattener.arraySize()];
            this.s = new double[this.flattener.arraySize()];
            this.initialValue = initialValue;
            Arrays.fill(this.c, initialValue);
            Arrays.fill(this.s, initialValue);
        }

        Container resize(int degree, int order) {
            Container resized = new Container(degree, order, this.initialValue);
            for (int n = 0; n <= degree; ++n) {
                for (int m = 0; m <= FastMath.min((int)n, (int)order); ++m) {
                    if (!this.flattener.withinRange(n, m)) continue;
                    int rIndex = resized.flattener.index(n, m);
                    int index = this.flattener.index(n, m);
                    resized.c[rIndex] = this.c[index];
                    resized.s[rIndex] = this.s[index];
                }
            }
            return resized;
        }
    }
}

