/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.CelestialBody;
import org.orekit.data.DataContext;
import org.orekit.forces.AbstractForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class DeSitterRelativity
extends AbstractForceModel {
    public static final String ATTRACTION_COEFFICIENT_SUFFIX = " attraction coefficient";
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final CelestialBody sun;
    private final CelestialBody earth;
    private final ParameterDriver gmParameterDriver;

    @DefaultDataContext
    public DeSitterRelativity() {
        this(DataContext.getDefault().getCelestialBodies().getEarth(), DataContext.getDefault().getCelestialBodies().getSun());
    }

    public DeSitterRelativity(CelestialBody earth, CelestialBody sun) {
        this.gmParameterDriver = new ParameterDriver(sun.getName() + ATTRACTION_COEFFICIENT_SUFFIX, sun.getGM(), MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.earth = earth;
        this.sun = sun;
    }

    public CelestialBody getSun() {
        return this.sun;
    }

    public CelestialBody getEarth() {
        return this.earth;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        double c2 = 8.987551787368176E16;
        double gm = parameters[0];
        TimeStampedPVCoordinates pvSat = s.getPVCoordinates();
        Vector3D vSat = pvSat.getVelocity();
        TimeStampedPVCoordinates pvEarth = this.earth.getPVCoordinates(s.getDate(), this.sun.getInertiallyOrientedFrame());
        Vector3D pEarth = pvEarth.getPosition();
        Vector3D vEarth = pvEarth.getVelocity();
        double r = pEarth.getNorm();
        double r3 = r * r * r;
        return new Vector3D(-3.0 * gm / (8.987551787368176E16 * r3), vEarth.crossProduct((Vector)pEarth).crossProduct((Vector)vSat));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        double c2 = 8.987551787368176E16;
        T gm = parameters[0];
        TimeStampedFieldPVCoordinates<T> pvSat = s.getPVCoordinates();
        FieldVector3D vSat = pvSat.getVelocity();
        TimeStampedFieldPVCoordinates<T> pvEarth = this.earth.getPVCoordinates(s.getDate(), this.sun.getInertiallyOrientedFrame());
        FieldVector3D pEarth = pvEarth.getPosition();
        FieldVector3D vEarth = pvEarth.getVelocity();
        CalculusFieldElement r = pEarth.getNorm();
        CalculusFieldElement r3 = (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)r)).multiply((FieldElement)r);
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)gm.multiply(-3.0)).divide(r3.multiply(8.987551787368176E16)), vEarth.crossProduct(pEarth).crossProduct(vSat));
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.gmParameterDriver);
    }
}

