/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Scanner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.EphemerisFileParser;
import org.orekit.files.sp3.SP3;
import org.orekit.frames.Frame;
import org.orekit.gnss.TimeSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.IERSConventions;

public class SP3Parser
implements EphemerisFileParser<SP3> {
    public static final double DEFAULT_CLOCK_VALUE = 999999.999999;
    private static final String SPACES = "\\s+";
    private static final double MILLIMETER = 0.001;
    private final double mu;
    private final int interpolationSamples;
    private final Function<? super String, ? extends Frame> frameBuilder;
    private final TimeScales timeScales;

    @DefaultDataContext
    public SP3Parser() {
        this(3.986004415E14, 7, SP3Parser::guessFrame);
    }

    @DefaultDataContext
    public SP3Parser(double mu, int interpolationSamples, Function<? super String, ? extends Frame> frameBuilder) {
        this(mu, interpolationSamples, frameBuilder, DataContext.getDefault().getTimeScales());
    }

    public SP3Parser(double mu, int interpolationSamples, Function<? super String, ? extends Frame> frameBuilder, TimeScales timeScales) {
        this.mu = mu;
        this.interpolationSamples = interpolationSamples;
        this.frameBuilder = frameBuilder;
        this.timeScales = timeScales;
    }

    @DefaultDataContext
    private static Frame guessFrame(String name) {
        return DataContext.getDefault().getFrames().getITRF(IERSConventions.IERS_2010, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SP3 parse(DataSource source) {
        try {
            reader = source.getOpener().openReaderOnce();
            var3_4 = null;
            try {
                br = reader == null ? null : new BufferedReader(reader);
                var5_7 = null;
                if (br == null) {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, new Object[]{source.getName()});
                }
                pi = new ParseInfo();
                lineNumber = 0;
                candidateParsers = Stream.of(LineParser.HEADER_VERSION);
                line = br.readLine();
lbl14:
                // 2 sources

                while (line != null) {
                    ++lineNumber;
                    l = line;
                    selected = candidateParsers.filter((Predicate<LineParser>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$parse$0(java.lang.String org.orekit.files.sp3.SP3Parser$LineParser ), (Lorg/orekit/files/sp3/SP3Parser$LineParser;)Z)((String)l)).findFirst();
                    if (!selected.isPresent()) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, new Object[]{lineNumber, source.getName(), line});
                    }
                    try {
                        selected.get().parse(line, pi);
                    }
                    catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                        throw new OrekitException(e, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, new Object[]{lineNumber, source.getName(), line});
                    }
                    candidateParsers = selected.get().allowedNext();
                    if (!ParseInfo.access$000(pi)) ** GOTO lbl56
                    if (ParseInfo.access$100(pi) != ParseInfo.access$200(pi).getNumberOfEpochs()) {
                        throw new OrekitException((Localizable)OrekitMessages.SP3_NUMBER_OF_EPOCH_MISMATCH, new Object[]{ParseInfo.access$100(pi), source.getName(), ParseInfo.access$200(pi).getNumberOfEpochs()});
                    }
                    var12_16 = ParseInfo.access$200(pi);
                    if (br == null) return var12_16;
                    if (var5_7 == null) ** GOTO lbl54
                    ** GOTO lbl48
                }
                throw new OrekitException((Localizable)OrekitMessages.SP3_UNEXPECTED_END_OF_FILE, new Object[]{lineNumber});
                {
                    catch (Throwable var6_9) {
                        var5_7 = var6_9;
                        throw var6_9;
                    }
                    catch (Throwable var14_19) {
                        if (br == null) throw var14_19;
                        if (var5_7 == null) {
                            br.close();
                            throw var14_19;
                        }
                        try {
                            br.close();
                            throw var14_19;
                        }
                        catch (Throwable var15_20) {
                            var5_7.addSuppressed(var15_20);
                            throw var14_19;
                        }
                    }
lbl48:
                    // 1 sources

                    try {
                        br.close();
                        return var12_16;
                    }
                    catch (Throwable var13_17) {
                        var5_7.addSuppressed(var13_17);
                        return var12_16;
                    }
lbl54:
                    // 1 sources

                    br.close();
                    return var12_16;
lbl56:
                    // 1 sources

                    ** try [egrp 7[TRYBLOCK] [10 : 383->465)] { 
lbl-1000:
                    // 1 sources

                    {
                        line = br.readLine();
                        ** GOTO lbl14
                    }
                }
            }
lbl59:
            // 2 sources

            catch (Throwable var4_6) {
                var3_4 = var4_6;
                throw var4_6;
            }
            finally {
                if (reader != null) {
                    if (var3_4 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable var13_18) {
                            var3_4.addSuppressed(var13_18);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, new Object[]{ioe.getLocalizedMessage()});
        }
    }

    private static SP3.SP3FileType getFileType(String fileType) {
        SP3.SP3FileType type = SP3.SP3FileType.UNDEFINED;
        if ("G".equalsIgnoreCase(fileType)) {
            type = SP3.SP3FileType.GPS;
        } else if ("M".equalsIgnoreCase(fileType)) {
            type = SP3.SP3FileType.MIXED;
        } else if ("R".equalsIgnoreCase(fileType)) {
            type = SP3.SP3FileType.GLONASS;
        } else if ("L".equalsIgnoreCase(fileType)) {
            type = SP3.SP3FileType.LEO;
        } else if ("S".equalsIgnoreCase(fileType)) {
            type = SP3.SP3FileType.SBAS;
        } else if ("I".equalsIgnoreCase(fileType)) {
            type = SP3.SP3FileType.IRNSS;
        } else if ("E".equalsIgnoreCase(fileType)) {
            type = SP3.SP3FileType.GALILEO;
        } else if ("C".equalsIgnoreCase(fileType)) {
            type = SP3.SP3FileType.COMPASS;
        } else if ("J".equalsIgnoreCase(fileType)) {
            type = SP3.SP3FileType.QZSS;
        }
        return type;
    }

    private static /* synthetic */ boolean lambda$parse$0(String l, LineParser p) {
        return p.canHandle(l);
    }

    private static enum LineParser {
        HEADER_VERSION("^#[a-z].*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                try (Scanner s1 = new Scanner(line);
                     Scanner s2 = s1.useDelimiter(SP3Parser.SPACES);
                     Scanner scanner = s2.useLocale(Locale.US);){
                    scanner.skip("#");
                    String v = scanner.next();
                    char version = v.substring(0, 1).toLowerCase().charAt(0);
                    if (version != 'a' && version != 'b' && version != 'c' && version != 'd') {
                        throw new OrekitException((Localizable)OrekitMessages.SP3_UNSUPPORTED_VERSION, Character.valueOf(version));
                    }
                    pi.hasVelocityEntries = "V".equals(v.substring(1, 2));
                    pi.file.setFilter(pi.hasVelocityEntries ? CartesianDerivativesFilter.USE_PV : CartesianDerivativesFilter.USE_P);
                    int year = Integer.parseInt(v.substring(2));
                    int month = scanner.nextInt();
                    int day = scanner.nextInt();
                    int hour = scanner.nextInt();
                    int minute = scanner.nextInt();
                    double second = scanner.nextDouble();
                    pi.epoch = new DateTimeComponents(year, month, day, hour, minute, second);
                    int numEpochs = scanner.nextInt();
                    pi.file.setNumberOfEpochs(numEpochs);
                    pi.file.setDataUsed(scanner.next());
                    pi.file.setCoordinateSystem(scanner.next());
                    pi.file.setOrbitTypeKey(scanner.next());
                    pi.file.setAgency(scanner.next());
                }
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_DATE_TIME_REFERENCE);
            }
        }
        ,
        HEADER_DATE_TIME_REFERENCE("^##.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                try (Scanner s1 = new Scanner(line);
                     Scanner s2 = s1.useDelimiter(SP3Parser.SPACES);
                     Scanner scanner = s2.useLocale(Locale.US);){
                    scanner.skip("##");
                    pi.file.setGpsWeek(scanner.nextInt());
                    pi.file.setSecondsOfWeek(scanner.nextDouble());
                    pi.file.setEpochInterval(scanner.nextDouble());
                    pi.file.setJulianDay(scanner.nextInt());
                    pi.file.setDayFraction(scanner.nextDouble());
                }
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_SAT_IDS);
            }
        }
        ,
        HEADER_SAT_IDS("^\\+ .*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                if (pi.maxSatellites == 0) {
                    pi.maxSatellites = Integer.parseInt(line.substring(3, 6).trim());
                }
                int lineLength = line.length();
                int count = pi.file.getSatelliteCount();
                int startIdx = 9;
                while (count++ < pi.maxSatellites && startIdx + 3 <= lineLength) {
                    String satId = line.substring(startIdx, startIdx + 3).trim();
                    if (satId.length() > 0) {
                        pi.file.addSatellite(satId);
                    }
                    startIdx += 3;
                }
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_SAT_IDS, HEADER_ACCURACY);
            }
        }
        ,
        HEADER_ACCURACY("^\\+\\+.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                int lineLength = line.length();
                int startIdx = 9;
                while (pi.nbAccuracies < pi.maxSatellites && startIdx + 3 <= lineLength) {
                    String sub = line.substring(startIdx, startIdx + 3).trim();
                    if (sub.length() > 0) {
                        int exponent = Integer.parseInt(sub);
                        pi.file.setAccuracy(pi.nbAccuracies++, (double)(2 << exponent) * 0.001);
                    }
                    startIdx += 3;
                }
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_ACCURACY, HEADER_TIME_SYSTEM);
            }
        }
        ,
        HEADER_TIME_SYSTEM("^%c.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                if (pi.file.getType() == null) {
                    pi.file.setType(SP3Parser.getFileType(line.substring(3, 5).trim()));
                    String tsStr = line.substring(9, 12).trim();
                    TimeSystem ts = tsStr.equalsIgnoreCase("ccc") ? TimeSystem.GPS : TimeSystem.valueOf(tsStr);
                    pi.file.setTimeSystem(ts);
                    pi.timeScale = ts.getTimeScale(pi.timeScales);
                    pi.file.setEpoch(new AbsoluteDate(pi.epoch, pi.timeScale));
                }
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_TIME_SYSTEM, HEADER_STANDARD_DEVIATIONS);
            }
        }
        ,
        HEADER_STANDARD_DEVIATIONS("^%f.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_STANDARD_DEVIATIONS, HEADER_CUSTOM_PARAMETERS);
            }
        }
        ,
        HEADER_CUSTOM_PARAMETERS("^%i.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_CUSTOM_PARAMETERS, HEADER_COMMENTS);
            }
        }
        ,
        HEADER_COMMENTS("^/\\*.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(HEADER_COMMENTS, DATA_EPOCH);
            }
        }
        ,
        DATA_EPOCH("^\\* .*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                int year = Integer.parseInt(line.substring(3, 7).trim());
                int month = Integer.parseInt(line.substring(8, 10).trim());
                int day = Integer.parseInt(line.substring(11, 13).trim());
                int hour = Integer.parseInt(line.substring(14, 16).trim());
                int minute = Integer.parseInt(line.substring(17, 19).trim());
                double second = Double.parseDouble(line.substring(20, 31).trim());
                pi.latestEpoch = new AbsoluteDate(year, month, day, hour, minute, second, pi.timeScale);
                pi.nbEpochs++;
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(DATA_POSITION);
            }
        }
        ,
        DATA_POSITION("^P.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String satelliteId = line.substring(1, 4).trim();
                if (!pi.file.containsSatellite(satelliteId)) {
                    pi.latestPosition = null;
                } else {
                    double x = Double.parseDouble(line.substring(4, 18).trim());
                    double y = Double.parseDouble(line.substring(18, 32).trim());
                    double z = Double.parseDouble(line.substring(32, 46).trim());
                    pi.latestPosition = new Vector3D(x * 1000.0, y * 1000.0, z * 1000.0);
                    pi.latestClock = line.length() <= 46 ? 999999.999999 : Double.parseDouble(line.substring(46, 60).trim()) * 1.0E-6;
                    if (!pi.hasVelocityEntries) {
                        SP3.SP3Coordinate coord = new SP3.SP3Coordinate(pi.latestEpoch, pi.latestPosition, pi.latestClock);
                        pi.file.addSatelliteCoordinate(satelliteId, coord);
                    }
                }
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(DATA_EPOCH, DATA_POSITION, DATA_POSITION_CORRELATION, DATA_VELOCITY, EOF);
            }
        }
        ,
        DATA_POSITION_CORRELATION("^EP.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(DATA_EPOCH, DATA_POSITION, DATA_VELOCITY, EOF);
            }
        }
        ,
        DATA_VELOCITY("^V.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String satelliteId = line.substring(1, 4).trim();
                if (pi.file.containsSatellite(satelliteId)) {
                    double xv = Double.parseDouble(line.substring(4, 18).trim());
                    double yv = Double.parseDouble(line.substring(18, 32).trim());
                    double zv = Double.parseDouble(line.substring(32, 46).trim());
                    Vector3D velocity = new Vector3D(xv / 10.0, yv / 10.0, zv / 10.0);
                    double clockRateChange = line.length() <= 46 ? 999999.999999 : Double.parseDouble(line.substring(46, 60).trim()) * 1.0E-4;
                    SP3.SP3Coordinate coord = new SP3.SP3Coordinate(pi.latestEpoch, pi.latestPosition, velocity, pi.latestClock, clockRateChange);
                    pi.file.addSatelliteCoordinate(satelliteId, coord);
                }
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(DATA_EPOCH, DATA_POSITION, DATA_VELOCITY_CORRELATION, EOF);
            }
        }
        ,
        DATA_VELOCITY_CORRELATION("^EV.*"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(DATA_EPOCH, DATA_POSITION, EOF);
            }
        }
        ,
        EOF("^[eE][oO][fF]\\s*$"){

            @Override
            public void parse(String line, ParseInfo pi) {
                pi.done = true;
            }

            @Override
            public Stream<LineParser> allowedNext() {
                return Stream.of(EOF);
            }
        };

        private final Pattern pattern;

        private LineParser(String lineRegexp) {
            this.pattern = Pattern.compile(lineRegexp);
        }

        public abstract void parse(String var1, ParseInfo var2);

        public abstract Stream<LineParser> allowedNext();

        public boolean canHandle(String line) {
            return this.pattern.matcher(line).matches();
        }
    }

    private class ParseInfo {
        private final TimeScales timeScales;
        private SP3 file;
        private AbsoluteDate latestEpoch;
        private Vector3D latestPosition;
        private double latestClock;
        private boolean hasVelocityEntries;
        private TimeScale timeScale;
        private DateTimeComponents epoch;
        private int maxSatellites;
        private int nbAccuracies;
        private int nbEpochs;
        private boolean done;

        protected ParseInfo() {
            this.timeScales = SP3Parser.this.timeScales;
            this.file = new SP3(SP3Parser.this.mu, SP3Parser.this.interpolationSamples, SP3Parser.this.frameBuilder);
            this.latestEpoch = null;
            this.latestPosition = null;
            this.latestClock = 0.0;
            this.hasVelocityEntries = false;
            this.epoch = DateTimeComponents.JULIAN_EPOCH;
            this.timeScale = this.timeScales.getGPS();
            this.maxSatellites = 0;
            this.nbAccuracies = 0;
            this.nbEpochs = 0;
            this.done = false;
        }

        static /* synthetic */ boolean access$000(ParseInfo x0) {
            return x0.done;
        }

        static /* synthetic */ int access$100(ParseInfo x0) {
            return x0.nbEpochs;
        }
    }
}

