/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.omm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.omm.OmmTle;
import org.orekit.files.ccsds.ndm.odm.omm.OmmTleKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class OmmTleWriter
extends AbstractWriter {
    private final OmmTle tleBlock;

    OmmTleWriter(String xmlTag, String kvnTag, OmmTle tleBlock) {
        super(xmlTag, kvnTag);
        this.tleBlock = tleBlock;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.tleBlock.getComments());
        generator.writeEntry(OmmTleKey.EPHEMERIS_TYPE.name(), this.tleBlock.getEphemerisType(), true);
        generator.writeEntry(OmmTleKey.CLASSIFICATION_TYPE.name(), this.tleBlock.getClassificationType(), true);
        generator.writeEntry(OmmTleKey.NORAD_CAT_ID.name(), this.tleBlock.getNoradID(), true);
        generator.writeEntry(OmmTleKey.ELEMENT_SET_NO.name(), this.tleBlock.getElementSetNumber(), true);
        generator.writeEntry(OmmTleKey.REV_AT_EPOCH.name(), this.tleBlock.getRevAtEpoch(), true);
        generator.writeEntry(OmmTleKey.BSTAR.name(), this.tleBlock.getBStar(), Unit.ONE, true);
        generator.writeEntry(OmmTleKey.MEAN_MOTION_DOT.name(), this.tleBlock.getMeanMotionDot(), Units.REV_PER_DAY2_SCALED, true);
        generator.writeEntry(OmmTleKey.MEAN_MOTION_DDOT.name(), this.tleBlock.getMeanMotionDotDot(), Units.REV_PER_DAY3_SCALED, true);
    }
}

