/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.oem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.ndm.odm.oem.OemMetadata;
import org.orekit.files.ccsds.ndm.odm.oem.OemSatelliteEphemeris;
import org.orekit.files.ccsds.ndm.odm.oem.OemSegment;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.general.EphemerisFile;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Oem
extends NdmConstituent<Header, OemSegment>
implements EphemerisFile<TimeStampedPVCoordinates, OemSegment> {
    public static final String ROOT = "oem";
    public static final String FORMAT_VERSION_KEY = "CCSDS_OEM_VERS";
    private final double mu;

    public Oem(Header header, List<OemSegment> segments, IERSConventions conventions, DataContext dataContext, double mu) {
        super(header, segments, conventions, dataContext);
        this.mu = mu;
    }

    @Override
    public Map<String, OemSatelliteEphemeris> getSatellites() {
        HashMap byId = new HashMap();
        for (OemSegment segment : this.getSegments()) {
            String id = ((OemMetadata)segment.getMetadata()).getObjectID();
            byId.putIfAbsent(id, new ArrayList());
            ((List)byId.get(id)).add(segment);
        }
        HashMap<String, OemSatelliteEphemeris> ret = new HashMap<String, OemSatelliteEphemeris>();
        for (Map.Entry entry : byId.entrySet()) {
            ret.put((String)entry.getKey(), new OemSatelliteEphemeris((String)entry.getKey(), this.mu, (List)entry.getValue()));
        }
        return ret;
    }

    public void checkTimeSystems() {
        TimeSystem referenceTimeSystem = null;
        for (OemSegment segment : this.getSegments()) {
            TimeSystem timeSystem = ((OemMetadata)segment.getMetadata()).getTimeSystem();
            if (referenceTimeSystem == null) {
                referenceTimeSystem = timeSystem;
                continue;
            }
            if (referenceTimeSystem.equals((Object)timeSystem)) continue;
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INCONSISTENT_TIME_SYSTEMS, referenceTimeSystem.name(), timeSystem.name());
        }
    }
}

