/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.BodyFacade;
import org.orekit.files.ccsds.definitions.CelestialBodyFrame;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.definitions.ModifiedFrame;
import org.orekit.files.ccsds.ndm.odm.CommonMetadataKey;
import org.orekit.files.ccsds.ndm.odm.OdmMetadata;
import org.orekit.files.ccsds.ndm.odm.OdmMetadataKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;

public class CommonMetadata
extends OdmMetadata {
    private String objectID;
    private BodyFacade center;
    private FrameFacade referenceFrame;
    private String frameEpochString;
    private AbsoluteDate frameEpoch;

    public CommonMetadata() {
        super(null);
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNull(this.getObjectName(), OdmMetadataKey.OBJECT_NAME);
        this.checkNotNull(this.objectID, CommonMetadataKey.OBJECT_ID);
        this.checkNotNull(this.center, CommonMetadataKey.CENTER_NAME);
        this.checkNotNull(this.referenceFrame, CommonMetadataKey.REF_FRAME);
    }

    public void finalizeMetadata(ContextBinding context) {
        if (this.frameEpochString != null) {
            this.frameEpoch = context.getTimeSystem().getConverter(context).parse(this.frameEpochString);
        }
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String objectID) {
        this.refuseFurtherComments();
        this.objectID = objectID;
    }

    public int getLaunchYear() {
        return this.getLaunchYear(this.objectID);
    }

    public int getLaunchNumber() {
        return this.getLaunchNumber(this.objectID);
    }

    public String getLaunchPiece() {
        return this.getLaunchPiece(this.objectID);
    }

    public BodyFacade getCenter() {
        return this.center;
    }

    public void setCenter(BodyFacade center) {
        this.refuseFurtherComments();
        this.center = center;
    }

    public Frame getFrame() {
        if (this.center.getBody() == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_DATA_LOADED_FOR_CELESTIAL_BODY, this.center.getName());
        }
        if (this.referenceFrame.asFrame() == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, this.referenceFrame.getName());
        }
        boolean isMci = this.referenceFrame.asCelestialBodyFrame() == CelestialBodyFrame.MCI;
        boolean isIcrf = this.referenceFrame.asCelestialBodyFrame() == CelestialBodyFrame.ICRF;
        boolean isSolarSystemBarycenter = "solar system barycenter".equals(this.center.getBody().getName());
        if (!isMci && !isIcrf && "Earth".equals(this.center.getBody().getName()) || isMci && "Mars".equals(this.center.getBody().getName()) || isIcrf && isSolarSystemBarycenter) {
            return this.referenceFrame.asFrame();
        }
        return new ModifiedFrame(this.referenceFrame.asFrame(), this.referenceFrame.asCelestialBodyFrame(), this.center.getBody(), this.center.getName());
    }

    public FrameFacade getReferenceFrame() {
        return this.referenceFrame;
    }

    public void setReferenceFrame(FrameFacade referenceFrame) {
        this.refuseFurtherComments();
        this.referenceFrame = referenceFrame;
    }

    public void setFrameEpochString(String frameEpochString) {
        this.refuseFurtherComments();
        this.frameEpochString = frameEpochString;
    }

    public AbsoluteDate getFrameEpoch() {
        return this.frameEpoch;
    }

    public void setFrameEpoch(AbsoluteDate frameEpoch) {
        this.refuseFurtherComments();
        this.frameEpoch = frameEpoch;
    }
}

