/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.adm.AttitudeEndoints;
import org.orekit.files.ccsds.ndm.adm.apm.SpinStabilizedKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class SpinStabilized
extends CommentsContainer {
    private final AttitudeEndoints endpoints = new AttitudeEndoints();
    private double spinAlpha = Double.NaN;
    private double spinDelta = Double.NaN;
    private double spinAngle = Double.NaN;
    private double spinAngleVel = Double.NaN;
    private double nutation = Double.NaN;
    private double nutationPer = Double.NaN;
    private double nutationPhase = Double.NaN;

    @Override
    public void validate(double version) {
        super.validate(version);
        this.endpoints.checkMandatoryEntriesExceptExternalFrame(SpinStabilizedKey.SPIN_FRAME_A, SpinStabilizedKey.SPIN_FRAME_B, SpinStabilizedKey.SPIN_DIR);
        this.endpoints.checkExternalFrame(SpinStabilizedKey.SPIN_FRAME_A, SpinStabilizedKey.SPIN_FRAME_B);
        this.checkNotNaN(this.spinAlpha, SpinStabilizedKey.SPIN_ALPHA);
        this.checkNotNaN(this.spinDelta, SpinStabilizedKey.SPIN_DELTA);
        this.checkNotNaN(this.spinAngle, SpinStabilizedKey.SPIN_ANGLE);
        this.checkNotNaN(this.spinAngleVel, SpinStabilizedKey.SPIN_ANGLE_VEL);
        if (!(!Double.isNaN(this.nutation + this.nutationPer + this.nutationPhase) || Double.isNaN(this.nutation) && Double.isNaN(this.nutationPer) && Double.isNaN(this.nutationPhase))) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, "NUTATION*");
        }
    }

    public AttitudeEndoints getEndpoints() {
        return this.endpoints;
    }

    public double getSpinAlpha() {
        return this.spinAlpha;
    }

    public void setSpinAlpha(double spinAlpha) {
        this.refuseFurtherComments();
        this.spinAlpha = spinAlpha;
    }

    public double getSpinDelta() {
        return this.spinDelta;
    }

    public void setSpinDelta(double spinDelta) {
        this.refuseFurtherComments();
        this.spinDelta = spinDelta;
    }

    public double getSpinAngle() {
        return this.spinAngle;
    }

    public void setSpinAngle(double spinAngle) {
        this.refuseFurtherComments();
        this.spinAngle = spinAngle;
    }

    public double getSpinAngleVel() {
        return this.spinAngleVel;
    }

    public void setSpinAngleVel(double spinAngleVel) {
        this.refuseFurtherComments();
        this.spinAngleVel = spinAngleVel;
    }

    public double getNutation() {
        return this.nutation;
    }

    public void setNutation(double nutation) {
        this.refuseFurtherComments();
        this.nutation = nutation;
    }

    public double getNutationPeriod() {
        return this.nutationPer;
    }

    public void setNutationPeriod(double period) {
        this.refuseFurtherComments();
        this.nutationPer = period;
    }

    public double getNutationPhase() {
        return this.nutationPhase;
    }

    public void setNutationPhase(double nutationPhase) {
        this.refuseFurtherComments();
        this.nutationPhase = nutationPhase;
    }
}

