/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.util.List;
import org.hipparchus.complex.Quaternion;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.Attitude;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.ndm.adm.AdmMetadata;
import org.orekit.files.ccsds.ndm.adm.AttitudeType;
import org.orekit.files.ccsds.ndm.adm.apm.ApmData;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternion;
import org.orekit.files.ccsds.ndm.adm.apm.Euler;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.frames.Frame;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class Apm
extends NdmConstituent<Header, Segment<AdmMetadata, ApmData>> {
    public static final String ROOT = "apm";
    public static final String FORMAT_VERSION_KEY = "CCSDS_APM_VERS";

    public Apm(Header header, List<Segment<AdmMetadata, ApmData>> segments, IERSConventions conventions, DataContext dataContext) {
        super(header, segments, conventions, dataContext);
    }

    public AdmMetadata getMetadata() {
        return (AdmMetadata)((Segment)this.getSegments().get(0)).getMetadata();
    }

    public ApmData getData() {
        return (ApmData)((Segment)this.getSegments().get(0)).getData();
    }

    public Attitude getAttitude(Frame frame, PVCoordinatesProvider pvProvider) {
        TimeStampedAngularCoordinates tac;
        ApmData data = (ApmData)((Segment)this.getSegments().get(0)).getData();
        ApmQuaternion qBlock = data.getQuaternionBlock();
        Euler eBlock = data.getEulerBlock();
        if (qBlock.hasRates()) {
            Quaternion q = qBlock.getQuaternion();
            Quaternion qDot = qBlock.getQuaternionDot();
            tac = AttitudeType.QUATERNION_DERIVATIVE.build(true, qBlock.getEndpoints().isExternal2SpacecraftBody(), null, true, qBlock.getEpoch(), q.getQ0(), q.getQ1(), q.getQ2(), q.getQ3(), qDot.getQ0(), qDot.getQ1(), qDot.getQ2(), qDot.getQ3());
        } else if (eBlock != null && eBlock.hasRates()) {
            if (!qBlock.getEndpoints().isCompatibleWith(eBlock.getEndpoints())) {
                throw new OrekitException((Localizable)OrekitMessages.INCOMPATIBLE_FRAMES, qBlock.getEndpoints().toString(), eBlock.getEndpoints().toString());
            }
            Quaternion q = qBlock.getQuaternion();
            double[] rates = eBlock.getRotationRates();
            tac = AttitudeType.QUATERNION_RATE.build(true, qBlock.getEndpoints().isExternal2SpacecraftBody(), eBlock.getEulerRotSeq(), eBlock.isSpacecraftBodyRate(), qBlock.getEpoch(), q.getQ0(), q.getQ1(), q.getQ2(), q.getQ3(), rates[0], rates[1], rates[2]);
        } else {
            Quaternion q = qBlock.getQuaternion();
            tac = AttitudeType.QUATERNION.build(true, qBlock.getEndpoints().isExternal2SpacecraftBody(), null, true, qBlock.getEpoch(), q.getQ0(), q.getQ1(), q.getQ2(), q.getQ3());
        }
        return qBlock.getEndpoints().build(frame, pvProvider, tac);
    }
}

