/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.adm.AdmMetadataKey;
import org.orekit.files.ccsds.ndm.adm.AdmParser;
import org.orekit.files.ccsds.ndm.adm.aem.Aem;
import org.orekit.files.ccsds.ndm.adm.aem.AemData;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadata;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadataKey;
import org.orekit.files.ccsds.ndm.adm.aem.AemSegment;
import org.orekit.files.ccsds.ndm.adm.aem.AttitudeEntry;
import org.orekit.files.ccsds.ndm.adm.aem.AttitudeEntryKey;
import org.orekit.files.ccsds.ndm.adm.aem.XmlSubStructureKey;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.HeaderProcessingState;
import org.orekit.files.ccsds.section.KvnStructureProcessingState;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.XmlStructureProcessingState;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;
import org.orekit.files.general.AttitudeEphemerisFileParser;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class AemParser
extends AdmParser<Aem, AemParser>
implements AttitudeEphemerisFileParser<Aem> {
    private static final Pattern SPLIT_AT_BLANKS = Pattern.compile("\\s+");
    private Header header;
    private List<AemSegment> segments;
    private AemMetadata metadata;
    private ContextBinding context;
    private AemData currentBlock;
    private int defaultInterpolationDegree;
    private ProcessingState structureProcessor;
    private AttitudeEntry currentEntry;

    public AemParser(IERSConventions conventions, boolean simpleEOP, DataContext dataContext, AbsoluteDate missionReferenceDate, int defaultInterpolationDegree, ParsedUnitsBehavior parsedUnitsBehavior) {
        super("aem", "CCSDS_AEM_VERS", conventions, simpleEOP, dataContext, missionReferenceDate, parsedUnitsBehavior);
        this.defaultInterpolationDegree = defaultInterpolationDegree;
    }

    @Override
    public Aem parse(DataSource source) {
        return (Aem)this.parseMessage(source);
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public void reset(FileFormat fileFormat) {
        this.header = new Header(2.0);
        this.segments = new ArrayList<AemSegment>();
        this.metadata = null;
        this.context = null;
        if (fileFormat == FileFormat.XML) {
            this.structureProcessor = new XmlStructureProcessingState("aem", this);
            this.reset(fileFormat, this.structureProcessor);
        } else {
            this.structureProcessor = new KvnStructureProcessingState(this);
            this.reset(fileFormat, new HeaderProcessingState(this));
        }
    }

    @Override
    public boolean prepareHeader() {
        this.anticipateNext(new HeaderProcessingState(this));
        return true;
    }

    @Override
    public boolean inHeader() {
        this.anticipateNext(this.structureProcessor);
        return true;
    }

    @Override
    public boolean finalizeHeader() {
        this.header.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareMetadata() {
        if (this.metadata != null) {
            return false;
        }
        this.metadata = new AemMetadata(this.defaultInterpolationDegree);
        this.context = new ContextBinding(this::getConventions, this::isSimpleEOP, this::getDataContext, this::getParsedUnitsBehavior, this::getMissionReferenceDate, this.metadata::getTimeSystem, () -> 0.0, () -> 1.0);
        this.anticipateNext(this::processMetadataToken);
        return true;
    }

    @Override
    public boolean inMetadata() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processKvnDataToken);
        return true;
    }

    @Override
    public boolean finalizeMetadata() {
        this.metadata.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareData() {
        this.currentBlock = new AemData();
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processMetadataToken);
        return true;
    }

    @Override
    public boolean inData() {
        this.anticipateNext(this.structureProcessor);
        return true;
    }

    @Override
    public boolean finalizeData() {
        if (this.metadata != null) {
            this.currentBlock.validate(this.header.getFormatVersion());
            this.segments.add(new AemSegment(this.metadata, this.currentBlock));
        }
        this.metadata = null;
        this.context = null;
        return true;
    }

    @Override
    public Aem build() {
        Aem file = new Aem(this.header, this.segments, this.getConventions(), this.getDataContext());
        file.checkTimeSystems();
        return file;
    }

    boolean manageXmlAttitudeStateSection(boolean starting) {
        if (starting) {
            this.currentEntry = new AttitudeEntry(this.metadata);
            this.anticipateNext(this::processXmlDataToken);
        } else {
            this.currentBlock.addData(this.currentEntry.getCoordinates());
            this.currentEntry = null;
            this.anticipateNext(this.structureProcessor);
        }
        return true;
    }

    boolean addDataComment(String comment) {
        this.currentBlock.addComment(comment);
        return true;
    }

    private boolean processMetadataToken(ParseToken token) {
        this.inMetadata();
        try {
            return token.getName() != null && MetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
        }
        catch (IllegalArgumentException iaeM) {
            try {
                return AdmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
            }
            catch (IllegalArgumentException iaeD) {
                try {
                    return AemMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
                }
                catch (IllegalArgumentException iaeE) {
                    return false;
                }
            }
        }
    }

    private boolean processXmlSubStructureToken(ParseToken token) {
        try {
            return token.getName() != null && XmlSubStructureKey.valueOf(token.getName()).process(token, this);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processKvnDataToken(ParseToken token) {
        this.inData();
        if ("COMMENT".equals(token.getName())) {
            return token.getType() == TokenType.ENTRY ? this.currentBlock.addComment(token.getContentAsNormalizedString()) : true;
        }
        if (token.getType() == TokenType.RAW_LINE) {
            try {
                if (this.metadata.getAttitudeType() == null) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, AemMetadataKey.ATTITUDE_TYPE.name(), token.getFileName());
                }
                return this.currentBlock.addData(this.metadata.getAttitudeType().parse(this.metadata.isFirst(), this.metadata.getEndpoints().isExternal2SpacecraftBody(), this.metadata.getEulerRotSeq(), this.metadata.isSpacecraftBodyRate(), this.context, SPLIT_AT_BLANKS.split(token.getRawContent().trim())));
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException(nfe, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getRawContent());
            }
        }
        return false;
    }

    private boolean processXmlDataToken(ParseToken token) {
        this.anticipateNext(this::processXmlSubStructureToken);
        try {
            return token.getName() != null && AttitudeEntryKey.valueOf(token.getName()).process(token, this.context, this.currentEntry);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }
}

