/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.QRDecomposer;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.SemiAnalyticalKalmanEstimator;
import org.orekit.propagation.conversion.DSSTPropagatorBuilder;
import org.orekit.utils.ParameterDriversList;

public class SemiAnalyticalKalmanEstimatorBuilder {
    private MatrixDecomposer decomposer = new QRDecomposer(1.0E-15);
    private DSSTPropagatorBuilder dsstPropagatorBuilder = null;
    private CovarianceMatrixProvider processNoiseMatrixProvider = null;
    private ParameterDriversList estimatedMeasurementsParameters = new ParameterDriversList();
    private CovarianceMatrixProvider measurementProcessNoiseMatrix = null;

    public SemiAnalyticalKalmanEstimator build() {
        if (this.dsstPropagatorBuilder == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_PROPAGATOR_CONFIGURED, new Object[0]);
        }
        return new SemiAnalyticalKalmanEstimator(this.decomposer, this.dsstPropagatorBuilder, this.processNoiseMatrixProvider, this.estimatedMeasurementsParameters, this.measurementProcessNoiseMatrix);
    }

    public SemiAnalyticalKalmanEstimatorBuilder decomposer(MatrixDecomposer matrixDecomposer) {
        this.decomposer = matrixDecomposer;
        return this;
    }

    public SemiAnalyticalKalmanEstimatorBuilder addPropagationConfiguration(DSSTPropagatorBuilder builder, CovarianceMatrixProvider provider) {
        this.dsstPropagatorBuilder = builder;
        this.processNoiseMatrixProvider = provider;
        return this;
    }

    public SemiAnalyticalKalmanEstimatorBuilder estimatedMeasurementsParameters(ParameterDriversList estimatedMeasurementsParams, CovarianceMatrixProvider provider) {
        this.estimatedMeasurementsParameters = estimatedMeasurementsParams;
        this.measurementProcessNoiseMatrix = provider;
        return this;
    }
}

