/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.Range;
import org.orekit.estimation.measurements.modifiers.TroposphericGradientConverter;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;

public class RangeTroposphericDelayModifier
implements EstimationModifier<Range> {
    private final DiscreteTroposphericModel tropoModel;

    public RangeTroposphericDelayModifier(DiscreteTroposphericModel model) {
        this.tropoModel = model;
    }

    private double rangeErrorTroposphericModel(GroundStation station, SpacecraftState state) {
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation > 0.0) {
            double delay = this.tropoModel.pathDelay(elevation, station.getBaseFrame().getPoint(), this.tropoModel.getParameters(), state.getDate());
            return delay;
        }
        return 0.0;
    }

    private <T extends CalculusFieldElement<T>> T rangeErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        Field<T> field = state.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldVector3D position = state.getPVCoordinates().getPosition();
        Object elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation.getReal() > 0.0) {
            CalculusFieldElement delay = this.tropoModel.pathDelay((CalculusFieldElement)elevation, station.getBaseFrame().getPoint(field), (CalculusFieldElement[])parameters, state.getDate());
            return (T)delay;
        }
        return (T)zero;
    }

    private double[][] rangeErrorJacobianState(double[] derivatives) {
        double[][] finiteDifferencesJacobian = new double[1][6];
        System.arraycopy(derivatives, 0, finiteDifferencesJacobian[0], 0, 6);
        return finiteDifferencesJacobian;
    }

    private double rangeErrorParameterDerivative(final GroundStation station, ParameterDriver driver, final SpacecraftState state) {
        ParameterFunction rangeError = new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver) {
                return RangeTroposphericDelayModifier.this.rangeErrorTroposphericModel(station, state);
            }
        };
        ParameterFunction rangeErrorDerivative = Differentiation.differentiate(rangeError, 3, 10.0 * driver.getScale());
        return rangeErrorDerivative.value(driver);
    }

    private double[] rangeErrorParameterDerivative(double[] derivatives, int freeStateParameters) {
        int dim = derivatives.length - freeStateParameters;
        double[] rangeError = new double[dim];
        for (int i = 0; i < dim; ++i) {
            rangeError[i] = derivatives[freeStateParameters + i];
        }
        return rangeError;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }

    @Override
    public void modify(EstimatedMeasurement<Range> estimated) {
        double parameterDerivative;
        Range measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        TroposphericGradientConverter converter = new TroposphericGradientConverter(state, 6, new InertialProvider(state.getFrame()));
        FieldSpacecraftState<Gradient> gState = converter.getState(this.tropoModel);
        Gradient[] gParameters = converter.getParameters(gState, this.tropoModel);
        Gradient gDelay = (Gradient)this.rangeErrorTroposphericModel(station, gState, (CalculusFieldElement[])gParameters);
        double[] derivatives = gDelay.getGradient();
        double[][] djac = this.rangeErrorJacobianState(derivatives);
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + djac[irow][jcol];
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int index = 0;
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            double[] dDelaydP = this.rangeErrorParameterDerivative(derivatives, converter.getFreeStateParameters());
            estimated.setParameterDerivatives(driver, parameterDerivative += dDelaydP[index]);
            ++index;
        }
        for (ParameterDriver driver : Arrays.asList(station.getClockOffsetDriver(), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeErrorParameterDerivative(station, driver, state));
        }
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + gDelay.getReal();
        estimated.setEstimatedValue(newValue);
    }
}

