/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Incrementor;
import org.hipparchus.util.Pair;
import org.orekit.estimation.leastsquares.MeasurementHandler;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.leastsquares.PreCompensation;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.MatricesHarvester;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.PropagatorsParallelizer;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.propagation.integration.AbstractJacobiansMapper;
import org.orekit.propagation.sampling.MultiSatStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public abstract class AbstractBatchLSModel
implements MultivariateJacobianFunction {
    private final OrbitDeterminationPropagatorBuilder[] builders;
    private final ParameterDriversList[] estimatedOrbitalParameters;
    private final ParameterDriversList[] estimatedPropagationParameters;
    private final ParameterDriversList estimatedMeasurementsParameters;
    private final List<ObservedMeasurement<?>> measurements;
    private final int[] orbitsStartColumns;
    private final int[] orbitsEndColumns;
    private final Map<String, Integer> propagationParameterColumns;
    private final Map<String, Integer> measurementParameterColumns;
    private final Map<ObservedMeasurement<?>, EstimatedMeasurement<?>> evaluations;
    private final ModelObserver observer;
    private Incrementor evaluationsCounter;
    private Incrementor iterationsCounter;
    private AbsoluteDate firstDate;
    private AbsoluteDate lastDate;
    private final boolean forwardPropagation;
    private RealVector value;
    private final MatricesHarvester[] harvesters;
    private RealMatrix jacobian;

    @Deprecated
    public AbstractBatchLSModel(OrbitDeterminationPropagatorBuilder[] propagatorBuilders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, MatricesHarvester[] harvesters, ModelObserver observer) {
        this(propagatorBuilders, measurements, estimatedMeasurementsParameters, observer);
    }

    public AbstractBatchLSModel(OrbitDeterminationPropagatorBuilder[] propagatorBuilders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        this.builders = (OrbitDeterminationPropagatorBuilder[])propagatorBuilders.clone();
        this.measurements = measurements;
        this.estimatedMeasurementsParameters = estimatedMeasurementsParameters;
        this.measurementParameterColumns = new HashMap<String, Integer>(estimatedMeasurementsParameters.getDrivers().size());
        this.estimatedOrbitalParameters = new ParameterDriversList[this.builders.length];
        this.estimatedPropagationParameters = new ParameterDriversList[this.builders.length];
        this.evaluations = new IdentityHashMap(measurements.size());
        this.observer = observer;
        this.harvesters = new MatricesHarvester[this.builders.length];
        int rows = 0;
        for (ObservedMeasurement<?> measurement : measurements) {
            rows += measurement.getDimension();
        }
        this.orbitsStartColumns = new int[this.builders.length];
        this.orbitsEndColumns = new int[this.builders.length];
        int columns = 0;
        for (int i = 0; i < this.builders.length; ++i) {
            this.orbitsStartColumns[i] = columns;
            for (ParameterDriver parameterDriver : this.builders[i].getOrbitalParametersDrivers().getDrivers()) {
                if (!parameterDriver.isSelected()) continue;
                ++columns;
            }
            this.orbitsEndColumns[i] = columns;
        }
        ArrayList<String> estimatedPropagationParametersNames = new ArrayList<String>();
        for (int i = 0; i < this.builders.length; ++i) {
            for (ParameterDriversList.DelegatingDriver delegating : this.getSelectedPropagationDriversForBuilder(i).getDrivers()) {
                String driverName = delegating.getName();
                if (estimatedPropagationParametersNames.contains(driverName)) continue;
                estimatedPropagationParametersNames.add(driverName);
            }
        }
        this.propagationParameterColumns = new HashMap<String, Integer>(estimatedPropagationParametersNames.size());
        for (String string : estimatedPropagationParametersNames) {
            this.propagationParameterColumns.put(string, columns);
            ++columns;
        }
        for (ParameterDriver parameterDriver : estimatedMeasurementsParameters.getDrivers()) {
            this.measurementParameterColumns.put(parameterDriver.getName(), columns);
            ++columns;
        }
        this.value = new ArrayRealVector(rows);
        this.jacobian = MatrixUtils.createRealMatrix((int)rows, (int)columns);
        AbsoluteDate refDate = this.builders[0].getInitialOrbitDate();
        measurements.sort(new ChronologicalComparator());
        this.firstDate = measurements.get(0).getDate();
        this.lastDate = measurements.get(measurements.size() - 1).getDate();
        this.forwardPropagation = FastMath.abs((double)refDate.durationFrom(this.firstDate)) <= FastMath.abs((double)refDate.durationFrom(this.lastDate));
    }

    public void setEvaluationsCounter(Incrementor evaluationsCounter) {
        this.evaluationsCounter = evaluationsCounter;
    }

    public void setIterationsCounter(Incrementor iterationsCounter) {
        this.iterationsCounter = iterationsCounter;
    }

    public boolean isForwardPropagation() {
        return this.forwardPropagation;
    }

    protected MatricesHarvester configureHarvester(Propagator propagator) {
        return this.configureDerivatives(propagator);
    }

    @Deprecated
    protected abstract AbstractJacobiansMapper configureDerivatives(Propagator var1);

    protected abstract Orbit configureOrbits(MatricesHarvester var1, Propagator var2);

    public Pair<RealVector, RealMatrix> value(RealVector point) {
        Propagator[] propagators = this.createPropagators(point);
        Orbit[] orbits = new Orbit[propagators.length];
        for (int i = 0; i < propagators.length; ++i) {
            this.harvesters[i] = this.configureHarvester(propagators[i]);
            orbits[i] = this.configureOrbits(this.harvesters[i], propagators[i]);
        }
        PropagatorsParallelizer parallelizer = new PropagatorsParallelizer(Arrays.asList(propagators), this.configureMeasurements(point));
        this.evaluations.clear();
        this.value.set(0.0);
        for (int i = 0; i < this.jacobian.getRowDimension(); ++i) {
            for (int j = 0; j < this.jacobian.getColumnDimension(); ++j) {
                this.jacobian.setEntry(i, j, 0.0);
            }
        }
        if (this.isForwardPropagation()) {
            parallelizer.propagate(this.firstDate.shiftedBy(-1.0), this.lastDate.shiftedBy(1.0));
        } else {
            parallelizer.propagate(this.lastDate.shiftedBy(1.0), this.firstDate.shiftedBy(-1.0));
        }
        this.observer.modelCalled(orbits, this.evaluations);
        return new Pair((Object)this.value, (Object)this.jacobian);
    }

    public ParameterDriversList getSelectedOrbitalParametersDriversForBuilder(int iBuilder) {
        if (this.estimatedOrbitalParameters[iBuilder] == null) {
            ParameterDriversList selectedOrbitalDrivers = new ParameterDriversList();
            for (ParameterDriversList.DelegatingDriver delegating : this.builders[iBuilder].getOrbitalParametersDrivers().getDrivers()) {
                if (!delegating.isSelected()) continue;
                for (ParameterDriver driver : delegating.getRawDrivers()) {
                    selectedOrbitalDrivers.add(driver);
                }
            }
            this.estimatedOrbitalParameters[iBuilder] = selectedOrbitalDrivers;
        }
        return this.estimatedOrbitalParameters[iBuilder];
    }

    public ParameterDriversList getSelectedPropagationDriversForBuilder(int iBuilder) {
        if (this.estimatedPropagationParameters[iBuilder] == null) {
            ParameterDriversList selectedPropagationDrivers = new ParameterDriversList();
            for (ParameterDriversList.DelegatingDriver delegating : this.builders[iBuilder].getPropagationParametersDrivers().getDrivers()) {
                if (!delegating.isSelected()) continue;
                for (ParameterDriver driver : delegating.getRawDrivers()) {
                    selectedPropagationDrivers.add(driver);
                }
            }
            selectedPropagationDrivers.sort();
            this.estimatedPropagationParameters[iBuilder] = selectedPropagationDrivers;
        }
        return this.estimatedPropagationParameters[iBuilder];
    }

    public Propagator[] createPropagators(RealVector point) {
        Propagator[] propagators = new Propagator[this.builders.length];
        for (int i = 0; i < this.builders.length; ++i) {
            int j;
            int nbOrb = this.orbitsEndColumns[i] - this.orbitsStartColumns[i];
            ParameterDriversList selectedPropagationDrivers = this.getSelectedPropagationDriversForBuilder(i);
            int nbParams = selectedPropagationDrivers.getNbParams();
            double[] propagatorArray = new double[nbOrb + nbParams];
            for (j = 0; j < nbOrb; ++j) {
                propagatorArray[j] = point.getEntry(this.orbitsStartColumns[i] + j);
            }
            for (j = 0; j < nbParams; ++j) {
                propagatorArray[nbOrb + j] = point.getEntry(this.propagationParameterColumns.get(selectedPropagationDrivers.getDrivers().get(j).getName()).intValue());
            }
            propagators[i] = this.builders[i].buildPropagator(propagatorArray);
        }
        return propagators;
    }

    public void fetchEvaluatedMeasurement(int index, EstimatedMeasurement<?> evaluation) {
        SpacecraftState[] evaluationStates = evaluation.getStates();
        Object observedMeasurement = evaluation.getObservedMeasurement();
        this.evaluations.put((ObservedMeasurement<?>)observedMeasurement, evaluation);
        if (evaluation.getStatus() == EstimatedMeasurement.Status.REJECTED) {
            return;
        }
        double[] evaluated = evaluation.getEstimatedValue();
        double[] observed = observedMeasurement.getObservedValue();
        double[] sigma = observedMeasurement.getTheoreticalStandardDeviation();
        double[] weight = evaluation.getObservedMeasurement().getBaseWeight();
        for (int i = 0; i < evaluated.length; ++i) {
            this.value.setEntry(index + i, weight[i] * (evaluated[i] - observed[i]) / sigma[i]);
        }
        for (int k = 0; k < evaluationStates.length; ++k) {
            ParameterDriversList selectedPropagationDrivers;
            int nbParams;
            int p = observedMeasurement.getSatellites().get(k).getPropagatorIndex();
            double[][] aCY = new double[6][6];
            Orbit currentOrbit = evaluationStates[k].getOrbit();
            currentOrbit.getJacobianWrtParameters(this.builders[p].getPositionAngle(), aCY);
            Array2DRowRealMatrix dCdY = new Array2DRowRealMatrix(aCY, false);
            Array2DRowRealMatrix dMdC = new Array2DRowRealMatrix(evaluation.getStateDerivatives(k), false);
            RealMatrix dMdY = dMdC.multiply((RealMatrix)dCdY);
            ParameterDriversList selectedOrbitalDrivers = this.getSelectedOrbitalParametersDriversForBuilder(p);
            int nbOrbParams = selectedOrbitalDrivers.getNbParams();
            if (nbOrbParams > 0) {
                RealMatrix dYdY0 = this.harvesters[p].getStateTransitionMatrix(evaluationStates[k]);
                RealMatrix dMdY0 = dMdY.multiply(dYdY0);
                for (int i = 0; i < dMdY0.getRowDimension(); ++i) {
                    int jOrb = this.orbitsStartColumns[p];
                    for (int j = 0; j < dMdY0.getColumnDimension(); ++j) {
                        ParameterDriver driver = selectedOrbitalDrivers.getDrivers().get(j);
                        this.jacobian.setEntry(index + i, jOrb++, weight[i] * dMdY0.getEntry(i, j) / sigma[i] * driver.getScale());
                    }
                }
            }
            if ((nbParams = (selectedPropagationDrivers = this.getSelectedPropagationDriversForBuilder(p)).getNbParams()) <= 0) continue;
            RealMatrix dYdPp = this.harvesters[p].getParametersJacobian(evaluationStates[k]);
            RealMatrix dMdPp = dMdY.multiply(dYdPp);
            for (int i = 0; i < dMdPp.getRowDimension(); ++i) {
                for (int j = 0; j < nbParams; ++j) {
                    ParameterDriver delegating = selectedPropagationDrivers.getDrivers().get(j);
                    this.jacobian.addToEntry(index + i, this.propagationParameterColumns.get(delegating.getName()).intValue(), weight[i] * dMdPp.getEntry(i, j) / sigma[i] * delegating.getScale());
                }
            }
        }
        for (ParameterDriver driver : observedMeasurement.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            double[] aMPm = evaluation.getParameterDerivatives(driver);
            for (int i = 0; i < aMPm.length; ++i) {
                this.jacobian.setEntry(index + i, this.measurementParameterColumns.get(driver.getName()).intValue(), weight[i] * aMPm[i] / sigma[i] * driver.getScale());
            }
        }
    }

    private MultiSatStepHandler configureMeasurements(RealVector point) {
        int index = this.orbitsEndColumns[this.builders.length - 1] + this.propagationParameterColumns.size();
        for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
            parameterDriver.setNormalizedValue(point.getEntry(index++));
        }
        ArrayList<PreCompensation> precompensated = new ArrayList<PreCompensation>();
        for (ObservedMeasurement<?> measurement : this.measurements) {
            if (!measurement.isEnabled()) continue;
            precompensated.add(new PreCompensation(measurement, this.evaluations.get(measurement)));
        }
        precompensated.sort(new ChronologicalComparator());
        this.firstDate = ((PreCompensation)precompensated.get(0)).getDate();
        this.lastDate = ((PreCompensation)precompensated.get(precompensated.size() - 1)).getDate();
        if (!this.forwardPropagation) {
            Collections.reverse(precompensated);
        }
        return new MeasurementHandler(this, precompensated);
    }

    public int getIterationsCount() {
        return this.iterationsCounter.getCount();
    }

    public int getEvaluationsCount() {
        return this.evaluationsCounter.getCount();
    }
}

