/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.propagation.semianalytical.dsst.forces.ForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;

public class DSSTTesseralContext
extends ForceModelContext {
    private static final int I = 1;
    private double A;
    private double chi;
    private double chi2;
    private double theta;
    private double ax2oA;
    private double ooAB;
    private double BoA;
    private double BoABpo;
    private double Co2AB;
    private double moa;
    private double roa;
    private double e2;
    private double n;
    private double period;
    private double ratio;

    DSSTTesseralContext(AuxiliaryElements auxiliaryElements, Frame centralBodyFrame, UnnormalizedSphericalHarmonicsProvider provider, int maxFrequencyShortPeriodics, double bodyPeriod, double[] parameters) {
        super(auxiliaryElements);
        double mu = parameters[0];
        double absA = FastMath.abs((double)auxiliaryElements.getSma());
        this.n = FastMath.sqrt((double)(mu / absA)) / absA;
        double a = auxiliaryElements.getSma();
        this.period = a < 0.0 ? Double.POSITIVE_INFINITY : Math.PI * 2 * a * FastMath.sqrt((double)(a / mu));
        this.A = FastMath.sqrt((double)(mu * auxiliaryElements.getSma()));
        this.e2 = auxiliaryElements.getEcc() * auxiliaryElements.getEcc();
        Transform t = centralBodyFrame.getTransformTo(auxiliaryElements.getFrame(), auxiliaryElements.getDate());
        Vector3D xB = t.transformVector(Vector3D.PLUS_I);
        Vector3D yB = t.transformVector(Vector3D.PLUS_J);
        this.theta = FastMath.atan2((double)(-auxiliaryElements.getVectorF().dotProduct((Vector)yB) + 1.0 * auxiliaryElements.getVectorG().dotProduct((Vector)xB)), (double)(auxiliaryElements.getVectorF().dotProduct((Vector)xB) + 1.0 * auxiliaryElements.getVectorG().dotProduct((Vector)yB)));
        this.ax2oA = 2.0 * auxiliaryElements.getSma() / this.A;
        this.BoA = auxiliaryElements.getB() / this.A;
        this.ooAB = 1.0 / (this.A * auxiliaryElements.getB());
        this.Co2AB = auxiliaryElements.getC() * this.ooAB / 2.0;
        this.BoABpo = this.BoA / (1.0 + auxiliaryElements.getB());
        this.moa = mu / auxiliaryElements.getSma();
        this.roa = provider.getAe() / auxiliaryElements.getSma();
        this.chi = 1.0 / auxiliaryElements.getB();
        this.chi2 = this.chi * this.chi;
        this.ratio = this.period / bodyPeriod;
    }

    public double getE2() {
        return this.e2;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getAx2oA() {
        return this.ax2oA;
    }

    public double getChi() {
        return this.chi;
    }

    public double getChi2() {
        return this.chi2;
    }

    public double getBoA() {
        return this.BoA;
    }

    public double getOoAB() {
        return this.ooAB;
    }

    public double getCo2AB() {
        return this.Co2AB;
    }

    public double getBoABpo() {
        return this.BoABpo;
    }

    public double getMoa() {
        return this.moa;
    }

    public double getRoa() {
        return this.roa;
    }

    public double getOrbitPeriod() {
        return this.period;
    }

    public double getMeanMotion() {
        return this.n;
    }

    public double getRatio() {
        return this.ratio;
    }
}

