/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import org.hipparchus.linear.RealMatrix;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.semianalytical.dsst.DSSTStateTransitionMatrixGenerator;

class DSSTIntegrableJacobianColumnGenerator
implements AdditionalDerivativesProvider,
DSSTStateTransitionMatrixGenerator.DSSTPartialsObserver {
    private final String stmName;
    private final String columnName;
    private final double[] pDot;

    DSSTIntegrableJacobianColumnGenerator(DSSTStateTransitionMatrixGenerator stmGenerator, String columnName) {
        this.stmName = stmGenerator.getName();
        this.columnName = columnName;
        this.pDot = new double[this.getDimension()];
        stmGenerator.addObserver(columnName, this);
    }

    @Override
    public String getName() {
        return this.columnName;
    }

    @Override
    public int getDimension() {
        return 6;
    }

    @Override
    public boolean yield(SpacecraftState state) {
        return !state.hasAdditionalStateDerivative(this.stmName);
    }

    @Override
    public void partialsComputed(SpacecraftState state, RealMatrix factor, double[] meanElementsPartials) {
        double[] p = state.getAdditionalState(this.getName());
        System.arraycopy(factor.operate(p), 0, this.pDot, 0, this.pDot.length);
        for (int i = 0; i < this.pDot.length; ++i) {
            int n = i;
            this.pDot[n] = this.pDot[n] + meanElementsPartials[i];
        }
    }

    @Override
    public double[] derivatives(SpacecraftState s) {
        return this.pDot;
    }
}

