/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.util.ArithmeticUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldKeplerianOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.analytical.tle.FieldTLEPropagator;
import org.orekit.propagation.analytical.tle.ParseUtils;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeStamped;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.ParameterDriver;

public class FieldTLE<T extends CalculusFieldElement<T>>
implements FieldTimeStamped<T>,
Serializable {
    public static final int DEFAULT = 0;
    public static final int SGP = 1;
    public static final int SGP4 = 2;
    public static final int SDP4 = 3;
    public static final int SGP8 = 4;
    public static final int SDP8 = 5;
    public static final String B_STAR = "BSTAR";
    private static final double EPSILON_DEFAULT = 1.0E-10;
    private static final int MAX_ITERATIONS_DEFAULT = 100;
    private static final double B_STAR_SCALE = FastMath.scalb((double)1.0, (int)-20);
    private static final String MEAN_MOTION = "meanMotion";
    private static final String INCLINATION = "inclination";
    private static final String ECCENTRICITY = "eccentricity";
    private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final long serialVersionUID = -1596648022319057689L;
    private final int satelliteNumber;
    private final char classification;
    private final int launchYear;
    private final int launchNumber;
    private final String launchPiece;
    private final int ephemerisType;
    private final int elementNumber;
    private final transient FieldAbsoluteDate<T> epoch;
    private final T meanMotion;
    private final T meanMotionFirstDerivative;
    private final T meanMotionSecondDerivative;
    private final T eccentricity;
    private final T inclination;
    private final T pa;
    private final T raan;
    private final T meanAnomaly;
    private final int revolutionNumberAtEpoch;
    private String line1;
    private String line2;
    private final TimeScale utc;
    private final transient ParameterDriver bStarParameterDriver;

    @DefaultDataContext
    public FieldTLE(Field<T> field, String line1, String line2) {
        this(field, line1, line2, DataContext.getDefault().getTimeScales().getUTC());
    }

    public FieldTLE(Field<T> field, String line1, String line2, TimeScale utc) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement pi = (CalculusFieldElement)zero.getPi();
        this.satelliteNumber = ParseUtils.parseSatelliteNumber(line1, 2, 5);
        int satNum2 = ParseUtils.parseSatelliteNumber(line2, 2, 5);
        if (this.satelliteNumber != satNum2) {
            throw new OrekitException((Localizable)OrekitMessages.TLE_LINES_DO_NOT_REFER_TO_SAME_OBJECT, line1, line2);
        }
        this.classification = line1.charAt(7);
        this.launchYear = ParseUtils.parseYear(line1, 9);
        this.launchNumber = ParseUtils.parseInteger(line1, 11, 3);
        this.launchPiece = line1.substring(14, 17).trim();
        this.ephemerisType = ParseUtils.parseInteger(line1, 62, 1);
        this.elementNumber = ParseUtils.parseInteger(line1, 64, 4);
        int year = ParseUtils.parseYear(line1, 18);
        int dayInYear = ParseUtils.parseInteger(line1, 20, 3);
        long df = 27L * (long)ParseUtils.parseInteger(line1, 24, 8);
        int secondsA = (int)(df / 31250L);
        double secondsB = (double)(df % 31250L) / 31250.0;
        this.epoch = new FieldAbsoluteDate<T>(field, new DateComponents(year, dayInYear), new TimeComponents(secondsA, secondsB), utc);
        this.meanMotion = (CalculusFieldElement)((CalculusFieldElement)pi.multiply(ParseUtils.parseDouble(line2, 52, 11))).divide(43200.0);
        this.meanMotionFirstDerivative = (CalculusFieldElement)((CalculusFieldElement)pi.multiply(ParseUtils.parseDouble(line1, 33, 10))).divide(1.86624E9);
        this.meanMotionSecondDerivative = (CalculusFieldElement)((CalculusFieldElement)pi.multiply(Double.parseDouble((line1.substring(44, 45) + '.' + line1.substring(45, 50) + 'e' + line1.substring(50, 52)).replace(' ', '0')))).divide(5.3747712E13);
        this.eccentricity = (CalculusFieldElement)zero.add(Double.parseDouble("." + line2.substring(26, 33).replace(' ', '0')));
        this.inclination = (CalculusFieldElement)zero.add(FastMath.toRadians((double)ParseUtils.parseDouble(line2, 8, 8)));
        this.pa = (CalculusFieldElement)zero.add(FastMath.toRadians((double)ParseUtils.parseDouble(line2, 34, 8)));
        this.raan = (CalculusFieldElement)zero.add(FastMath.toRadians((double)Double.parseDouble(line2.substring(17, 25).replace(' ', '0'))));
        this.meanAnomaly = (CalculusFieldElement)zero.add(FastMath.toRadians((double)ParseUtils.parseDouble(line2, 43, 8)));
        this.revolutionNumberAtEpoch = ParseUtils.parseInteger(line2, 63, 5);
        double bStarValue = Double.parseDouble((line1.substring(53, 54) + '.' + line1.substring(54, 59) + 'e' + line1.substring(59, 61)).replace(' ', '0'));
        this.line1 = line1;
        this.line2 = line2;
        this.utc = utc;
        this.bStarParameterDriver = new ParameterDriver(B_STAR, bStarValue, B_STAR_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @DefaultDataContext
    public FieldTLE(int satelliteNumber, char classification, int launchYear, int launchNumber, String launchPiece, int ephemerisType, int elementNumber, FieldAbsoluteDate<T> epoch, T meanMotion, T meanMotionFirstDerivative, T meanMotionSecondDerivative, T e, T i, T pa, T raan, T meanAnomaly, int revolutionNumberAtEpoch, double bStar) {
        this(satelliteNumber, classification, launchYear, launchNumber, launchPiece, ephemerisType, elementNumber, epoch, meanMotion, meanMotionFirstDerivative, meanMotionSecondDerivative, e, i, pa, raan, meanAnomaly, revolutionNumberAtEpoch, bStar, DataContext.getDefault().getTimeScales().getUTC());
    }

    public FieldTLE(int satelliteNumber, char classification, int launchYear, int launchNumber, String launchPiece, int ephemerisType, int elementNumber, FieldAbsoluteDate<T> epoch, T meanMotion, T meanMotionFirstDerivative, T meanMotionSecondDerivative, T e, T i, T pa, T raan, T meanAnomaly, int revolutionNumberAtEpoch, double bStar, TimeScale utc) {
        CalculusFieldElement pi = (CalculusFieldElement)e.getPi();
        this.satelliteNumber = satelliteNumber;
        this.classification = classification;
        this.launchYear = launchYear;
        this.launchNumber = launchNumber;
        this.launchPiece = launchPiece;
        this.ephemerisType = ephemerisType;
        this.elementNumber = elementNumber;
        this.epoch = epoch;
        this.meanMotion = meanMotion;
        this.meanMotionFirstDerivative = meanMotionFirstDerivative;
        this.meanMotionSecondDerivative = meanMotionSecondDerivative;
        this.inclination = i;
        this.raan = MathUtils.normalizeAngle(raan, (CalculusFieldElement)pi);
        this.eccentricity = e;
        this.pa = MathUtils.normalizeAngle(pa, (CalculusFieldElement)pi);
        this.meanAnomaly = MathUtils.normalizeAngle(meanAnomaly, (CalculusFieldElement)pi);
        this.revolutionNumberAtEpoch = revolutionNumberAtEpoch;
        this.bStarParameterDriver = new ParameterDriver(B_STAR, bStar, B_STAR_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.line1 = null;
        this.line2 = null;
        this.utc = utc;
    }

    TimeScale getUtc() {
        return this.utc;
    }

    public String getLine1() {
        if (this.line1 == null) {
            this.buildLine1();
        }
        return this.line1;
    }

    public String getLine2() {
        if (this.line2 == null) {
            this.buildLine2();
        }
        return this.line2;
    }

    private void buildLine1() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('1');
        buffer.append(' ');
        buffer.append(ParseUtils.buildSatelliteNumber(this.satelliteNumber, "satelliteNumber-1"));
        buffer.append(this.classification);
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding("launchYear", this.launchYear % 100, '0', 2, true, this.satelliteNumber));
        buffer.append(ParseUtils.addPadding("launchNumber", this.launchNumber, '0', 3, true, this.satelliteNumber));
        buffer.append(ParseUtils.addPadding("launchPiece", this.launchPiece, ' ', 3, false, this.satelliteNumber));
        buffer.append(' ');
        DateTimeComponents dtc = this.epoch.getComponents(this.utc);
        buffer.append(ParseUtils.addPadding("year", dtc.getDate().getYear() % 100, '0', 2, true, this.satelliteNumber));
        buffer.append(ParseUtils.addPadding("day", dtc.getDate().getDayOfYear(), '0', 3, true, this.satelliteNumber));
        buffer.append('.');
        int fraction = (int)FastMath.rint((double)(31250.0 * dtc.getTime().getSecondsInUTCDay() / 27.0));
        buffer.append(ParseUtils.addPadding("fraction", fraction, '0', 8, true, this.satelliteNumber));
        buffer.append(' ');
        double n1 = ((CalculusFieldElement)((CalculusFieldElement)this.meanMotionFirstDerivative.divide(this.pa.getPi())).multiply(1.86624E9)).getReal();
        String sn1 = ParseUtils.addPadding("meanMotionFirstDerivative", new DecimalFormat(".00000000", SYMBOLS).format(n1), ' ', 10, true, this.satelliteNumber);
        buffer.append(sn1);
        buffer.append(' ');
        double n2 = ((CalculusFieldElement)((CalculusFieldElement)this.meanMotionSecondDerivative.divide(this.pa.getPi())).multiply(5.3747712E13)).getReal();
        buffer.append(this.formatExponentMarkerFree("meanMotionSecondDerivative", n2, 5, ' ', 8, true));
        buffer.append(' ');
        buffer.append(this.formatExponentMarkerFree("B*", this.getBStar(), 5, ' ', 8, true));
        buffer.append(' ');
        buffer.append(this.ephemerisType);
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding("elementNumber", this.elementNumber, ' ', 4, true, this.satelliteNumber));
        buffer.append(Integer.toString(FieldTLE.checksum(buffer)));
        this.line1 = buffer.toString();
    }

    private String formatExponentMarkerFree(String name, double d, int mantissaSize, char c, int size, boolean rightJustified) {
        double dAbs;
        int exponent = (dAbs = FastMath.abs((double)d)) < 1.0E-9 ? -9 : (int)FastMath.ceil((double)FastMath.log10((double)dAbs));
        long mantissa = FastMath.round((double)(dAbs * FastMath.pow((double)10.0, (int)(mantissaSize - exponent))));
        if (mantissa == 0L) {
            exponent = 0;
        } else if (mantissa > (long)(ArithmeticUtils.pow((int)10, (int)mantissaSize) - 1)) {
            mantissa = FastMath.round((double)(dAbs * FastMath.pow((double)10.0, (int)(mantissaSize - ++exponent))));
        }
        String sMantissa = ParseUtils.addPadding(name, (int)mantissa, '0', mantissaSize, true, this.satelliteNumber);
        String sExponent = Integer.toString(FastMath.abs((int)exponent));
        String formatted = (d < 0.0 ? (char)'-' : ' ') + sMantissa + (exponent <= 0 ? (char)'-' : '+') + sExponent;
        return ParseUtils.addPadding(name, formatted, c, size, rightJustified, this.satelliteNumber);
    }

    private void buildLine2() {
        StringBuilder buffer = new StringBuilder();
        DecimalFormat f34 = new DecimalFormat("##0.0000", SYMBOLS);
        DecimalFormat f211 = new DecimalFormat("#0.00000000", SYMBOLS);
        buffer.append('2');
        buffer.append(' ');
        buffer.append(ParseUtils.buildSatelliteNumber(this.satelliteNumber, "satelliteNumber-2"));
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding(INCLINATION, f34.format(FastMath.toDegrees(this.inclination).getReal()), ' ', 8, true, this.satelliteNumber));
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding("raan", f34.format(FastMath.toDegrees(this.raan).getReal()), ' ', 8, true, this.satelliteNumber));
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding(ECCENTRICITY, (int)FastMath.rint((double)(this.eccentricity.getReal() * 1.0E7)), '0', 7, true, this.satelliteNumber));
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding("pa", f34.format(FastMath.toDegrees(this.pa).getReal()), ' ', 8, true, this.satelliteNumber));
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding("meanAnomaly", f34.format(FastMath.toDegrees(this.meanAnomaly).getReal()), ' ', 8, true, this.satelliteNumber));
        buffer.append(' ');
        buffer.append(ParseUtils.addPadding(MEAN_MOTION, f211.format(((CalculusFieldElement)((CalculusFieldElement)this.meanMotion.divide(this.pa.getPi())).multiply(43200.0)).getReal()), ' ', 11, true, this.satelliteNumber));
        buffer.append(ParseUtils.addPadding("revolutionNumberAtEpoch", this.revolutionNumberAtEpoch, ' ', 5, true, this.satelliteNumber));
        buffer.append(Integer.toString(FieldTLE.checksum(buffer)));
        this.line2 = buffer.toString();
    }

    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.bStarParameterDriver);
    }

    public T[] getParameters(Field<T> field) {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        CalculusFieldElement[] parameters = (CalculusFieldElement[])MathArrays.buildArray(field, (int)drivers.size());
        int i = 0;
        for (ParameterDriver driver : drivers) {
            parameters[i++] = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(driver.getValue());
        }
        return parameters;
    }

    public int getSatelliteNumber() {
        return this.satelliteNumber;
    }

    public char getClassification() {
        return this.classification;
    }

    public int getLaunchYear() {
        return this.launchYear;
    }

    public int getLaunchNumber() {
        return this.launchNumber;
    }

    public String getLaunchPiece() {
        return this.launchPiece;
    }

    public int getEphemerisType() {
        return this.ephemerisType;
    }

    public int getElementNumber() {
        return this.elementNumber;
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.epoch;
    }

    public T getMeanMotion() {
        return this.meanMotion;
    }

    public T getMeanMotionFirstDerivative() {
        return this.meanMotionFirstDerivative;
    }

    public T getMeanMotionSecondDerivative() {
        return this.meanMotionSecondDerivative;
    }

    public T getE() {
        return this.eccentricity;
    }

    public T getI() {
        return this.inclination;
    }

    public T getPerigeeArgument() {
        return this.pa;
    }

    public T getRaan() {
        return this.raan;
    }

    public T getMeanAnomaly() {
        return this.meanAnomaly;
    }

    public int getRevolutionNumberAtEpoch() {
        return this.revolutionNumberAtEpoch;
    }

    public double getBStar() {
        return this.bStarParameterDriver.getValue();
    }

    public String toString() {
        try {
            return this.getLine1() + System.getProperty("line.separator") + this.getLine2();
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldTLE<T> stateToTLE(FieldSpacecraftState<T> state, FieldTLE<T> templateTLE) {
        return FieldTLE.stateToTLE(state, templateTLE, DataContext.getDefault().getTimeScales().getUTC(), DataContext.getDefault().getFrames().getTEME());
    }

    public static <T extends CalculusFieldElement<T>> FieldTLE<T> stateToTLE(FieldSpacecraftState<T> state, FieldTLE<T> templateTLE, TimeScale utc, Frame teme) {
        return FieldTLE.stateToTLE(state, templateTLE, utc, teme, 1.0E-10, 100);
    }

    public static <T extends CalculusFieldElement<T>> FieldTLE<T> stateToTLE(FieldSpacecraftState<T> state, FieldTLE<T> templateTLE, TimeScale utc, Frame teme, double epsilon, int maxIterations) {
        FieldEquinoctialOrbit<T> equiOrbit = FieldTLE.convert(state.getOrbit(), teme);
        Object sma = equiOrbit.getA();
        Object ex = equiOrbit.getEquinoctialEx();
        Object ey = equiOrbit.getEquinoctialEy();
        Object hx = equiOrbit.getHx();
        Object hy = equiOrbit.getHy();
        Object lv = equiOrbit.getLv();
        FieldKeplerianOrbit keplerianOrbit = (FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(equiOrbit);
        FieldTLE<T> current = FieldTLE.newTLE(keplerianOrbit, templateTLE, utc);
        Field<T> field = state.getDate().getField();
        CalculusFieldElement thrA = (CalculusFieldElement)((CalculusFieldElement)sma.add(1.0)).multiply(epsilon);
        CalculusFieldElement thrE = (CalculusFieldElement)((CalculusFieldElement)FastMath.hypot(ex, ey).add(1.0)).multiply(epsilon);
        CalculusFieldElement thrH = (CalculusFieldElement)((CalculusFieldElement)FastMath.hypot(hx, hy).add(1.0)).multiply(epsilon);
        CalculusFieldElement thrV = (CalculusFieldElement)((CalculusFieldElement)sma.getPi()).multiply(epsilon);
        int k = 0;
        while (k++ < maxIterations) {
            FieldTLEPropagator propagator = FieldTLEPropagator.selectExtrapolator(current, (AttitudeProvider)new InertialProvider(Rotation.IDENTITY, teme), state.getMass(), (Frame)teme, (CalculusFieldElement[])templateTLE.getParameters(field));
            FieldOrbit recovOrbit = propagator.getInitialState().getOrbit();
            FieldEquinoctialOrbit recovEquiOrbit = (FieldEquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(recovOrbit);
            CalculusFieldElement deltaSma = (CalculusFieldElement)equiOrbit.getA().subtract(recovEquiOrbit.getA());
            CalculusFieldElement deltaEx = (CalculusFieldElement)equiOrbit.getEquinoctialEx().subtract(recovEquiOrbit.getEquinoctialEx());
            CalculusFieldElement deltaEy = (CalculusFieldElement)equiOrbit.getEquinoctialEy().subtract(recovEquiOrbit.getEquinoctialEy());
            CalculusFieldElement deltaHx = (CalculusFieldElement)equiOrbit.getHx().subtract(recovEquiOrbit.getHx());
            CalculusFieldElement deltaHy = (CalculusFieldElement)equiOrbit.getHy().subtract(recovEquiOrbit.getHy());
            CalculusFieldElement deltaLv = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)equiOrbit.getLv().subtract(recovEquiOrbit.getLv())), (CalculusFieldElement)((CalculusFieldElement)field.getZero()));
            if (FastMath.abs((double)deltaSma.getReal()) < thrA.getReal() && FastMath.abs((double)deltaEx.getReal()) < thrE.getReal() && FastMath.abs((double)deltaEy.getReal()) < thrE.getReal() && FastMath.abs((double)deltaHx.getReal()) < thrH.getReal() && FastMath.abs((double)deltaHy.getReal()) < thrH.getReal() && FastMath.abs((double)deltaLv.getReal()) < thrV.getReal()) {
                return current;
            }
            sma = (CalculusFieldElement)sma.add((FieldElement)deltaSma);
            ex = (CalculusFieldElement)ex.add((FieldElement)deltaEx);
            ey = (CalculusFieldElement)ey.add((FieldElement)deltaEy);
            hx = (CalculusFieldElement)hx.add((FieldElement)deltaHx);
            hy = (CalculusFieldElement)hy.add((FieldElement)deltaHy);
            lv = (CalculusFieldElement)lv.add((FieldElement)deltaLv);
            FieldEquinoctialOrbit<T> newEquiOrbit = new FieldEquinoctialOrbit<T>(sma, ex, ey, hx, hy, lv, PositionAngle.TRUE, equiOrbit.getFrame(), equiOrbit.getDate(), equiOrbit.getMu());
            FieldKeplerianOrbit newKeplOrbit = (FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(newEquiOrbit);
            current = FieldTLE.newTLE(newKeplOrbit, templateTLE, utc);
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_TLE, k);
    }

    private static <T extends CalculusFieldElement<T>> FieldEquinoctialOrbit<T> convert(FieldOrbit<T> orbitIn, Frame teme) {
        return new FieldEquinoctialOrbit<T>(orbitIn.getPVCoordinates(teme), teme, orbitIn.getMu());
    }

    private static <T extends CalculusFieldElement<T>> FieldTLE<T> newTLE(FieldKeplerianOrbit<T> keplerianOrbit, FieldTLE<T> templateTLE, TimeScale utc) {
        Object meanMotion = keplerianOrbit.getKeplerianMeanMotion();
        T e = keplerianOrbit.getE();
        T i = keplerianOrbit.getI();
        T raan = keplerianOrbit.getRightAscensionOfAscendingNode();
        T pa = keplerianOrbit.getPerigeeArgument();
        T meanAnomaly = keplerianOrbit.getMeanAnomaly();
        FieldAbsoluteDate<T> epoch = keplerianOrbit.getDate();
        int satelliteNumber = templateTLE.getSatelliteNumber();
        char classification = templateTLE.getClassification();
        int launchYear = templateTLE.getLaunchYear();
        int launchNumber = templateTLE.getLaunchNumber();
        String launchPiece = templateTLE.getLaunchPiece();
        int ephemerisType = templateTLE.getEphemerisType();
        int elementNumber = templateTLE.getElementNumber();
        int revolutionNumberAtEpoch = templateTLE.getRevolutionNumberAtEpoch();
        Object dt = epoch.durationFrom(templateTLE.getDate());
        int newRevolutionNumberAtEpoch = (int)((double)revolutionNumberAtEpoch + FastMath.floor((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)MathUtils.normalizeAngle(meanAnomaly, (CalculusFieldElement)((CalculusFieldElement)e.getPi())).add(dt.multiply(meanMotion))).divide(((CalculusFieldElement)e.getPi()).multiply(2.0)))).getReal());
        double bStar = templateTLE.getBStar();
        T meanMotionFirstDerivative = templateTLE.getMeanMotionFirstDerivative();
        T meanMotionSecondDerivative = templateTLE.getMeanMotionSecondDerivative();
        return new FieldTLE(satelliteNumber, classification, launchYear, launchNumber, launchPiece, ephemerisType, elementNumber, epoch, meanMotion, meanMotionFirstDerivative, meanMotionSecondDerivative, e, i, pa, raan, meanAnomaly, newRevolutionNumberAtEpoch, bStar, utc);
    }

    public static boolean isFormatOK(String line1, String line2) {
        return TLE.isFormatOK(line1, line2);
    }

    private static int checksum(CharSequence line) {
        int sum = 0;
        for (int j = 0; j < 68; ++j) {
            char c = line.charAt(j);
            if (Character.isDigit(c)) {
                sum += Character.digit(c, 10);
                continue;
            }
            if (c != '-') continue;
            ++sum;
        }
        return sum % 10;
    }

    public TLE toTLE() {
        TLE regularTLE = new TLE(this.getSatelliteNumber(), this.getClassification(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getEphemerisType(), this.getElementNumber(), this.getDate().toAbsoluteDate(), this.getMeanMotion().getReal(), this.getMeanMotionFirstDerivative().getReal(), this.getMeanMotionSecondDerivative().getReal(), this.getE().getReal(), this.getI().getReal(), this.getPerigeeArgument().getReal(), this.getRaan().getReal(), this.getMeanAnomaly().getReal(), this.getRevolutionNumberAtEpoch(), this.getBStar(), this.getUtc());
        for (int k = 0; k < regularTLE.getParametersDrivers().size(); ++k) {
            regularTLE.getParametersDrivers().get(k).setSelected(this.getParametersDrivers().get(k).isSelected());
        }
        return regularTLE;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldTLE)) {
            return false;
        }
        FieldTLE tle = (FieldTLE)o;
        return this.satelliteNumber == tle.satelliteNumber && this.classification == tle.classification && this.launchYear == tle.launchYear && this.launchNumber == tle.launchNumber && Objects.equals(this.launchPiece, tle.launchPiece) && this.ephemerisType == tle.ephemerisType && this.elementNumber == tle.elementNumber && Objects.equals(this.epoch, tle.epoch) && this.meanMotion.getReal() == tle.meanMotion.getReal() && this.meanMotionFirstDerivative.getReal() == tle.meanMotionFirstDerivative.getReal() && this.meanMotionSecondDerivative.getReal() == tle.meanMotionSecondDerivative.getReal() && this.eccentricity.getReal() == tle.eccentricity.getReal() && this.inclination.getReal() == tle.inclination.getReal() && this.pa.getReal() == tle.pa.getReal() && this.raan.getReal() == tle.raan.getReal() && this.meanAnomaly.getReal() == tle.meanAnomaly.getReal() && this.revolutionNumberAtEpoch == tle.revolutionNumberAtEpoch && this.getBStar() == tle.getBStar();
    }

    public int hashCode() {
        return Objects.hash(this.satelliteNumber, Character.valueOf(this.classification), this.launchYear, this.launchNumber, this.launchPiece, this.ephemerisType, this.elementNumber, this.epoch, this.meanMotion, this.meanMotionFirstDerivative, this.meanMotionSecondDerivative, this.eccentricity, this.inclination, this.pa, this.raan, this.meanAnomaly, this.revolutionNumberAtEpoch, this.getBStar());
    }
}

