/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative1;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldEquinoctialOrbit<T extends CalculusFieldElement<T>>
extends FieldOrbit<T> {
    private final T a;
    private final T ex;
    private final T ey;
    private final T hx;
    private final T hy;
    private final T lv;
    private final T aDot;
    private final T exDot;
    private final T eyDot;
    private final T hxDot;
    private final T hyDot;
    private final T lvDot;
    private FieldPVCoordinates<T> partialPV;
    private Field<T> field;
    private T zero;
    private T one;

    public FieldEquinoctialOrbit(T a, T ex, T ey, T hx, T hy, T l, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, ex, ey, hx, hy, l, null, null, null, null, null, null, type, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldEquinoctialOrbit(T a, T ex, T ey, T hx, T hy, T l, T aDot, T exDot, T eyDot, T hxDot, T hyDot, T lDot, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        super(frame, date, mu);
        this.field = a.getField();
        this.zero = (CalculusFieldElement)this.field.getZero();
        this.one = (CalculusFieldElement)this.field.getOne();
        if (ex.getReal() * ex.getReal() + ey.getReal() * ey.getReal() >= 1.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        this.a = a;
        this.aDot = aDot;
        this.ex = ex;
        this.exDot = exDot;
        this.ey = ey;
        this.eyDot = eyDot;
        this.hx = hx;
        this.hxDot = hxDot;
        this.hy = hy;
        this.hyDot = hyDot;
        if (this.hasDerivatives()) {
            FieldUnivariateDerivative1 lvUD;
            FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(ex, exDot);
            FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(ey, eyDot);
            FieldUnivariateDerivative1 lUD = new FieldUnivariateDerivative1(l, lDot);
            switch (type) {
                case MEAN: {
                    lvUD = FieldEquinoctialOrbit.eccentricToTrue(FieldEquinoctialOrbit.meanToEccentric(lUD, exUD, eyUD), exUD, eyUD);
                    break;
                }
                case ECCENTRIC: {
                    lvUD = FieldEquinoctialOrbit.eccentricToTrue(lUD, exUD, eyUD);
                    break;
                }
                case TRUE: {
                    lvUD = lUD;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.lv = lvUD.getValue();
            this.lvDot = lvUD.getDerivative(1);
        } else {
            switch (type) {
                case MEAN: {
                    this.lv = FieldEquinoctialOrbit.eccentricToTrue(FieldEquinoctialOrbit.meanToEccentric(l, ex, ey), ex, ey);
                    break;
                }
                case ECCENTRIC: {
                    this.lv = FieldEquinoctialOrbit.eccentricToTrue(l, ex, ey);
                    break;
                }
                case TRUE: {
                    this.lv = l;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.lvDot = null;
        }
        this.partialPV = null;
    }

    public FieldEquinoctialOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
        this.field = pvCoordinates.getPosition().getX().getField();
        this.zero = (CalculusFieldElement)this.field.getZero();
        this.one = (CalculusFieldElement)this.field.getOne();
        FieldVector3D pvP = pvCoordinates.getPosition();
        FieldVector3D pvV = pvCoordinates.getVelocity();
        FieldVector3D pvA = pvCoordinates.getAcceleration();
        CalculusFieldElement r2 = pvP.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement V2 = pvV.getNormSq();
        CalculusFieldElement rV2OnMu = (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)V2)).divide(mu);
        if (rV2OnMu.getReal() > 2.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        FieldVector3D w = pvCoordinates.getMomentum().normalize();
        CalculusFieldElement d = (CalculusFieldElement)this.one.divide(this.one.add((FieldElement)w.getZ()));
        this.hx = (CalculusFieldElement)((CalculusFieldElement)d.negate()).multiply((FieldElement)w.getY());
        this.hy = (CalculusFieldElement)d.multiply((FieldElement)w.getX());
        CalculusFieldElement cLv = (CalculusFieldElement)((CalculusFieldElement)pvP.getX().subtract(((CalculusFieldElement)d.multiply((FieldElement)pvP.getZ())).multiply((FieldElement)w.getX()))).divide((FieldElement)r);
        CalculusFieldElement sLv = (CalculusFieldElement)((CalculusFieldElement)pvP.getY().subtract(((CalculusFieldElement)d.multiply((FieldElement)pvP.getZ())).multiply((FieldElement)w.getY()))).divide((FieldElement)r);
        this.lv = (CalculusFieldElement)sLv.atan2((FieldElement)cLv);
        this.a = (CalculusFieldElement)r.divide(((CalculusFieldElement)rV2OnMu.negate()).add(2.0));
        CalculusFieldElement eSE = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((CalculusFieldElement)this.a.multiply(mu)).sqrt());
        CalculusFieldElement eCE = (CalculusFieldElement)rV2OnMu.subtract(1.0);
        CalculusFieldElement e2 = (CalculusFieldElement)((CalculusFieldElement)eCE.multiply((FieldElement)eCE)).add(eSE.multiply((FieldElement)eSE));
        CalculusFieldElement f = (CalculusFieldElement)eCE.subtract((FieldElement)e2);
        CalculusFieldElement g = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).sqrt()).multiply((FieldElement)eSE);
        this.ex = (CalculusFieldElement)((CalculusFieldElement)this.a.multiply(((CalculusFieldElement)f.multiply((FieldElement)cLv)).add(g.multiply((FieldElement)sLv)))).divide((FieldElement)r);
        this.ey = (CalculusFieldElement)((CalculusFieldElement)this.a.multiply(((CalculusFieldElement)f.multiply((FieldElement)sLv)).subtract(g.multiply((FieldElement)cLv)))).divide((FieldElement)r);
        this.partialPV = pvCoordinates;
        if (FieldEquinoctialOrbit.hasNonKeplerianAcceleration(pvCoordinates, mu)) {
            CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
            this.getJacobianWrtCartesian(PositionAngle.MEAN, jacobian);
            FieldVector3D keplerianAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)r2)).reciprocal()).multiply(mu.negate()), pvP);
            FieldVector3D nonKeplerianAcceleration = pvA.subtract(keplerianAcceleration);
            CalculusFieldElement aX = nonKeplerianAcceleration.getX();
            CalculusFieldElement aY = nonKeplerianAcceleration.getY();
            CalculusFieldElement aZ = nonKeplerianAcceleration.getZ();
            this.aDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[0][3].multiply((FieldElement)aX)).add(jacobian[0][4].multiply((FieldElement)aY))).add(jacobian[0][5].multiply((FieldElement)aZ));
            this.exDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[1][3].multiply((FieldElement)aX)).add(jacobian[1][4].multiply((FieldElement)aY))).add(jacobian[1][5].multiply((FieldElement)aZ));
            this.eyDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[2][3].multiply((FieldElement)aX)).add(jacobian[2][4].multiply((FieldElement)aY))).add(jacobian[2][5].multiply((FieldElement)aZ));
            this.hxDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[3][3].multiply((FieldElement)aX)).add(jacobian[3][4].multiply((FieldElement)aY))).add(jacobian[3][5].multiply((FieldElement)aZ));
            this.hyDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[4][3].multiply((FieldElement)aX)).add(jacobian[4][4].multiply((FieldElement)aY))).add(jacobian[4][5].multiply((FieldElement)aZ));
            CalculusFieldElement lMDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getKeplerianMeanMotion().add(jacobian[5][3].multiply((FieldElement)aX))).add(jacobian[5][4].multiply((FieldElement)aY))).add(jacobian[5][5].multiply((FieldElement)aZ));
            FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
            FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
            FieldUnivariateDerivative1 lMUD = new FieldUnivariateDerivative1(this.getLM(), lMDot);
            FieldUnivariateDerivative1 lvUD = FieldEquinoctialOrbit.eccentricToTrue(FieldEquinoctialOrbit.meanToEccentric(lMUD, exUD, eyUD), exUD, eyUD);
            this.lvDot = lvUD.getDerivative(1);
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.hxDot = null;
            this.hyDot = null;
            this.lvDot = null;
        }
    }

    public FieldEquinoctialOrbit(FieldPVCoordinates<T> pvCoordinates, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, pvCoordinates), frame, mu);
    }

    public FieldEquinoctialOrbit(FieldOrbit<T> op) {
        super(op.getFrame(), op.getDate(), op.getMu());
        this.a = op.getA();
        this.ex = op.getEquinoctialEx();
        this.ey = op.getEquinoctialEy();
        this.hx = op.getHx();
        this.hy = op.getHy();
        this.lv = op.getLv();
        this.aDot = op.getADot();
        this.exDot = op.getEquinoctialExDot();
        this.eyDot = op.getEquinoctialEyDot();
        this.hxDot = op.getHxDot();
        this.hyDot = op.getHyDot();
        this.lvDot = op.getLvDot();
        this.field = this.a.getField();
        this.zero = (CalculusFieldElement)this.field.getZero();
        this.one = (CalculusFieldElement)this.field.getOne();
    }

    @Override
    public OrbitType getType() {
        return OrbitType.EQUINOCTIAL;
    }

    @Override
    public T getA() {
        return this.a;
    }

    @Override
    public T getADot() {
        return this.aDot;
    }

    @Override
    public T getEquinoctialEx() {
        return this.ex;
    }

    @Override
    public T getEquinoctialExDot() {
        return this.exDot;
    }

    @Override
    public T getEquinoctialEy() {
        return this.ey;
    }

    @Override
    public T getEquinoctialEyDot() {
        return this.eyDot;
    }

    @Override
    public T getHx() {
        return this.hx;
    }

    @Override
    public T getHxDot() {
        return this.hxDot;
    }

    @Override
    public T getHy() {
        return this.hy;
    }

    @Override
    public T getHyDot() {
        return this.hyDot;
    }

    @Override
    public T getLv() {
        return this.lv;
    }

    @Override
    public T getLvDot() {
        return this.lvDot;
    }

    @Override
    public T getLE() {
        return FieldEquinoctialOrbit.trueToEccentric(this.lv, this.ex, this.ey);
    }

    @Override
    public T getLEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldUnivariateDerivative1 lVUD = new FieldUnivariateDerivative1(this.lv, this.lvDot);
        FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
        FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
        FieldUnivariateDerivative1 lEUD = FieldEquinoctialOrbit.trueToEccentric(lVUD, exUD, eyUD);
        return (T)lEUD.getDerivative(1);
    }

    @Override
    public T getLM() {
        return FieldEquinoctialOrbit.eccentricToMean(FieldEquinoctialOrbit.trueToEccentric(this.lv, this.ex, this.ey), this.ex, this.ey);
    }

    @Override
    public T getLMDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldUnivariateDerivative1 lVUD = new FieldUnivariateDerivative1(this.lv, this.lvDot);
        FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
        FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
        FieldUnivariateDerivative1 lMUD = FieldEquinoctialOrbit.eccentricToMean(FieldEquinoctialOrbit.trueToEccentric(lVUD, exUD, eyUD), exUD, eyUD);
        return (T)lMUD.getDerivative(1);
    }

    public T getL(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getLM() : (type == PositionAngle.ECCENTRIC ? this.getLE() : this.getLv());
    }

    public T getLDot(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getLMDot() : (type == PositionAngle.ECCENTRIC ? this.getLEDot() : this.getLvDot());
    }

    @Override
    public boolean hasDerivatives() {
        return this.aDot != null;
    }

    public static <T extends CalculusFieldElement<T>> T eccentricToTrue(T lE, T ex, T ey) {
        CalculusFieldElement epsilon = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.multiply(ex)).add(ey.multiply(ey))).negate()).add(1.0)).sqrt();
        FieldSinCos scLE = FastMath.sinCos(lE);
        CalculusFieldElement cosLE = (CalculusFieldElement)scLE.cos();
        CalculusFieldElement sinLE = (CalculusFieldElement)scLE.sin();
        CalculusFieldElement num = (CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)sinLE)).subtract(ey.multiply((FieldElement)cosLE));
        CalculusFieldElement den = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epsilon.add(1.0)).subtract(ex.multiply((FieldElement)cosLE))).subtract(ey.multiply((FieldElement)sinLE));
        return (T)((CalculusFieldElement)lE.add(((CalculusFieldElement)((CalculusFieldElement)num.divide((FieldElement)den)).atan()).multiply(2)));
    }

    public static <T extends CalculusFieldElement<T>> T trueToEccentric(T lv, T ex, T ey) {
        CalculusFieldElement epsilon = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.multiply(ex)).add(ey.multiply(ey))).negate()).add(1.0)).sqrt();
        FieldSinCos scLv = FastMath.sinCos(lv);
        CalculusFieldElement cosLv = (CalculusFieldElement)scLv.cos();
        CalculusFieldElement sinLv = (CalculusFieldElement)scLv.sin();
        CalculusFieldElement num = (CalculusFieldElement)((CalculusFieldElement)ey.multiply((FieldElement)cosLv)).subtract(ex.multiply((FieldElement)sinLv));
        CalculusFieldElement den = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epsilon.add(1.0)).add(ex.multiply((FieldElement)cosLv))).add(ey.multiply((FieldElement)sinLv));
        return (T)((CalculusFieldElement)lv.add(((CalculusFieldElement)((CalculusFieldElement)num.divide((FieldElement)den)).atan()).multiply(2)));
    }

    public static <T extends CalculusFieldElement<T>> T meanToEccentric(T lM, T ex, T ey) {
        Object lE = lM;
        CalculusFieldElement shift = (CalculusFieldElement)lM.getField().getZero();
        CalculusFieldElement lEmlM = (CalculusFieldElement)lM.getField().getZero();
        FieldSinCos scLE = FastMath.sinCos(lE);
        int iter = 0;
        do {
            CalculusFieldElement f2 = (CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)scLE.sin())).subtract(ey.multiply((FieldElement)scLE.cos()));
            CalculusFieldElement f1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)scLE.cos())).add(ey.multiply((FieldElement)scLE.sin()))).negate()).add(1.0);
            CalculusFieldElement f0 = (CalculusFieldElement)lEmlM.subtract((FieldElement)f2);
            CalculusFieldElement f12 = (CalculusFieldElement)f1.multiply(2.0);
            shift = (CalculusFieldElement)((CalculusFieldElement)f0.multiply((FieldElement)f12)).divide(((CalculusFieldElement)f1.multiply((FieldElement)f12)).subtract(f0.multiply((FieldElement)f2)));
            lEmlM = (CalculusFieldElement)lEmlM.subtract((FieldElement)shift);
            lE = (CalculusFieldElement)lM.add((FieldElement)lEmlM);
            scLE = FastMath.sinCos(lE);
        } while (++iter < 50 && FastMath.abs((double)shift.getReal()) > 1.0E-12);
        return lE;
    }

    public static <T extends CalculusFieldElement<T>> T eccentricToMean(T lE, T ex, T ey) {
        FieldSinCos scLE = FastMath.sinCos(lE);
        return (T)((CalculusFieldElement)((CalculusFieldElement)lE.subtract(ex.multiply((FieldElement)scLE.sin()))).add(ey.multiply((FieldElement)scLE.cos())));
    }

    @Override
    public T getE() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey))).sqrt());
    }

    @Override
    public T getEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.exDot)).add(this.ey.multiply(this.eyDot))).divide(((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey))).sqrt()));
    }

    @Override
    public T getI() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.hx.multiply(this.hx)).add(this.hy.multiply(this.hy))).sqrt()).atan()).multiply(2));
    }

    @Override
    public T getIDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        CalculusFieldElement h2 = (CalculusFieldElement)((CalculusFieldElement)this.hx.multiply(this.hx)).add(this.hy.multiply(this.hy));
        CalculusFieldElement h = (CalculusFieldElement)h2.sqrt();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.hx.multiply(this.hxDot)).add(this.hy.multiply(this.hyDot))).multiply(2)).divide(h.multiply(h2.add(1.0))));
    }

    private void computePVWithoutA() {
        if (this.partialPV != null) {
            return;
        }
        T lE = this.getLE();
        CalculusFieldElement hx2 = (CalculusFieldElement)this.hx.multiply(this.hx);
        CalculusFieldElement hy2 = (CalculusFieldElement)this.hy.multiply(this.hy);
        CalculusFieldElement factH = (CalculusFieldElement)this.one.divide(((CalculusFieldElement)hx2.add(1.0)).add((FieldElement)hy2));
        CalculusFieldElement ux = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).subtract((FieldElement)hy2)).multiply((FieldElement)factH);
        CalculusFieldElement uy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.hx.multiply(this.hy)).multiply((FieldElement)factH)).multiply(2);
        CalculusFieldElement uz = (CalculusFieldElement)((CalculusFieldElement)this.hy.multiply(-2)).multiply((FieldElement)factH);
        CalculusFieldElement vx = uy;
        CalculusFieldElement vy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hy2.subtract((FieldElement)hx2)).add(1.0)).multiply((FieldElement)factH);
        CalculusFieldElement vz = (CalculusFieldElement)((CalculusFieldElement)this.hx.multiply((FieldElement)factH)).multiply(2);
        CalculusFieldElement ex2 = (CalculusFieldElement)this.ex.multiply(this.ex);
        CalculusFieldElement exey = (CalculusFieldElement)this.ex.multiply(this.ey);
        CalculusFieldElement ey2 = (CalculusFieldElement)this.ey.multiply(this.ey);
        CalculusFieldElement e2 = (CalculusFieldElement)ex2.add((FieldElement)ey2);
        CalculusFieldElement eta = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.one.subtract((FieldElement)e2)).sqrt()).add(1.0);
        CalculusFieldElement beta = (CalculusFieldElement)this.one.divide((FieldElement)eta);
        FieldSinCos scLe = FastMath.sinCos(lE);
        CalculusFieldElement cLe = (CalculusFieldElement)scLe.cos();
        CalculusFieldElement sLe = (CalculusFieldElement)scLe.sin();
        CalculusFieldElement exCeyS = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)cLe)).add(this.ey.multiply((FieldElement)sLe));
        CalculusFieldElement x = (CalculusFieldElement)this.a.multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.one.subtract(beta.multiply((FieldElement)ey2))).multiply((FieldElement)cLe)).add(((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)sLe))).subtract(this.ex));
        CalculusFieldElement y = (CalculusFieldElement)this.a.multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.one.subtract(beta.multiply((FieldElement)ex2))).multiply((FieldElement)sLe)).add(((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)cLe))).subtract(this.ey));
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getMu().divide(this.a)).sqrt()).divide(this.one.subtract((FieldElement)exCeyS));
        CalculusFieldElement xdot = (CalculusFieldElement)factor.multiply(((CalculusFieldElement)sLe.negate()).add(((CalculusFieldElement)beta.multiply(this.ey)).multiply((FieldElement)exCeyS)));
        CalculusFieldElement ydot = (CalculusFieldElement)factor.multiply(cLe.subtract(((CalculusFieldElement)beta.multiply(this.ex)).multiply((FieldElement)exCeyS)));
        FieldVector3D position = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)ux)).add(y.multiply((FieldElement)vx)), (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)uy)).add(y.multiply((FieldElement)vy)), (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)uz)).add(y.multiply((FieldElement)vz)));
        FieldVector3D velocity = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)xdot.multiply((FieldElement)ux)).add(ydot.multiply((FieldElement)vx)), (CalculusFieldElement)((CalculusFieldElement)xdot.multiply((FieldElement)uy)).add(ydot.multiply((FieldElement)vy)), (CalculusFieldElement)((CalculusFieldElement)xdot.multiply((FieldElement)uz)).add(ydot.multiply((FieldElement)vz)));
        this.partialPV = new FieldPVCoordinates(position, velocity);
    }

    private FieldVector3D<T> nonKeplerianAcceleration() {
        CalculusFieldElement[][] dCdP = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
        this.getJacobianWrtParameters(PositionAngle.MEAN, dCdP);
        CalculusFieldElement nonKeplerianMeanMotion = (CalculusFieldElement)this.getLMDot().subtract(this.getKeplerianMeanMotion());
        CalculusFieldElement nonKeplerianAx = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[3][0].multiply(this.aDot)).add(dCdP[3][1].multiply(this.exDot))).add(dCdP[3][2].multiply(this.eyDot))).add(dCdP[3][3].multiply(this.hxDot))).add(dCdP[3][4].multiply(this.hyDot))).add(dCdP[3][5].multiply((FieldElement)nonKeplerianMeanMotion));
        CalculusFieldElement nonKeplerianAy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[4][0].multiply(this.aDot)).add(dCdP[4][1].multiply(this.exDot))).add(dCdP[4][2].multiply(this.eyDot))).add(dCdP[4][3].multiply(this.hxDot))).add(dCdP[4][4].multiply(this.hyDot))).add(dCdP[4][5].multiply((FieldElement)nonKeplerianMeanMotion));
        CalculusFieldElement nonKeplerianAz = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[5][0].multiply(this.aDot)).add(dCdP[5][1].multiply(this.exDot))).add(dCdP[5][2].multiply(this.eyDot))).add(dCdP[5][3].multiply(this.hxDot))).add(dCdP[5][4].multiply(this.hyDot))).add(dCdP[5][5].multiply((FieldElement)nonKeplerianMeanMotion));
        return new FieldVector3D(nonKeplerianAx, nonKeplerianAy, nonKeplerianAz);
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        this.computePVWithoutA();
        CalculusFieldElement r2 = this.partialPV.getPosition().getNormSq();
        FieldVector3D keplerianAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply(r2.sqrt())).reciprocal()).multiply(this.getMu().negate()), this.partialPV.getPosition());
        FieldVector3D acceleration = this.hasDerivatives() ? keplerianAcceleration.add(this.nonKeplerianAcceleration()) : keplerianAcceleration;
        return new TimeStampedFieldPVCoordinates(this.getDate(), this.partialPV.getPosition(), this.partialPV.getVelocity(), acceleration);
    }

    @Override
    public FieldEquinoctialOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((CalculusFieldElement)((CalculusFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public FieldEquinoctialOrbit<T> shiftedBy(T dt) {
        FieldEquinoctialOrbit<CalculusFieldElement> keplerianShifted = new FieldEquinoctialOrbit<CalculusFieldElement>((CalculusFieldElement)this.a, (CalculusFieldElement)this.ex, (CalculusFieldElement)this.ey, (CalculusFieldElement)this.hx, (CalculusFieldElement)this.hy, (CalculusFieldElement)this.getLM().add(this.getKeplerianMeanMotion().multiply(dt)), PositionAngle.MEAN, this.getFrame(), this.getDate().shiftedBy(dt), (CalculusFieldElement)this.getMu());
        if (this.hasDerivatives()) {
            FieldVector3D<T> nonKeplerianAcceleration = this.nonKeplerianAcceleration();
            super.computePVWithoutA();
            FieldVector3D fixedP = new FieldVector3D(this.one, keplerianShifted.partialPV.getPosition(), (CalculusFieldElement)((CalculusFieldElement)dt.multiply(dt)).multiply(0.5), nonKeplerianAcceleration);
            CalculusFieldElement fixedR2 = fixedP.getNormSq();
            CalculusFieldElement fixedR = (CalculusFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.one, keplerianShifted.partialPV.getVelocity(), dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fixedR2.multiply((FieldElement)fixedR)).reciprocal()).multiply(this.getMu().negate()), keplerianShifted.partialPV.getPosition(), this.one, nonKeplerianAcceleration);
            return new FieldEquinoctialOrbit(new TimeStampedFieldPVCoordinates(keplerianShifted.getDate(), fixedP, fixedV, fixedA), keplerianShifted.getFrame(), keplerianShifted.getMu());
        }
        return keplerianShifted;
    }

    @Override
    public FieldEquinoctialOrbit<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldOrbit<T>> sample) {
        List list = sample.collect(Collectors.toList());
        boolean useDerivatives = true;
        for (FieldOrbit orbit : list) {
            useDerivatives = useDerivatives && orbit.hasDerivatives();
        }
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate previousDate = null;
        Object previousLm = (CalculusFieldElement)this.zero.add(Double.NaN);
        for (FieldOrbit orbit : list) {
            Object continuousLm;
            FieldEquinoctialOrbit equi = (FieldEquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(orbit);
            if (previousDate == null) {
                continuousLm = equi.getLM();
            } else {
                Object dt = equi.getDate().durationFrom(previousDate);
                CalculusFieldElement keplerLm = (CalculusFieldElement)previousLm.add((FieldElement)((CalculusFieldElement)equi.getKeplerianMeanMotion().multiply(dt)));
                continuousLm = MathUtils.normalizeAngle(equi.getLM(), (CalculusFieldElement)keplerLm);
            }
            previousDate = equi.getDate();
            previousLm = continuousLm;
            CalculusFieldElement[] toAdd = (CalculusFieldElement[])MathArrays.buildArray(this.field, (int)6);
            toAdd[0] = equi.getA();
            toAdd[1] = equi.getEquinoctialEx();
            toAdd[2] = equi.getEquinoctialEy();
            toAdd[3] = equi.getHx();
            toAdd[4] = equi.getHy();
            toAdd[5] = continuousLm;
            if (useDerivatives) {
                CalculusFieldElement[] toAddDot = (CalculusFieldElement[])MathArrays.buildArray((Field)this.one.getField(), (int)6);
                toAddDot[0] = equi.getADot();
                toAddDot[1] = equi.getEquinoctialExDot();
                toAddDot[2] = equi.getEquinoctialEyDot();
                toAddDot[3] = equi.getHxDot();
                toAddDot[4] = equi.getHyDot();
                toAddDot[5] = equi.getLMDot();
                interpolator.addSamplePoint(equi.getDate().durationFrom(date), (FieldElement[][])new CalculusFieldElement[][]{toAdd, toAddDot});
                continue;
            }
            interpolator.addSamplePoint(equi.getDate().durationFrom(date), (FieldElement[][])new CalculusFieldElement[][]{toAdd});
        }
        CalculusFieldElement[][] interpolated = (CalculusFieldElement[][])interpolator.derivatives(this.zero, 1);
        return new FieldEquinoctialOrbit<CalculusFieldElement>(interpolated[0][0], interpolated[0][1], interpolated[0][2], interpolated[0][3], interpolated[0][4], interpolated[0][5], interpolated[1][0], interpolated[1][1], interpolated[1][2], interpolated[1][3], interpolated[1][4], interpolated[1][5], PositionAngle.MEAN, this.getFrame(), (FieldAbsoluteDate<CalculusFieldElement>)date, (CalculusFieldElement)this.getMu());
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray(this.field, (int)6, (int)6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        CalculusFieldElement r2 = position.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement r3 = (CalculusFieldElement)r.multiply((FieldElement)r2);
        Object mu = this.getMu();
        CalculusFieldElement sqrtMuA = (CalculusFieldElement)((CalculusFieldElement)this.a.multiply(mu)).sqrt();
        CalculusFieldElement a2 = (CalculusFieldElement)this.a.multiply(this.a);
        CalculusFieldElement e2 = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey));
        CalculusFieldElement oMe2 = (CalculusFieldElement)this.one.subtract((FieldElement)e2);
        CalculusFieldElement epsilon = (CalculusFieldElement)oMe2.sqrt();
        CalculusFieldElement beta = (CalculusFieldElement)this.one.divide(epsilon.add(1.0));
        CalculusFieldElement ratio = (CalculusFieldElement)epsilon.multiply((FieldElement)beta);
        CalculusFieldElement hx2 = (CalculusFieldElement)this.hx.multiply(this.hx);
        CalculusFieldElement hy2 = (CalculusFieldElement)this.hy.multiply(this.hy);
        CalculusFieldElement hxhy = (CalculusFieldElement)this.hx.multiply(this.hy);
        FieldVector3D f = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)hx2.subtract((FieldElement)hy2)).add(1.0), (CalculusFieldElement)hxhy.multiply(2), (CalculusFieldElement)this.hy.multiply(-2)).normalize();
        FieldVector3D g = new FieldVector3D((CalculusFieldElement)hxhy.multiply(2), (CalculusFieldElement)((CalculusFieldElement)hy2.add(1.0)).subtract((FieldElement)hx2), (CalculusFieldElement)this.hx.multiply(2)).normalize();
        FieldVector3D w = FieldVector3D.crossProduct(position, velocity).normalize();
        CalculusFieldElement x = FieldVector3D.dotProduct(position, (FieldVector3D)f);
        CalculusFieldElement y = FieldVector3D.dotProduct(position, (FieldVector3D)g);
        CalculusFieldElement xDot = FieldVector3D.dotProduct(velocity, (FieldVector3D)f);
        CalculusFieldElement yDot = FieldVector3D.dotProduct(velocity, (FieldVector3D)g);
        CalculusFieldElement c1 = (CalculusFieldElement)this.a.divide(sqrtMuA.multiply((FieldElement)epsilon));
        CalculusFieldElement c1N = (CalculusFieldElement)c1.negate();
        CalculusFieldElement c2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a.multiply((FieldElement)sqrtMuA)).multiply((FieldElement)beta)).divide((FieldElement)r3);
        CalculusFieldElement c3 = (CalculusFieldElement)sqrtMuA.divide(r3.multiply((FieldElement)epsilon));
        FieldVector3D drDotSdEx = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c1.multiply((FieldElement)xDot)).multiply((FieldElement)yDot)).subtract(((CalculusFieldElement)c2.multiply(this.ey)).multiply((FieldElement)x))).subtract(((CalculusFieldElement)c3.multiply((FieldElement)x)).multiply((FieldElement)y)), f, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c1N.multiply((FieldElement)xDot)).multiply((FieldElement)xDot)).subtract(((CalculusFieldElement)c2.multiply(this.ey)).multiply((FieldElement)y))).add(((CalculusFieldElement)c3.multiply((FieldElement)x)).multiply((FieldElement)x)), g);
        FieldVector3D drDotSdEy = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c1.multiply((FieldElement)yDot)).multiply((FieldElement)yDot)).add(((CalculusFieldElement)c2.multiply(this.ex)).multiply((FieldElement)x))).subtract(((CalculusFieldElement)c3.multiply((FieldElement)y)).multiply((FieldElement)y)), f, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c1N.multiply((FieldElement)xDot)).multiply((FieldElement)yDot)).add(((CalculusFieldElement)c2.multiply(this.ex)).multiply((FieldElement)y))).add(((CalculusFieldElement)c3.multiply((FieldElement)x)).multiply((FieldElement)y)), g);
        FieldVector3D vectorAR = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)a2.multiply(2)).divide((FieldElement)r3), position);
        FieldVector3D vectorARDot = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)a2.multiply(2)).divide(mu), velocity);
        this.fillHalfRow((CalculusFieldElement)this.one, vectorAR, jacobian[0], 0);
        this.fillHalfRow((CalculusFieldElement)this.one, vectorARDot, jacobian[0], 3);
        CalculusFieldElement d1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a.negate()).multiply((FieldElement)ratio)).divide((FieldElement)r3);
        CalculusFieldElement d2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.hy.multiply((FieldElement)xDot)).subtract(this.hx.multiply((FieldElement)yDot))).divide(sqrtMuA.multiply((FieldElement)epsilon));
        CalculusFieldElement d3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.hx.multiply((FieldElement)y)).subtract(this.hy.multiply((FieldElement)x))).divide((FieldElement)sqrtMuA);
        FieldVector3D vectorExRDot = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(2)).multiply((FieldElement)yDot)).subtract(xDot.multiply((FieldElement)y))).divide(mu), g, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)y.negate()).multiply((FieldElement)yDot)).divide(mu), f, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ey.negate()).multiply((FieldElement)d3)).divide((FieldElement)epsilon), w);
        this.fillHalfRow((CalculusFieldElement)this.ex.multiply((FieldElement)d1), position, (CalculusFieldElement)((CalculusFieldElement)this.ey.negate()).multiply((FieldElement)d2), w, (CalculusFieldElement)epsilon.divide((FieldElement)sqrtMuA), drDotSdEy, jacobian[1], 0);
        this.fillHalfRow((CalculusFieldElement)this.one, vectorExRDot, jacobian[1], 3);
        FieldVector3D vectorEyRDot = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xDot.multiply(2)).multiply((FieldElement)y)).subtract(x.multiply((FieldElement)yDot))).divide(mu), f, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.negate()).multiply((FieldElement)xDot)).divide(mu), g, (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)d3)).divide((FieldElement)epsilon), w);
        this.fillHalfRow((CalculusFieldElement)this.ey.multiply((FieldElement)d1), position, (CalculusFieldElement)this.ex.multiply((FieldElement)d2), w, (CalculusFieldElement)((CalculusFieldElement)epsilon.negate()).divide((FieldElement)sqrtMuA), drDotSdEx, jacobian[2], 0);
        this.fillHalfRow((CalculusFieldElement)this.one, vectorEyRDot, jacobian[2], 3);
        CalculusFieldElement h = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).add((FieldElement)hy2)).divide(((CalculusFieldElement)sqrtMuA.multiply(2)).multiply((FieldElement)epsilon));
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)h.negate()).multiply((FieldElement)xDot), w, jacobian[3], 0);
        this.fillHalfRow((CalculusFieldElement)h.multiply((FieldElement)x), w, jacobian[3], 3);
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)h.negate()).multiply((FieldElement)yDot), w, jacobian[4], 0);
        this.fillHalfRow((CalculusFieldElement)h.multiply((FieldElement)y), w, jacobian[4], 3);
        CalculusFieldElement l = (CalculusFieldElement)((CalculusFieldElement)ratio.negate()).divide((FieldElement)sqrtMuA);
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)this.one.negate()).divide((FieldElement)sqrtMuA), velocity, d2, w, (CalculusFieldElement)l.multiply(this.ex), drDotSdEx, (CalculusFieldElement)l.multiply(this.ey), drDotSdEy, jacobian[5], 0);
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)this.zero.add(-2.0)).divide((FieldElement)sqrtMuA), position, (CalculusFieldElement)this.ex.multiply((FieldElement)beta), vectorEyRDot, (CalculusFieldElement)((CalculusFieldElement)this.ey.negate()).multiply((FieldElement)beta), vectorExRDot, d3, w, jacobian[5], 3);
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        CalculusFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesian();
        FieldSinCos scLe = FastMath.sinCos(this.getLE());
        CalculusFieldElement cosLe = (CalculusFieldElement)scLe.cos();
        CalculusFieldElement sinLe = (CalculusFieldElement)scLe.sin();
        CalculusFieldElement aOr = (CalculusFieldElement)this.one.divide(((CalculusFieldElement)this.one.subtract(this.ex.multiply((FieldElement)cosLe))).subtract(this.ey.multiply((FieldElement)sinLe)));
        CalculusFieldElement[] rowEx = jacobian[1];
        CalculusFieldElement[] rowEy = jacobian[2];
        CalculusFieldElement[] rowL = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowL[j] = (CalculusFieldElement)aOr.multiply(((CalculusFieldElement)rowL[j].add(sinLe.multiply((FieldElement)rowEx[j]))).subtract(cosLe.multiply((FieldElement)rowEy[j])));
        }
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        CalculusFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesian();
        FieldSinCos scLe = FastMath.sinCos(this.getLE());
        CalculusFieldElement cosLe = (CalculusFieldElement)scLe.cos();
        CalculusFieldElement sinLe = (CalculusFieldElement)scLe.sin();
        CalculusFieldElement eSinE = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)sinLe)).subtract(this.ey.multiply((FieldElement)cosLe));
        CalculusFieldElement ecosE = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)cosLe)).add(this.ey.multiply((FieldElement)sinLe));
        CalculusFieldElement e2 = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey));
        CalculusFieldElement epsilon = (CalculusFieldElement)((CalculusFieldElement)this.one.subtract((FieldElement)e2)).sqrt();
        CalculusFieldElement onePeps = (CalculusFieldElement)epsilon.add(1.0);
        CalculusFieldElement d = (CalculusFieldElement)onePeps.subtract((FieldElement)ecosE);
        CalculusFieldElement cT = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)d.multiply((FieldElement)d)).add(eSinE.multiply((FieldElement)eSinE))).divide(2.0);
        CalculusFieldElement cE = (CalculusFieldElement)((CalculusFieldElement)ecosE.multiply((FieldElement)onePeps)).subtract((FieldElement)e2);
        CalculusFieldElement cX = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)eSinE)).divide((FieldElement)epsilon)).subtract(this.ey)).add(sinLe.multiply((FieldElement)onePeps));
        CalculusFieldElement cY = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)eSinE)).divide((FieldElement)epsilon)).add(this.ex)).subtract(cosLe.multiply((FieldElement)onePeps));
        CalculusFieldElement factorLe = (CalculusFieldElement)((CalculusFieldElement)cT.add((FieldElement)cE)).divide((FieldElement)cT);
        CalculusFieldElement factorEx = (CalculusFieldElement)cX.divide((FieldElement)cT);
        CalculusFieldElement factorEy = (CalculusFieldElement)cY.divide((FieldElement)cT);
        CalculusFieldElement[] rowEx = jacobian[1];
        CalculusFieldElement[] rowEy = jacobian[2];
        CalculusFieldElement[] rowL = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowL[j] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)factorLe.multiply((FieldElement)rowL[j])).add(factorEx.multiply((FieldElement)rowEx[j]))).add(factorEy.multiply((FieldElement)rowEy[j]));
        }
        return jacobian;
    }

    @Override
    public void addKeplerContribution(PositionAngle type, T gm, T[] pDot) {
        CalculusFieldElement n = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)gm.divide(this.a)).sqrt()).divide(this.a);
        FieldSinCos sc = FastMath.sinCos(this.lv);
        switch (type) {
            case MEAN: {
                pDot[5] = (CalculusFieldElement)pDot[5].add((FieldElement)n);
                break;
            }
            case ECCENTRIC: {
                CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)this.one.subtract(this.ex.multiply(this.ex))).subtract(this.ey.multiply(this.ey));
                CalculusFieldElement ksi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)sc.cos())).add(1.0)).add(this.ey.multiply((FieldElement)sc.sin()));
                pDot[5] = (CalculusFieldElement)pDot[5].add(((CalculusFieldElement)n.multiply((FieldElement)ksi)).divide((FieldElement)oMe2));
                break;
            }
            case TRUE: {
                CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)this.one.subtract(this.ex.multiply(this.ex))).subtract(this.ey.multiply(this.ey));
                CalculusFieldElement ksi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)sc.cos())).add(1.0)).add(this.ey.multiply((FieldElement)sc.sin()));
                pDot[5] = (CalculusFieldElement)pDot[5].add(((CalculusFieldElement)((CalculusFieldElement)n.multiply((FieldElement)ksi)).multiply((FieldElement)ksi)).divide(oMe2.multiply(oMe2.sqrt())));
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
    }

    public String toString() {
        return "equinoctial parameters: " + '{' + "a: " + this.a.getReal() + "; ex: " + this.ex.getReal() + "; ey: " + this.ey.getReal() + "; hx: " + this.hx.getReal() + "; hy: " + this.hy.getReal() + "; lv: " + FastMath.toDegrees((double)this.lv.getReal()) + ";}";
    }

    @Override
    public EquinoctialOrbit toOrbit() {
        if (this.hasDerivatives()) {
            return new EquinoctialOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.hx.getReal(), this.hy.getReal(), this.lv.getReal(), this.aDot.getReal(), this.exDot.getReal(), this.eyDot.getReal(), this.hxDot.getReal(), this.hyDot.getReal(), this.lvDot.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
        }
        return new EquinoctialOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.hx.getReal(), this.hy.getReal(), this.lv.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
    }
}

