/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.ntrip;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.metric.ntrip.CasterRecord;
import org.orekit.gnss.metric.ntrip.DataStreamRecord;
import org.orekit.gnss.metric.ntrip.MessageObserver;
import org.orekit.gnss.metric.ntrip.NetworkRecord;
import org.orekit.gnss.metric.ntrip.RecordType;
import org.orekit.gnss.metric.ntrip.SourceTable;
import org.orekit.gnss.metric.ntrip.StreamMonitor;
import org.orekit.gnss.metric.ntrip.Type;

public class NtripClient {
    public static final int DEFAULT_TIMEOUT = 10000;
    public static final int DEFAULT_PORT = 2101;
    public static final double DEFAULT_RECONNECT_DELAY = 1.0;
    public static final double DEFAULT_RECONNECT_DELAY_FACTOR = 1.5;
    public static final int DEFAULT_MAX_RECONNECT = 20;
    private static final String HOST_HEADER_KEY = "Host";
    private static final String USER_AGENT_HEADER_KEY = "User-Agent";
    private static final String USER_AGENT_HEADER_VALUE = "NTRIP orekit/11.0";
    private static final String VERSION_HEADER_KEY = "Ntrip-Version";
    private static final String VERSION_HEADER_VALUE = "Ntrip/2.0";
    private static final String CONNECTION_HEADER_KEY = "Connection";
    private static final String CONNECTION_HEADER_VALUE = "close";
    private static final String FLAGS_HEADER_KEY = "Ntrip-Flags";
    private static final String SOURCETABLE_CONTENT_TYPE = "gnss/sourcetable";
    private static final double DEG_TO_MINUTES = 60.0;
    private final String host;
    private final int port;
    private double reconnectDelay;
    private double reconnectDelayFactor;
    private int maxRetries;
    private int timeout;
    private Proxy proxy;
    private AtomicReference<String> gga;
    private final List<ObserverHolder> observers;
    private final Map<String, StreamMonitor> monitors;
    private SourceTable sourceTable;
    private ExecutorService executorService;

    public NtripClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.observers = new ArrayList<ObserverHolder>();
        this.monitors = new HashMap<String, StreamMonitor>();
        this.setTimeout(10000);
        this.setReconnectParameters(1.0, 1.5, 20);
        this.setProxy(Proxy.Type.DIRECT, null, -1);
        this.gga = new AtomicReference<Object>(null);
        this.sourceTable = null;
        this.executorService = null;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setReconnectParameters(double delay, double delayFactor, int max) {
        this.reconnectDelay = delay;
        this.reconnectDelayFactor = delayFactor;
        this.maxRetries = max;
    }

    public void setProxy(Proxy.Type type, String proxyHost, int proxyPort) {
        try {
            if (type == Proxy.Type.DIRECT) {
                this.proxy = Proxy.NO_PROXY;
            } else {
                InetAddress hostAddress = InetAddress.getByName(proxyHost);
                InetSocketAddress proxyAddress = new InetSocketAddress(hostAddress, proxyPort);
                this.proxy = new Proxy(type, proxyAddress);
            }
        }
        catch (UnknownHostException uhe) {
            throw new OrekitException(uhe, OrekitMessages.UNKNOWN_HOST, proxyHost);
        }
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setFix(int hour, int minute, double second, double latitude, double longitude, double ellAltitude, double undulation) {
        double latDeg = FastMath.abs((double)FastMath.toDegrees((double)latitude));
        int dLat = (int)FastMath.floor((double)latDeg);
        double mLat = 60.0 * (latDeg - (double)dLat);
        char cLat = latitude >= 0.0 ? (char)'N' : 'S';
        double lonDeg = FastMath.abs((double)FastMath.toDegrees((double)longitude));
        int dLon = (int)FastMath.floor((double)lonDeg);
        double mLon = 60.0 * (lonDeg - (double)dLon);
        char cLon = longitude >= 0.0 ? (char)'E' : 'W';
        StringBuilder builder = new StringBuilder(82);
        try (Formatter formatter = new Formatter(builder, Locale.US);){
            boolean fixQuality = true;
            int nbSat = 4;
            double hdop = 1.0;
            formatter.format("$GPGGA,%02d%02d%06.3f,%02d%07.4f,%c,%02d%07.4f,%c,%1d,%02d,%3.1f,%.1f,M,%.1f,M,,", hour, minute, second, dLat, mLat, Character.valueOf(cLat), dLon, mLon, Character.valueOf(cLon), 1, 4, 1.0, ellAltitude, undulation);
            byte sum = 0;
            for (int i = 1; i < builder.length(); ++i) {
                sum = (byte)(sum ^ builder.charAt(i));
            }
            formatter.format("*%02X", sum);
        }
        this.gga.set(builder.toString());
    }

    String getGGA() {
        return this.gga.get();
    }

    public void addObserver(int typeCode, String mountPoint, MessageObserver observer) {
        this.observers.add(new ObserverHolder(typeCode, mountPoint, observer));
        for (Map.Entry<String, StreamMonitor> entry : this.monitors.entrySet()) {
            if (mountPoint != null && !mountPoint.equals(entry.getKey())) continue;
            entry.getValue().addObserver(typeCode, observer);
        }
    }

    public SourceTable getSourceTable() {
        if (this.sourceTable == null) {
            try {
                HttpURLConnection connection = this.connect("");
                int responseCode = connection.getResponseCode();
                if (responseCode == 401) {
                    throw new OrekitException((Localizable)OrekitMessages.FAILED_AUTHENTICATION, "caster");
                }
                if (responseCode != 200) {
                    throw new OrekitException((Localizable)OrekitMessages.CONNECTION_ERROR, this.host, connection.getResponseMessage());
                }
                if (!SOURCETABLE_CONTENT_TYPE.equals(connection.getContentType())) {
                    throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_CONTENT_TYPE, connection.getContentType());
                }
                SourceTable table = new SourceTable(this.getHeaderValue(connection, FLAGS_HEADER_KEY));
                try (InputStream is = connection.getInputStream();
                     InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                     BufferedReader br = new BufferedReader(isr);){
                    int lineNumber = 0;
                    String line = br.readLine();
                    while (line != null) {
                        ++lineNumber;
                        if ((line = line.trim()).length() != 0) {
                            if (line.startsWith(RecordType.CAS.toString())) {
                                table.addCasterRecord(new CasterRecord(line));
                            } else if (line.startsWith(RecordType.NET.toString())) {
                                table.addNetworkRecord(new NetworkRecord(line));
                            } else if (line.startsWith(RecordType.STR.toString())) {
                                table.addDataStreamRecord(new DataStreamRecord(line));
                            } else {
                                if (line.startsWith("ENDSOURCETABLE")) {
                                    break;
                                }
                                throw new OrekitException((Localizable)OrekitMessages.SOURCETABLE_PARSE_ERROR, connection.getURL().getHost(), lineNumber, line);
                            }
                        }
                        line = br.readLine();
                    }
                }
                this.sourceTable = table;
                return table;
            }
            catch (IOException ioe) {
                throw new OrekitException(ioe, OrekitMessages.CANNOT_PARSE_SOURCETABLE, this.host);
            }
        }
        return this.sourceTable;
    }

    public void startStreaming(String mountPoint, Type type, boolean requiresNMEA, boolean ignoreUnknownMessageTypes) {
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(this.getSourceTable().getDataStreams().size());
        }
        if (this.monitors.containsKey(mountPoint)) {
            throw new OrekitException((Localizable)OrekitMessages.MOUNPOINT_ALREADY_CONNECTED, mountPoint);
        }
        StreamMonitor monitor = new StreamMonitor(this, mountPoint, type, requiresNMEA, ignoreUnknownMessageTypes, this.reconnectDelay, this.reconnectDelayFactor, this.maxRetries);
        this.monitors.put(mountPoint, monitor);
        for (ObserverHolder observerHolder : this.observers) {
            if (observerHolder.mountPoint != null && !observerHolder.mountPoint.equals(mountPoint)) continue;
            monitor.addObserver(observerHolder.typeCode, observerHolder.observer);
        }
        this.executorService.execute(monitor);
    }

    public void checkException() {
        for (Map.Entry<String, StreamMonitor> entry : this.monitors.entrySet()) {
            OrekitException exception = entry.getValue().getException();
            if (exception == null) continue;
            throw exception;
        }
    }

    public void stopStreaming(int time) {
        for (Map.Entry<String, StreamMonitor> entry : this.monitors.entrySet()) {
            entry.getValue().stopMonitoring();
        }
        try {
            this.executorService.awaitTermination(time, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        this.checkException();
    }

    HttpURLConnection connect(String mountPoint) throws IOException {
        String protocol = "http";
        URL casterURL = new URL("http", this.host, this.port, "/" + mountPoint);
        HttpURLConnection connection = (HttpURLConnection)casterURL.openConnection(this.proxy);
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        connection.setRequestProperty(HOST_HEADER_KEY, this.host);
        connection.setRequestProperty(VERSION_HEADER_KEY, VERSION_HEADER_VALUE);
        connection.setRequestProperty(USER_AGENT_HEADER_KEY, USER_AGENT_HEADER_VALUE);
        connection.setRequestProperty(CONNECTION_HEADER_KEY, CONNECTION_HEADER_VALUE);
        return connection;
    }

    private String getHeaderValue(URLConnection connection, String key) {
        String value = connection.getHeaderField(key);
        if (value == null) {
            throw new OrekitException((Localizable)OrekitMessages.MISSING_HEADER, connection.getURL().getHost(), key);
        }
        return value;
    }

    private static class ObserverHolder {
        private final int typeCode;
        private final String mountPoint;
        private final MessageObserver observer;

        ObserverHolder(int typeCode, String mountPoint, MessageObserver observer) {
            this.typeCode = typeCode;
            this.mountPoint = mountPoint;
            this.observer = observer;
        }
    }
}

