/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

public enum LOFType {
    TNW{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getVelocity(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_K);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return new FieldRotation(pv.getVelocity(), pv.getMomentum(), new FieldVector3D(field, Vector3D.PLUS_I), new FieldVector3D(field, Vector3D.PLUS_K));
        }
    }
    ,
    QSW{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getPosition(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_K);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return new FieldRotation(pv.getPosition(), pv.getMomentum(), new FieldVector3D(field, Vector3D.PLUS_I), new FieldVector3D(field, Vector3D.PLUS_K));
        }
    }
    ,
    LVLH{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getPosition(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_K);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return new FieldRotation(pv.getPosition(), pv.getMomentum(), new FieldVector3D(field, Vector3D.PLUS_I), new FieldVector3D(field, Vector3D.PLUS_K));
        }
    }
    ,
    LVLH_CCSDS{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getPosition(), pv.getMomentum(), Vector3D.MINUS_K, Vector3D.MINUS_J);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return new FieldRotation(pv.getPosition(), pv.getMomentum(), new FieldVector3D(field, Vector3D.MINUS_K), new FieldVector3D(field, Vector3D.MINUS_J));
        }
    }
    ,
    VVLH{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return LVLH_CCSDS.rotationFromInertial(pv);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return LVLH_CCSDS.rotationFromInertial(field, pv);
        }
    }
    ,
    VNC{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getVelocity(), pv.getMomentum(), Vector3D.PLUS_I, Vector3D.PLUS_J);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return new FieldRotation(pv.getVelocity(), pv.getMomentum(), new FieldVector3D(field, Vector3D.PLUS_I), new FieldVector3D(field, Vector3D.PLUS_J));
        }
    }
    ,
    EQW{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            Vector3D m = pv.getMomentum();
            return new Rotation(new Vector3D(-m.getY(), m.getX(), 0.0), m, Vector3D.PLUS_I, Vector3D.PLUS_J);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            FieldVector3D<T> m = pv.getMomentum();
            return new FieldRotation(new FieldVector3D((CalculusFieldElement)m.getY().negate(), m.getX(), (CalculusFieldElement)field.getZero()), m, new FieldVector3D(field, Vector3D.PLUS_I), new FieldVector3D(field, Vector3D.PLUS_J));
        }
    }
    ,
    NTW{

        @Override
        public Rotation rotationFromInertial(PVCoordinates pv) {
            return new Rotation(pv.getVelocity(), pv.getMomentum(), Vector3D.PLUS_J, Vector3D.PLUS_K);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> field, FieldPVCoordinates<T> pv) {
            return new FieldRotation(pv.getVelocity(), pv.getMomentum(), new FieldVector3D(field, Vector3D.PLUS_J), new FieldVector3D(field, Vector3D.PLUS_K));
        }
    };


    public Transform transformFromInertial(AbsoluteDate date, PVCoordinates pv) {
        Transform translation = new Transform(date, pv.negate());
        Rotation r = this.rotationFromInertial(pv);
        Vector3D p = pv.getPosition();
        Vector3D momentum = pv.getMomentum();
        Transform rotation = new Transform(date, r, new Vector3D(1.0 / p.getNormSq(), r.applyTo(momentum)));
        return new Transform(date, translation, rotation);
    }

    public <T extends CalculusFieldElement<T>> FieldTransform<T> transformFromInertial(FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pv) {
        FieldTransform<T> translation = new FieldTransform<T>(date, pv.negate());
        FieldRotation<T> r = this.rotationFromInertial(date.getField(), pv);
        FieldVector3D<T> p = pv.getPosition();
        FieldVector3D<T> momentum = pv.getMomentum();
        FieldTransform<T> rotation = new FieldTransform<T>(date, r, new FieldVector3D((CalculusFieldElement)p.getNormSq().reciprocal(), r.applyTo(momentum)));
        return new FieldTransform<T>(date, translation, rotation);
    }

    public abstract Rotation rotationFromInertial(PVCoordinates var1);

    public abstract <T extends CalculusFieldElement<T>> FieldRotation<T> rotationFromInertial(Field<T> var1, FieldPVCoordinates<T> var2);
}

