/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.trigger;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.forces.maneuvers.trigger.IntervalEventTrigger;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.FieldParameterDrivenDateIntervalDetector;
import org.orekit.propagation.events.ParameterDrivenDateIntervalDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class DateBasedManeuverTriggers
extends IntervalEventTrigger<ParameterDrivenDateIntervalDetector> {
    public static final String DEFAULT_NAME = "";
    private final String name;

    public DateBasedManeuverTriggers(AbsoluteDate date, double duration) {
        this(DEFAULT_NAME, date, duration);
    }

    public DateBasedManeuverTriggers(String name, AbsoluteDate date, double duration) {
        super(DateBasedManeuverTriggers.createDetector(name, date, duration));
        this.name = name;
    }

    private static ParameterDrivenDateIntervalDetector createDetector(String prefix, AbsoluteDate date, double duration) {
        if (duration >= 0.0) {
            return new ParameterDrivenDateIntervalDetector(prefix, date, date.shiftedBy(duration));
        }
        return new ParameterDrivenDateIntervalDetector(prefix, date.shiftedBy(duration), date);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public AbsoluteDate getStartDate() {
        return ((ParameterDrivenDateIntervalDetector)this.getFiringIntervalDetector()).getStartDriver().getDate();
    }

    public AbsoluteDate getEndDate() {
        return ((ParameterDrivenDateIntervalDetector)this.getFiringIntervalDetector()).getStopDriver().getDate();
    }

    public double getDuration() {
        return this.getEndDate().durationFrom(this.getStartDate());
    }

    @Override
    protected <D extends FieldEventDetector<S>, S extends CalculusFieldElement<S>> FieldAbstractDetector<D, S> convertIntervalDetector(Field<S> field, ParameterDrivenDateIntervalDetector detector) {
        FieldParameterDrivenDateIntervalDetector<S> fd = new FieldParameterDrivenDateIntervalDetector<S>(field, DEFAULT_NAME, detector.getStartDriver().getBaseDate(), detector.getStopDriver().getBaseDate());
        fd.getStartDriver().setName(detector.getStartDriver().getName());
        fd.getStopDriver().setName(detector.getStopDriver().getName());
        fd.getMedianDriver().setName(detector.getMedianDriver().getName());
        fd.getDurationDriver().setName(detector.getDurationDriver().getName());
        FieldParameterDrivenDateIntervalDetector<S> converted = fd;
        return converted;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Arrays.asList(((ParameterDrivenDateIntervalDetector)this.getFiringIntervalDetector()).getStartDriver(), ((ParameterDrivenDateIntervalDetector)this.getFiringIntervalDetector()).getStopDriver(), ((ParameterDrivenDateIntervalDetector)this.getFiringIntervalDetector()).getMedianDriver(), ((ParameterDrivenDateIntervalDetector)this.getFiringIntervalDetector()).getDurationDriver());
    }
}

