/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.forces.gravity.potential.Flattener;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;

@Deprecated
class PulsatingSphericalHarmonics
implements RawSphericalHarmonicsProvider {
    private final RawSphericalHarmonicsProvider provider;
    private final double pulsation;
    private final Flattener flattener;
    private final double[] cosC;
    private final double[] sinC;
    private final double[] cosS;
    private final double[] sinS;

    @Deprecated
    PulsatingSphericalHarmonics(RawSphericalHarmonicsProvider provider, double period, double[][] cosC, double[][] sinC, double[][] cosS, double[][] sinS) {
        this(provider, period, PulsatingSphericalHarmonics.buildFlattener(cosC), PulsatingSphericalHarmonics.buildFlattener(cosC).flatten(cosC), PulsatingSphericalHarmonics.buildFlattener(sinC).flatten(sinC), PulsatingSphericalHarmonics.buildFlattener(cosS).flatten(cosS), PulsatingSphericalHarmonics.buildFlattener(sinS).flatten(sinS));
    }

    PulsatingSphericalHarmonics(RawSphericalHarmonicsProvider provider, double period, Flattener flattener, double[] cosC, double[] sinC, double[] cosS, double[] sinS) {
        this.provider = provider;
        this.pulsation = Math.PI * 2 / period;
        this.flattener = flattener;
        this.cosC = (double[])cosC.clone();
        this.sinC = (double[])sinC.clone();
        this.cosS = (double[])cosS.clone();
        this.sinS = (double[])sinS.clone();
    }

    private static Flattener buildFlattener(double[][] triangular) {
        return new Flattener(triangular.length - 1, triangular[triangular.length - 1].length - 1);
    }

    @Override
    public int getMaxDegree() {
        return FastMath.max((int)this.flattener.getDegree(), (int)this.provider.getMaxDegree());
    }

    @Override
    public int getMaxOrder() {
        return FastMath.max((int)this.flattener.getOrder(), (int)this.provider.getMaxOrder());
    }

    @Override
    public double getMu() {
        return this.provider.getMu();
    }

    @Override
    public double getAe() {
        return this.provider.getAe();
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        return this.provider.getReferenceDate();
    }

    @Override
    @Deprecated
    public double getOffset(AbsoluteDate date) {
        return this.provider.getOffset(date);
    }

    @Override
    public TideSystem getTideSystem() {
        return this.provider.getTideSystem();
    }

    @Override
    @Deprecated
    public RawSphericalHarmonicsProvider.RawSphericalHarmonics onDate(final AbsoluteDate date) {
        final RawSphericalHarmonicsProvider.RawSphericalHarmonics raw = this.provider.onDate(date);
        double alpha = this.pulsation * this.provider.getOffset(date);
        final SinCos scAlpha = FastMath.sinCos((double)alpha);
        return new RawSphericalHarmonicsProvider.RawSphericalHarmonics(){

            @Override
            public AbsoluteDate getDate() {
                return date;
            }

            @Override
            public double getRawCnm(int n, int m) {
                double cnm = raw.getRawCnm(n, m);
                if (PulsatingSphericalHarmonics.this.flattener.withinRange(n, m)) {
                    cnm += PulsatingSphericalHarmonics.this.cosC[PulsatingSphericalHarmonics.this.flattener.index(n, m)] * scAlpha.cos() + PulsatingSphericalHarmonics.this.sinC[PulsatingSphericalHarmonics.this.flattener.index(n, m)] * scAlpha.sin();
                }
                return cnm;
            }

            @Override
            public double getRawSnm(int n, int m) {
                double snm = raw.getRawSnm(n, m);
                if (PulsatingSphericalHarmonics.this.flattener.withinRange(n, m)) {
                    snm += PulsatingSphericalHarmonics.this.cosS[PulsatingSphericalHarmonics.this.flattener.index(n, m)] * scAlpha.cos() + PulsatingSphericalHarmonics.this.sinS[PulsatingSphericalHarmonics.this.flattener.index(n, m)] * scAlpha.sin();
                }
                return snm;
            }
        };
    }
}

